/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.Element;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnivPowerSeriesTest
extends TestCase {
    UnivPowerSeriesRing<BigRational> fac;
    UnivPowerSeries<BigRational> a;
    UnivPowerSeries<BigRational> b;
    UnivPowerSeries<BigRational> c;
    UnivPowerSeries<BigRational> d;
    UnivPowerSeries<BigRational> e;
    int kl = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UnivPowerSeriesTest.suite());
    }

    public UnivPowerSeriesTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(UnivPowerSeriesTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new UnivPowerSeriesRing<BigRational>(new BigRational(1L));
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        UnivPowerSeriesTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        UnivPowerSeriesTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        UnivPowerSeriesTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        UnivPowerSeriesTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.fac.random(i + 2);
            UnivPowerSeriesTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            UnivPowerSeriesTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        UnivPowerSeriesTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.d = this.c.subtract(this.b);
        UnivPowerSeriesTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.sum(this.b.sum(this.c));
        this.e = this.a.sum(this.b).sum(this.c);
        UnivPowerSeriesTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        UnivPowerSeriesTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        UnivPowerSeriesTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        UnivPowerSeriesTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        UnivPowerSeriesTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        UnivPowerSeriesTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        UnivPowerSeriesTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testQuotRem() {
        this.fac = new UnivPowerSeriesRing<BigRational>(new BigRational(1L));
        this.a = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        Element element = this.fac.random(this.kl);
        UnivPowerSeriesTest.assertTrue((String)"not isZERO( g )", (!((UnivPowerSeries)element).isZERO() ? 1 : 0) != 0);
        this.a = this.a.multiply((UnivPowerSeries<BigRational>)element);
        this.b = this.b.multiply((UnivPowerSeries<BigRational>)element);
        this.c = this.a.gcd(this.b);
        UnivPowerSeriesTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        UnivPowerSeriesTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
    }

    public void testEvaluation() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        BigRational bigRational = new BigRational(0L);
        BigRational bigRational2 = bigRational.random(this.kl);
        BigRational bigRational3 = this.a.evaluate(bigRational2);
        BigRational bigRational4 = this.b.evaluate(bigRational2);
        this.c = this.a.sum(this.b);
        BigRational bigRational5 = this.c.evaluate(bigRational2);
        BigRational bigRational6 = bigRational3.sum(bigRational4);
        UnivPowerSeriesTest.assertEquals((String)"a(v)+b(v) = (a+b)(v) ", (Object)bigRational5, (Object)bigRational6);
        this.c = this.fac.getZERO();
        bigRational5 = this.c.evaluate(bigRational2);
        bigRational6 = bigRational.getZERO();
        UnivPowerSeriesTest.assertEquals((String)"0(v) = 0 ", (Object)bigRational5, (Object)bigRational6);
        this.c = this.fac.getONE();
        bigRational5 = this.c.evaluate(bigRational2);
        bigRational6 = bigRational.getONE();
        UnivPowerSeriesTest.assertEquals((String)"1(v) = 1 ", (Object)bigRational5, (Object)bigRational6);
    }

    public void testTaylor() {
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, 3, 3, this.q + this.q);
        PolynomialTaylorFunction<BigRational> polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial);
        UnivPowerSeries<BigRational> univPowerSeries = this.fac.seriesOfTaylor(polynomialTaylorFunction, bigRational);
        UnivPowerSeries<BigRational> univPowerSeries2 = this.fac.fromPolynomial(genPolynomial);
        UnivPowerSeriesTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        for (GenPolynomial<BigRational> genPolynomial2 : genPolynomialRing.generators()) {
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial2);
            univPowerSeries = this.fac.seriesOfTaylor(polynomialTaylorFunction, bigRational);
            univPowerSeries2 = this.fac.fromPolynomial(genPolynomial2);
            UnivPowerSeriesTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        }
    }
}

