/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.StringUtil;
import edu.jas.kern.TimeStatus;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Factorization;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class FactorAbstract<C extends GcdRingElem<C>>
implements Factorization<C> {
    private static final Logger logger = Logger.getLogger(FactorAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SquarefreeAbstract<C> sengine;

    protected FactorAbstract() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbstract(RingFactory<C> ringFactory) {
        this.engine = GCDFactory.getProxy(ringFactory);
        this.sengine = SquarefreeFactory.getImplementation(ringFactory);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean isIrreducible(GenPolynomial<C> genPolynomial) {
        if (!this.isSquarefree(genPolynomial)) {
            return false;
        }
        List<GenPolynomial<C>> list = this.factorsSquarefree(genPolynomial);
        if (list.size() == 1) {
            return true;
        }
        if (list.size() > 2) {
            return false;
        }
        boolean bl = false;
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (!genPolynomial2.isConstant()) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isReducible(GenPolynomial<C> genPolynomial) {
        return !this.isIrreducible(genPolynomial);
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> genPolynomial) {
        return this.sengine.isSquarefree(genPolynomial);
    }

    public List<GenPolynomial<C>> factorsSquarefreeOptimize(GenPolynomial<C> genPolynomial) {
        Iterable iterable;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genPolynomial);
        OptimizedPolynomialList optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, arrayList);
        genPolynomial = (GenPolynomial)optimizedPolynomialList.list.get(0);
        logger.info((Object)("optimized polynomial: " + genPolynomial));
        List<Integer> list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        logger.info((Object)("optimize perm: " + optimizedPolynomialList.perm + ", de-optimize perm: " + list));
        ExpVector expVector = genPolynomial.degreeVector();
        int[] nArray = expVector.dependencyOnVariables();
        List<GenPolynomial<C>> list2 = null;
        if (expVector.length() == nArray.length) {
            logger.info((Object)("do.full factorsSquarefreeKronecker: " + genPolynomial));
            list2 = this.factorsSquarefreeKronecker(genPolynomial);
        } else {
            iterable = PolyUtil.removeUnusedUpperVariables(genPolynomial);
            logger.info((Object)("do.sparse factorsSquarefreeKronecker: " + iterable));
            list2 = this.factorsSquarefreeKronecker((GenPolynomial<C>)iterable);
            ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list2.size());
            GenPolynomialRing genPolynomialRing2 = genPolynomial.ring;
            for (GenPolynomial genPolynomial2 : list2) {
                GenPolynomial<C> genPolynomial3 = genPolynomial2.extend(genPolynomialRing2, 0, 0L);
                arrayList2.add(genPolynomial3);
            }
            list2 = arrayList2;
        }
        iterable = TermOrderOptimization.permutation(list, genPolynomialRing, list2);
        logger.info((Object)("de-optimized polynomials: " + iterable));
        list2 = this.normalizeFactorization((List<GenPolynomial<C>>)iterable);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> factorsSquarefree(GenPolynomial<C> genPolynomial) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)StringUtil.selectStackTrace("edu\\.jas.*"));
        }
        return this.factorsSquarefreeKronecker(genPolynomial);
    }

    public List<GenPolynomial<C>> factorsSquarefreeKronecker(GenPolynomial<C> genPolynomial) {
        long l;
        GenPolynomial<C> genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.degreeVector().totalDeg() <= 1L) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        long l2 = genPolynomial.degree() + 1L;
        GenPolynomial<C> genPolynomial3 = PolyUfdUtil.substituteKronecker(genPolynomial, l2);
        GenPolynomialRing genPolynomialRing2 = genPolynomial3.ring;
        genPolynomialRing2.setVars(genPolynomialRing2.newVars("zz"));
        logger.info((Object)("deg(subs(P,d=" + l2 + ")) = " + genPolynomial3.degree(0) + ", original degrees: " + genPolynomial.degreeVector()));
        if (this.debug) {
            logger.info((Object)("subs(P,d=" + l2 + ") = " + genPolynomial3));
        }
        if (genPolynomial3.degree(0) > 100L) {
            logger.warn((Object)"Kronecker substitution has to high degree");
            TimeStatus.checkTime("degree > 100");
        }
        List list = new ArrayList<GenPolynomial<C>>();
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.baseFactors(genPolynomial3);
        if (this.debug && !this.isFactorization(genPolynomial3, sortedMap)) {
            System.out.println("kr    = " + genPolynomial3);
            System.out.println("slist = " + sortedMap);
            throw new ArithmeticException("no factorization");
        }
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            genPolynomial2 = entry.getKey();
            l = entry.getValue();
            int n = 0;
            while ((long)n < l) {
                list.add(genPolynomial2);
                ++n;
            }
        }
        if (list.size() == 1 && ((GenPolynomial)list.get(0)).degree() == genPolynomial.degree()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ulist = " + list));
        }
        int n = list.size() - 1;
        int n2 = 0;
        genPolynomial2 = genPolynomial;
        l = (genPolynomial2.degree() + 1L) / 2L;
        ExpVector expVector = genPolynomial2.leadingExpVector();
        ExpVector expVector2 = genPolynomial2.trailingExpVector();
        block2: for (int i = 1; i <= n; ++i) {
            KsubSet ksubSet = new KsubSet(list, i);
            for (List list2 : ksubSet) {
                GenPolynomial<C> genPolynomial4;
                GenPolynomial<GenPolynomial> genPolynomial5 = genPolynomialRing2.getONE();
                for (int j = 0; j < list2.size(); ++j) {
                    genPolynomial5 = genPolynomial5.multiply((GenPolynomial)list2.get(j));
                }
                GenPolynomial genPolynomial6 = PolyUfdUtil.backSubstituteKronecker(genPolynomialRing, genPolynomial5, l2);
                if (++n2 % 2000 == 0) {
                    System.out.print("ti(" + n2 + ") ");
                    TimeStatus.checkTime(n2 + " % 2000 == 0");
                }
                if (!expVector.multipleOf(genPolynomial6.leadingExpVector()) || !expVector2.multipleOf(genPolynomial6.trailingExpVector()) || genPolynomial6.degree() > l || genPolynomial6.isConstant()) continue;
                genPolynomial6 = genPolynomial6.monic();
                if (n2 % 15000 == 0) {
                    System.out.println("\ndl   = " + n + ", deg(u) = " + l);
                    System.out.println("ulist = " + list);
                    System.out.println("kr    = " + genPolynomial3);
                    System.out.println("u     = " + genPolynomial2);
                    System.out.println("trial = " + genPolynomial6);
                }
                if (!(genPolynomial4 = PolyUtil.baseSparsePseudoRemainder(genPolynomial2, genPolynomial6)).isZERO()) continue;
                logger.info((Object)("trial = " + genPolynomial6));
                arrayList.add(genPolynomial6);
                genPolynomial2 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial6);
                expVector = genPolynomial2.leadingExpVector();
                expVector2 = genPolynomial2.trailingExpVector();
                if (genPolynomial2.isConstant()) {
                    i = n + 1;
                    continue block2;
                }
                list = FactorAbstract.removeOnce(list, list2);
                n = (list.size() + 1) / 2;
                i = 0;
                continue block2;
            }
        }
        if (!genPolynomial2.isONE() && !genPolynomial2.equals(genPolynomial)) {
            logger.info((Object)("rest u = " + genPolynomial2));
            arrayList.add(genPolynomial2);
        }
        if (arrayList.size() == 0) {
            logger.info((Object)("irred P = " + genPolynomial));
            arrayList.add(genPolynomial);
        }
        return this.normalizeFactorization(arrayList);
    }

    static <T> List<T> removeOnce(List<T> list, List<T> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(list);
        for (T t : list2) {
            boolean bl = arrayList.remove(t);
        }
        return arrayList;
    }

    public List<GenPolynomial<C>> baseFactorsRadical(GenPolynomial<C> genPolynomial) {
        return new ArrayList<GenPolynomial<C>>(this.baseFactors(genPolynomial).keySet());
    }

    public SortedMap<GenPolynomial<C>, Long> baseFactors(GenPolynomial<C> genPolynomial) {
        TreeMap treeMap;
        GcdRingElem gcdRingElem;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        TreeMap<GenPolynomial<C>, Long> treeMap2 = new TreeMap<GenPolynomial<C>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap2;
        }
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (genPolynomial.isConstant()) {
            treeMap2.put(genPolynomial, 1L);
            return treeMap2;
        }
        if (genPolynomialRing.coFac.isField()) {
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        } else {
            gcdRingElem = this.engine.baseContent(genPolynomial);
            if (genPolynomial.signum() < 0 && gcdRingElem.signum() > 0) {
                gcdRingElem = (GcdRingElem)gcdRingElem.negate();
            }
        }
        if (!gcdRingElem.isONE()) {
            treeMap = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap2.put((GenPolynomial<C>)((Object)treeMap), 1L);
            genPolynomial = genPolynomial.divide(gcdRingElem);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("base facs for P = " + genPolynomial));
        }
        if ((treeMap = this.sengine.baseSquarefreeFactors(genPolynomial)) == null || treeMap.size() == 0) {
            treeMap = new TreeMap();
            treeMap.put(genPolynomial, 1L);
        }
        if (logger.isInfoEnabled() && (treeMap.size() > 1 || treeMap.size() == 1 && (Long)treeMap.get(treeMap.firstKey()) > 1L)) {
            logger.info((Object)("squarefree facs   = " + treeMap));
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            Long l = (Long)entry.getValue();
            if (genPolynomialRing.coFac.isField() && !((GcdRingElem)genPolynomial2.leadingBaseCoefficient()).isONE()) {
                genPolynomial2 = genPolynomial2.monic();
                logger.warn((Object)("squarefree facs mon = " + genPolynomial2));
            }
            if (genPolynomial2.degree(0) <= 1L) {
                if (genPolynomial2.isONE()) continue;
                treeMap2.put(genPolynomial2, l);
                continue;
            }
            List list = this.baseFactorsSquarefree(genPolynomial2);
            if (this.debug) {
                logger.info((Object)("factors of squarefree = " + list));
            }
            for (GenPolynomial genPolynomial3 : list) {
                Long l2 = (Long)treeMap2.get(genPolynomial3);
                if (l2 != null) {
                    l = l + l2;
                }
                if (genPolynomial3.isONE()) continue;
                treeMap2.put(genPolynomial3, l);
            }
        }
        return treeMap2;
    }

    public abstract List<GenPolynomial<C>> baseFactorsSquarefree(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> factorsRadical(GenPolynomial<C> genPolynomial) {
        return new ArrayList<GenPolynomial<C>>(this.factors(genPolynomial).keySet());
    }

    @Override
    public List<GenPolynomial<C>> factorsRadical(List<GenPolynomial<C>> list) {
        TreeSet<GenPolynomial<C>> treeSet = new TreeSet<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list) {
            List<GenPolynomial<C>> list2 = this.factorsRadical(genPolynomial);
            treeSet.addAll(list2);
        }
        return new ArrayList<GenPolynomial<C>>(treeSet);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> factors(GenPolynomial<C> genPolynomial) {
        TreeMap treeMap;
        GcdRingElem gcdRingElem;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactors(genPolynomial);
        }
        TreeMap<GenPolynomial<C>, Long> treeMap2 = new TreeMap<GenPolynomial<C>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap2;
        }
        if (genPolynomial.isConstant()) {
            treeMap2.put(genPolynomial, 1L);
            return treeMap2;
        }
        if (genPolynomialRing.coFac.isField()) {
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        } else {
            gcdRingElem = this.engine.baseContent(genPolynomial);
            if (genPolynomial.signum() < 0 && gcdRingElem.signum() > 0) {
                gcdRingElem = (GcdRingElem)gcdRingElem.negate();
            }
        }
        if (!gcdRingElem.isONE()) {
            treeMap = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap2.put((GenPolynomial<C>)((Object)treeMap), 1L);
            genPolynomial = genPolynomial.divide(gcdRingElem);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("squarefree mfacs P = " + genPolynomial));
        }
        if ((treeMap = this.sengine.squarefreeFactors(genPolynomial)) == null || treeMap.size() == 0) {
            treeMap = new TreeMap();
            treeMap.put(genPolynomial, 1L);
            throw new RuntimeException("this should not happen, facs is empty: " + treeMap);
        }
        if (logger.isInfoEnabled()) {
            if (treeMap.size() > 1) {
                logger.info((Object)("squarefree mfacs      = " + treeMap));
            } else if (treeMap.size() == 1 && (Long)treeMap.get(treeMap.firstKey()) > 1L) {
                logger.info((Object)("squarefree #mfacs 1-n = " + treeMap));
            } else {
                logger.info((Object)("squarefree #mfacs 1-1 = " + treeMap));
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            if (genPolynomial2.isONE()) continue;
            Long l = (Long)entry.getValue();
            List<GenPolynomial<C>> list = this.factorsSquarefree(genPolynomial2);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("factors of squarefree ^" + l + " = " + list));
            }
            for (GenPolynomial<C> genPolynomial3 : list) {
                long l2 = l;
                Long l3 = (Long)treeMap2.get(genPolynomial3);
                if (l3 != null) {
                    l2 += l3.longValue();
                }
                treeMap2.put(genPolynomial3, l2);
            }
        }
        return treeMap2;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        return this.sengine.squarefreePart(genPolynomial);
    }

    public GenPolynomial<C> primitivePart(GenPolynomial<C> genPolynomial) {
        return this.engine.primitivePart(genPolynomial);
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> genPolynomial) {
        return this.engine.basePrimitivePart(genPolynomial);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        return this.sengine.squarefreeFactors(genPolynomial);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        return this.sengine.isFactorization(genPolynomial, list);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        return this.sengine.isFactorization(genPolynomial, sortedMap);
    }

    public long factorsDegree(SortedMap<GenPolynomial<C>, Long> sortedMap) {
        long l = 0L;
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial = entry.getKey();
            long l2 = entry.getValue();
            l += genPolynomial.degree() * l2;
        }
        return l;
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> genPolynomial, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> sortedMap) {
        return this.sengine.isRecursiveFactorization(genPolynomial, sortedMap);
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursiveFactorsSquarefree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Iterable<GenPolynomial<GenPolynomial<GcdRingElem>>> iterable;
        GenPolynomialRing genPolynomialRing;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        List list = this.factorsSquarefree(genPolynomial2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ifacts = " + list));
        }
        if (list.size() <= 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            iterable = list.get(0);
            list.remove(iterable);
            iterable = ((GenPolynomial)iterable).multiply((GcdRingElem)gcdRingElem);
            list.add(0, iterable);
        }
        iterable = PolyUtil.recursive(genPolynomialRing, list);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("recfacts = " + iterable));
        }
        arrayList.addAll((Collection<GenPolynomial<GenPolynomial<C>>>)iterable);
        return arrayList;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        SortedMap sortedMap = this.factors(genPolynomial2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dfacts = " + sortedMap));
        }
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            GenPolynomial<GcdRingElem> genPolynomial3 = sortedMap.firstKey();
            Long object = (Long)sortedMap.remove(genPolynomial3);
            genPolynomial3 = genPolynomial3.multiply(gcdRingElem);
            sortedMap.put(genPolynomial3, object);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getKey();
            Long l = (Long)entry.getValue();
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursive factors = " + treeMap));
        }
        return treeMap;
    }

    public List<GenPolynomial<C>> normalizeFactorization(List<GenPolynomial<C>> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem2 = list.get(i);
            if (abelianGroupElem2.signum() < 0) {
                abelianGroupElem2 = abelianGroupElem2.negate();
                abelianGroupElem = abelianGroupElem.negate();
            }
            arrayList.add((GenPolynomial<C>)abelianGroupElem2);
        }
        if (!abelianGroupElem.isONE()) {
            arrayList.add(0, (GenPolynomial<C>)abelianGroupElem);
        }
        return arrayList;
    }
}

