/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Boundary;
import edu.jas.root.ComplexRootsAbstract;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.root.RootUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ComplexRootsSturm<C extends RingElem<C> & Rational>
extends ComplexRootsAbstract<C> {
    private static final Logger logger = Logger.getLogger(ComplexRootsSturm.class);
    private final boolean debug = logger.isDebugEnabled();

    public ComplexRootsSturm(RingFactory<Complex<C>> ringFactory) {
        super(ringFactory);
    }

    public long indexOfCauchy(C c, C c2, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        List<GenPolynomial<C>> list = this.sturmSequence(genPolynomial2, genPolynomial);
        if (this.debug) {
            logger.info((Object)("sturmSeq = " + list));
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        List list2 = PolyUtil.evaluateMain(ringFactory, list, c);
        List list3 = PolyUtil.evaluateMain(ringFactory, list, c2);
        long l = RootUtil.signVar(list2) - RootUtil.signVar(list3);
        return l;
    }

    public long[] indexOfRouth(C c, C c2, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        List<GenPolynomial<C>> list = this.sturmSequence(genPolynomial, genPolynomial2);
        RingFactory ringFactory = genPolynomial.ring.coFac;
        List list2 = PolyUtil.evaluateMain(ringFactory, list, c);
        List list3 = PolyUtil.evaluateMain(ringFactory, list, c2);
        long l = RootUtil.signVar(list2) - RootUtil.signVar(list3);
        long l2 = genPolynomial.degree(0);
        if (l2 < genPolynomial2.degree(0)) {
            l2 = genPolynomial2.degree(0);
        }
        long l3 = (l2 - l) / 2L;
        long l4 = (l2 + l) / 2L;
        return new long[]{l3, l4};
    }

    public List<GenPolynomial<C>> sturmSequence(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        Iterable<Monomial<Object>> iterable;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isConstant()) {
            arrayList.add(genPolynomial.monic());
            return arrayList;
        }
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        arrayList.add(genPolynomial3);
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = genPolynomial2;
        while (!abelianGroupElem.isZERO()) {
            iterable = genPolynomial3.remainder((GenPolynomial<C>)abelianGroupElem);
            genPolynomial3 = abelianGroupElem;
            abelianGroupElem = ((GenPolynomial)iterable).negate();
            arrayList.add(genPolynomial3);
        }
        if (genPolynomial3.isConstant()) {
            return arrayList;
        }
        iterable = new ArrayList(arrayList.size());
        for (GenPolynomial<C> genPolynomial4 : arrayList) {
            genPolynomial4 = genPolynomial4.divide(genPolynomial3);
            iterable.add(genPolynomial4);
        }
        return iterable;
    }

    @Override
    public long complexRootCount(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial) throws InvalidBoundaryException {
        C c = rectangle.lengthReal();
        C c2 = rectangle.lengthImag();
        if (c.isZERO() && c2.isZERO()) {
            Complex<C> complex = PolyUtil.evaluateMain(genPolynomial.ring.coFac, genPolynomial, rectangle.getSW());
            if (complex.isZERO()) {
                return 1L;
            }
            return 0L;
        }
        if (c.isZERO() || c2.isZERO()) {
            Complex<RingElem> complex;
            RingElem ringElem;
            Complex<Object> complex2;
            Complex<Object> complex3;
            if (c.isZERO()) {
                complex3 = rectangle.getSW();
                complex2 = rectangle.getNE();
                ringElem = (RingElem)complex3.ring.ring.parse("1");
                complex = new Complex<RingElem>(complex3.ring, ringElem);
                complex3 = complex3.subtract(complex);
                complex2 = complex2.sum(complex);
                rectangle = rectangle.exchangeSW(complex3);
                rectangle = rectangle.exchangeNE(complex2);
                logger.info((Object)("new rectangle: " + rectangle.toScript()));
            }
            if (c2.isZERO()) {
                complex3 = rectangle.getSW();
                complex2 = rectangle.getNE();
                ringElem = (RingElem)complex3.ring.ring.parse("1");
                complex = new Complex<RingElem>(complex3.ring, (RingElem)complex3.ring.ring.getZERO(), ringElem);
                complex3 = complex3.subtract(complex);
                complex2 = complex2.sum(complex);
                rectangle = rectangle.exchangeSW(complex3);
                rectangle = rectangle.exchangeNE(complex2);
                logger.info((Object)("new rectangle: " + rectangle.toScript()));
            }
        }
        return this.windingNumber(rectangle, genPolynomial);
    }

    public long windingNumber(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial) throws InvalidBoundaryException {
        Boundary<C> boundary = new Boundary<C>(rectangle, genPolynomial);
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        RingFactory ringFactory = complexRing.ring;
        RingElem ringElem = (RingElem)ringFactory.getZERO();
        RingElem ringElem2 = (RingElem)ringFactory.getONE();
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            long l2 = this.indexOfCauchy(ringElem, ringElem2, boundary.getRealPart(i), boundary.getImagPart(i));
            l += l2;
        }
        if (l % 2L != 0L) {
            throw new InvalidBoundaryException("odd winding number " + l);
        }
        return l / 2L;
    }

    @Override
    public List<Rectangle<C>> complexRoots(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial) throws InvalidBoundaryException {
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        ArrayList<Rectangle<C>> arrayList = new ArrayList<Rectangle<C>>();
        if (genPolynomial.isConstant() || genPolynomial.isZERO()) {
            return arrayList;
        }
        long l = this.windingNumber(rectangle, genPolynomial);
        if (l < 0L) {
            throw new RuntimeException("negative winding number " + l);
        }
        if (l == 0L) {
            return arrayList;
        }
        if (l == 1L) {
            arrayList.add(rectangle);
            return arrayList;
        }
        Complex complex = complexRing.fromInteger(1L);
        complex = complex.divide(complexRing.fromInteger(1000L));
        Complex complex2 = rectangle.corners[3].subtract(rectangle.corners[1]);
        complex2 = complex2.divide(complexRing.fromInteger(2L));
        boolean bl = true;
        while (bl) {
            Complex complex3 = rectangle.corners[1].sum(complex2);
            if (this.debug) {
                logger.info((Object)("new center = " + complex3));
            }
            try {
                Complex[] complexArray = this.copyOfComplex(rectangle.corners, 4);
                complexArray[1] = new Complex(complexRing, complexArray[1].getRe(), complex3.getIm());
                complexArray[2] = complex3;
                complexArray[3] = new Complex(complexRing, complex3.getRe(), complexArray[3].getIm());
                Rectangle rectangle2 = new Rectangle(complexArray);
                List list = this.complexRoots(rectangle2, genPolynomial);
                arrayList.addAll(list);
                if ((long)arrayList.size() == genPolynomial.degree(0)) {
                    bl = false;
                    break;
                }
                complexArray = this.copyOfComplex(rectangle.corners, 4);
                complexArray[0] = new Complex(complexRing, complexArray[0].getRe(), complex3.getIm());
                complexArray[2] = new Complex(complexRing, complex3.getRe(), complexArray[2].getIm());
                complexArray[3] = complex3;
                Rectangle rectangle3 = new Rectangle(complexArray);
                List list2 = this.complexRoots(rectangle3, genPolynomial);
                arrayList.addAll(list2);
                if ((long)arrayList.size() == genPolynomial.degree(0)) {
                    bl = false;
                    break;
                }
                complexArray = this.copyOfComplex(rectangle.corners, 4);
                complexArray[0] = complex3;
                complexArray[1] = new Complex(complexRing, complex3.getRe(), complexArray[1].getIm());
                complexArray[3] = new Complex(complexRing, complexArray[3].getRe(), complex3.getIm());
                Rectangle rectangle4 = new Rectangle(complexArray);
                List list3 = this.complexRoots(rectangle4, genPolynomial);
                arrayList.addAll(list3);
                if ((long)arrayList.size() == genPolynomial.degree(0)) {
                    bl = false;
                    break;
                }
                complexArray = this.copyOfComplex(rectangle.corners, 4);
                complexArray[0] = new Complex(complexRing, complex3.getRe(), complexArray[0].getIm());
                complexArray[1] = complex3;
                complexArray[2] = new Complex(complexRing, complexArray[2].getRe(), complex3.getIm());
                Rectangle rectangle5 = new Rectangle(complexArray);
                List list4 = this.complexRoots(rectangle5, genPolynomial);
                arrayList.addAll(list4);
                bl = false;
            }
            catch (InvalidBoundaryException invalidBoundaryException) {
                complex2 = complex2.sum(complex2.multiply(complex));
                complex = complex.sum(complex.multiply(complexRing.getIMAG()));
            }
        }
        return arrayList;
    }

    @Override
    public Rectangle<C> invariantRectangle(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2) throws InvalidBoundaryException {
        Rectangle<C> rectangle2;
        Rectangle<C> rectangle3 = rectangle;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return rectangle3;
        }
        if (genPolynomial2.isConstant()) {
            return rectangle3;
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return rectangle3;
        }
        BigRational bigRational = rectangle3.rationalLength();
        BigRational bigRational2 = new BigRational(1L, 2L);
        do {
            long l;
            if ((l = this.windingNumber(rectangle3, genPolynomial2)) < 0L) {
                throw new RuntimeException("negative winding number " + l);
            }
            if (l == 0L) {
                return rectangle3;
            }
            bigRational = bigRational.multiply(bigRational2);
            rectangle2 = rectangle3;
        } while (!(rectangle3 = this.complexRootRefinement(rectangle3, genPolynomial, bigRational)).equals(rectangle2) || genPolynomial.gcd(genPolynomial2).isONE());
        System.out.println("f.gcd(g) = " + genPolynomial.gcd(genPolynomial2));
        throw new RuntimeException("no convergence " + rectangle3);
    }
}

