/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class FDUtil {
    private static final Logger logger = Logger.getLogger(FDUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBaseSparsePseudoRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        ExpVector expVector;
        Serializable serializable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial.toString() + " division by zero " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getZERO();
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            serializable = (RecSolvablePolynomial)genSolvablePolynomial;
            if (!serializable.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        serializable = new GreatestCommonDivisorSimple(genSolvablePolynomial.ring.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial<Object> genSolvablePolynomial3 = genSolvablePolynomial;
        while (!genSolvablePolynomial3.isZERO() && (expVector = genSolvablePolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GcdRingElem gcdRingElem = (GcdRingElem)genSolvablePolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenSolvablePolynomial<ExpVector> genSolvablePolynomial4 = genSolvablePolynomial2.multiplyLeft(expVector);
            GcdRingElem gcdRingElem2 = (GcdRingElem)genSolvablePolynomial4.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = serializable.leftOreCond(gcdRingElem, gcdRingElem2);
            GcdRingElem gcdRingElem3 = gcdRingElemArray[0];
            GcdRingElem gcdRingElem4 = gcdRingElemArray[1];
            genSolvablePolynomial3 = genSolvablePolynomial3.multiplyLeft(gcdRingElem3);
            genSolvablePolynomial4 = genSolvablePolynomial4.multiplyLeft((ExpVector)((Object)gcdRingElem4));
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract((Object)genSolvablePolynomial4);
        }
        return genSolvablePolynomial3;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> rightBaseSparsePseudoRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        ExpVector expVector;
        Serializable serializable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial.toString() + " division by zero " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getZERO();
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            serializable = (RecSolvablePolynomial)genSolvablePolynomial;
            if (!serializable.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        serializable = new GreatestCommonDivisorSimple(genSolvablePolynomial.ring.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenPolynomial genPolynomial = genSolvablePolynomial;
        while (!genPolynomial.isZERO() && (expVector = genPolynomial.leadingExpVector()).multipleOf(expVector2)) {
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial2 = genSolvablePolynomial2.multiply(expVector);
            GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
            GcdRingElem gcdRingElem2 = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = serializable.rightOreCond(gcdRingElem, gcdRingElem2);
            GcdRingElem gcdRingElem3 = gcdRingElemArray[0];
            GcdRingElem gcdRingElem4 = gcdRingElemArray[1];
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(gcdRingElem3);
            genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply(gcdRingElem4);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial2);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBasePseudoQuotient(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] leftBasePseudoQuotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        ExpVector expVector;
        Serializable serializable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial.toString() + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{null, null};
        if (genSolvablePolynomial.isZERO() || genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            serializable = (RecSolvablePolynomial)genSolvablePolynomial;
            if (!serializable.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        serializable = new GreatestCommonDivisorSimple(genSolvablePolynomial.ring.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial<Object> genSolvablePolynomial3 = genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial4 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genSolvablePolynomial3.isZERO() && (expVector = genSolvablePolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GcdRingElem gcdRingElem = (GcdRingElem)genSolvablePolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenSolvablePolynomial<ExpVector> genSolvablePolynomial5 = genSolvablePolynomial2.multiplyLeft(expVector);
            GcdRingElem gcdRingElem2 = (GcdRingElem)genSolvablePolynomial5.leadingBaseCoefficient();
            GcdRingElem[] gcdRingElemArray = serializable.leftOreCond(gcdRingElem, gcdRingElem2);
            GcdRingElem gcdRingElem3 = gcdRingElemArray[0];
            GcdRingElem gcdRingElem4 = gcdRingElemArray[1];
            genSolvablePolynomial3 = genSolvablePolynomial3.multiplyLeft(gcdRingElem3);
            genSolvablePolynomial5 = genSolvablePolynomial5.multiplyLeft((ExpVector)((Object)gcdRingElem4));
            genSolvablePolynomial4 = genSolvablePolynomial4.multiplyLeft(gcdRingElem3);
            genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial4.sum((GcdRingElem)gcdRingElem4, expVector);
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract((Object)genSolvablePolynomial5);
        }
        genSolvablePolynomialArray[0] = genSolvablePolynomial4;
        genSolvablePolynomialArray[1] = genSolvablePolynomial3;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        ExpVector expVector;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial;
        while (!genSolvablePolynomial3.isZERO() && (expVector = genSolvablePolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> genSolvablePolynomial5 = genSolvablePolynomial2.multiplyLeft((GenPolynomial<ExpVector>)((Object)expVector));
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial5.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = greatestCommonDivisorSimple.leftOreCond(genSolvablePolynomial4, genSolvablePolynomial6);
            GenSolvablePolynomial genSolvablePolynomial7 = genSolvablePolynomialArray[0];
            GenSolvablePolynomial genSolvablePolynomial8 = genSolvablePolynomialArray[1];
            genSolvablePolynomial3 = genSolvablePolynomial3.multiplyLeft(genSolvablePolynomial7);
            genSolvablePolynomial5 = genSolvablePolynomial5.multiplyLeft((AbelianGroupElem<ExpVector>)((ExpVector)((Object)genSolvablePolynomial8)));
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial5);
        }
        return genSolvablePolynomial3;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4) {
        GenSolvablePolynomial genSolvablePolynomial5;
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial7 = genSolvablePolynomial;
        GenPolynomial genPolynomial = (GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient();
        long l = genSolvablePolynomial.degree(0) - genSolvablePolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genSolvablePolynomial7.equals(genSolvablePolynomial6)) {
                return true;
            }
            genSolvablePolynomial7 = genSolvablePolynomial7.multiply((RingElem)genPolynomial);
        }
        GenPolynomial genPolynomial2 = genSolvablePolynomial;
        genSolvablePolynomial6 = genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2);
        for (long i = 0L; i <= l; ++i) {
            genSolvablePolynomial7 = (GenSolvablePolynomial)genPolynomial2.subtract(genSolvablePolynomial4);
            if (genSolvablePolynomial7.equals(genSolvablePolynomial6)) {
                return true;
            }
            genPolynomial2 = genPolynomial2.multiply((RingElem)genPolynomial);
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        GenSolvablePolynomial genSolvablePolynomial8 = (GenSolvablePolynomial)genSolvablePolynomial.leadingBaseCoefficient();
        genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial3.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial2).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial6.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = greatestCommonDivisorSimple.leftOreCond(genSolvablePolynomial8, genSolvablePolynomial9);
        GenSolvablePolynomial genSolvablePolynomial10 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial genSolvablePolynomial11 = genSolvablePolynomialArray[1];
        GenSolvablePolynomial genSolvablePolynomial12 = genSolvablePolynomial.multiplyLeft(genSolvablePolynomial10);
        GenSolvablePolynomial genSolvablePolynomial13 = (GenSolvablePolynomial)genSolvablePolynomial12.subtract(genSolvablePolynomial5 = genSolvablePolynomial6.multiplyLeft(genSolvablePolynomial11));
        if (genSolvablePolynomial13.isZERO()) {
            return true;
        }
        if (debug) {
            logger.info((Object)("not QR: D = " + genSolvablePolynomial13));
        }
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursivePseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursivePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        ExpVector expVector;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.ring.getZERO();
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial4 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genSolvablePolynomial3.isZERO() && (expVector = genSolvablePolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            expVector = expVector.subtract(expVector2);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> genSolvablePolynomial5 = genSolvablePolynomial2.multiplyLeft((GenPolynomial<ExpVector>)((Object)expVector));
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial3.leadingBaseCoefficient();
            GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)genSolvablePolynomial5.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = greatestCommonDivisorSimple.leftOreCond(genSolvablePolynomial6, genSolvablePolynomial7);
            GenSolvablePolynomial genSolvablePolynomial8 = genSolvablePolynomialArray2[0];
            GenSolvablePolynomial genSolvablePolynomial9 = genSolvablePolynomialArray2[1];
            genSolvablePolynomial3 = genSolvablePolynomial3.multiplyLeft(genSolvablePolynomial8);
            genSolvablePolynomial5 = genSolvablePolynomial5.multiplyLeft((AbelianGroupElem<ExpVector>)((ExpVector)((Object)genSolvablePolynomial9)));
            genSolvablePolynomial4 = genSolvablePolynomial4.multiplyLeft(genSolvablePolynomial8);
            genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial4.sum(genSolvablePolynomial9, expVector);
            genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial5);
        }
        genSolvablePolynomialArray[0] = genSolvablePolynomial4;
        genSolvablePolynomialArray[1] = genSolvablePolynomial3;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4) {
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial5;
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3).sum(genSolvablePolynomial4);
        GenSolvablePolynomial genSolvablePolynomial7 = genSolvablePolynomial;
        GenPolynomial genPolynomial = (GenPolynomial)genSolvablePolynomial2.leadingBaseCoefficient();
        long l = genSolvablePolynomial.degree(0) - genSolvablePolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genSolvablePolynomial7.equals(genSolvablePolynomial6)) {
                return true;
            }
            genSolvablePolynomial7 = genSolvablePolynomial7.multiply((RingElem)genPolynomial);
        }
        GenPolynomial genPolynomial2 = genSolvablePolynomial;
        genSolvablePolynomial6 = genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3);
        for (long i = 0L; i <= l; ++i) {
            genSolvablePolynomial7 = (GenSolvablePolynomial)genPolynomial2.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)genSolvablePolynomial4);
            if (genSolvablePolynomial7.equals(genSolvablePolynomial6)) {
                return true;
            }
            genPolynomial2 = genPolynomial2.multiply((RingElem)genPolynomial);
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial8 = genSolvablePolynomial.rightRecursivePolynomial();
        GenSolvablePolynomial genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial8.leadingBaseCoefficient();
        genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial2.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)genSolvablePolynomial3).sum(genSolvablePolynomial4);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial10 = genSolvablePolynomial6.rightRecursivePolynomial();
        GenSolvablePolynomial genSolvablePolynomial11 = (GenSolvablePolynomial)genSolvablePolynomial10.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = greatestCommonDivisorSimple.rightOreCond(genSolvablePolynomial9, genSolvablePolynomial11);
        GenSolvablePolynomial genSolvablePolynomial12 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial genSolvablePolynomial13 = genSolvablePolynomialArray[1];
        GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>> genSolvablePolynomial14 = FDUtil.multiplyRightRecursivePolynomial(genSolvablePolynomial8, genSolvablePolynomial12);
        GenSolvablePolynomial genSolvablePolynomial15 = (GenSolvablePolynomial)genSolvablePolynomial14.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)(genSolvablePolynomial5 = FDUtil.multiplyRightRecursivePolynomial(genSolvablePolynomial10, genSolvablePolynomial13)));
        if (genSolvablePolynomial15.isZERO()) {
            return true;
        }
        System.out.println("Pa = " + genSolvablePolynomial14);
        System.out.println("Rb = " + genSolvablePolynomial5);
        logger.info((Object)("not right QR: Pa-Rb = " + genSolvablePolynomial15));
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightPseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2)[1];
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightSparsePseudoRemainderOld(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        ExpVector expVector;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getZERO();
        }
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenPolynomial genPolynomial = genSolvablePolynomial;
        while (!genPolynomial.isZERO() && (expVector = genPolynomial.leadingExpVector()).multipleOf(expVector2)) {
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial2 = genSolvablePolynomial2.multiply(expVector);
            GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomial2.leadingBaseCoefficient();
            GenPolynomial genPolynomial4 = (GenPolynomial)genPolynomial.leadingBaseCoefficient();
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply((RingElem)genPolynomial3);
            genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply((RingElem)genPolynomial4);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial2);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        GenSolvablePolynomial genSolvablePolynomial3;
        ExpVector expVector;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException(genSolvablePolynomial + " division by zero " + genSolvablePolynomial2);
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial2.ring.getZERO();
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomial.ring.coFac;
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple(genPolynomialRing.coFac);
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        GenSolvablePolynomial genSolvablePolynomial4 = genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial5 = ((GenSolvablePolynomial)genSolvablePolynomial2.ring.getZERO()).copy();
        while (!genSolvablePolynomial4.isZERO() && (expVector = genSolvablePolynomial4.leadingExpVector()).multipleOf(expVector2)) {
            expVector = expVector.subtract(expVector2);
            GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial6 = genSolvablePolynomial2.multiply(expVector);
            GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial7 = genSolvablePolynomial6.rightRecursivePolynomial();
            GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial8 = genSolvablePolynomial4.rightRecursivePolynomial();
            GenSolvablePolynomial genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial8.leadingBaseCoefficient();
            GenSolvablePolynomial genSolvablePolynomial10 = (GenSolvablePolynomial)genSolvablePolynomial7.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = greatestCommonDivisorSimple.rightOreCond(genSolvablePolynomial9, genSolvablePolynomial10);
            GenSolvablePolynomial genSolvablePolynomial11 = genSolvablePolynomialArray2[0];
            GenSolvablePolynomial genSolvablePolynomial12 = genSolvablePolynomialArray2[1];
            genSolvablePolynomial8 = FDUtil.multiplyRightRecursivePolynomial(genSolvablePolynomial8, genSolvablePolynomial11);
            genSolvablePolynomial7 = FDUtil.multiplyRightRecursivePolynomial(genSolvablePolynomial7, genSolvablePolynomial12);
            genSolvablePolynomial6 = genSolvablePolynomial7.evalAsRightRecursivePolynomial();
            genSolvablePolynomial4 = genSolvablePolynomial8.evalAsRightRecursivePolynomial();
            genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial4.subtract(genSolvablePolynomial6);
            genSolvablePolynomial5 = FDUtil.multiplyRightRecursivePolynomial(genSolvablePolynomial5, genSolvablePolynomial11);
            genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial5.sum(genSolvablePolynomial12, expVector);
        }
        genSolvablePolynomialArray[0] = genSolvablePolynomial3 = genSolvablePolynomial5.evalAsRightRecursivePolynomial();
        genSolvablePolynomialArray[1] = genSolvablePolynomial4;
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivideRightEval(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial.rightRecursivePolynomial();
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = FDUtil.recursiveDivide(genSolvablePolynomial3, genSolvablePolynomial2);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial5 = genSolvablePolynomial4.evalAsRightRecursivePolynomial();
        if (debug && !((GenSolvablePolynomial)genSolvablePolynomial5.multiply((RingElem)genSolvablePolynomial2)).equals(genSolvablePolynomial)) {
            System.out.println("rDivREval: P   = " + genSolvablePolynomial + ", right(P) = " + genSolvablePolynomial3);
            System.out.println("rDivREval: Q   = " + genSolvablePolynomial5 + ", right(Q) = " + genSolvablePolynomial4);
            System.out.println("rDivREval: Q*s = " + genSolvablePolynomial5.multiply((RingElem)genSolvablePolynomial2) + ", s = " + genSolvablePolynomial2);
            throw new RuntimeException("rDivREval: Q*s != P");
        }
        return genSolvablePolynomial5;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivide(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomial.ring.getZERO()).copy();
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)entry.getValue();
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial3, genSolvablePolynomial2);
            GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial4 = genSolvablePolynomialArray[0];
            if (debug && !genSolvablePolynomialArray[1].isZERO()) {
                System.out.println("rDiv, P   = " + genSolvablePolynomial);
                System.out.println("rDiv, c1  = " + genSolvablePolynomial3);
                System.out.println("rDiv, s   = " + genSolvablePolynomial2);
                System.out.println("rDiv, c   = " + genSolvablePolynomial4 + ", r = " + genSolvablePolynomialArray[1]);
                System.out.println("rDiv, c*s = " + genSolvablePolynomial4.multiply(genSolvablePolynomial2));
                System.out.println("rDiv, s*c = " + genSolvablePolynomial2.multiply(genSolvablePolynomial4));
                throw new RuntimeException("something is wrong: rem = " + genSolvablePolynomialArray[1]);
            }
            if (!genSolvablePolynomial4.isZERO()) {
                genPolynomial.doPutToMap(expVector, genSolvablePolynomial4);
                continue;
            }
            System.out.println("rDiv, P  = " + genSolvablePolynomial);
            System.out.println("rDiv, c1 = " + genSolvablePolynomial3);
            System.out.println("rDiv, s  = " + genSolvablePolynomial2);
            System.out.println("rDiv, c  = " + genSolvablePolynomial4);
            throw new RuntimeException("something is wrong: c is zero");
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivideRightPolynomial(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomial.ring.getZERO()).copy();
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomial.rightRecursivePolynomial();
        logger.info((Object)("P = " + genSolvablePolynomial + ", right(P) = " + genSolvablePolynomial3 + ", left(s) = " + genSolvablePolynomial2));
        for (Map.Entry entry : genSolvablePolynomial3.getMap().entrySet()) {
            GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)entry.getValue();
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial<C> genSolvablePolynomial5 = FDUtil.divideRightPolynomial(genSolvablePolynomial4, genSolvablePolynomial2);
            if (genSolvablePolynomial5.isZERO()) continue;
            genPolynomial.doPutToMap(expVector, genSolvablePolynomial5);
        }
        GenSolvablePolynomial genSolvablePolynomial6 = ((GenSolvablePolynomial)genPolynomial).evalAsRightRecursivePolynomial();
        logger.info((Object)("pl = " + genSolvablePolynomial6 + ", p = " + genPolynomial));
        return genSolvablePolynomial6;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> divideRightPolynomial(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomial2);
            GenSolvablePolynomial<C> genSolvablePolynomial3 = genSolvablePolynomialArray[0];
            if (debug && !genSolvablePolynomialArray[1].isZERO()) {
                System.out.println("rDivPol, P = " + genSolvablePolynomial);
                System.out.println("rDivPol, s = " + genSolvablePolynomial2);
                throw new RuntimeException("non zero remainder, q = " + genSolvablePolynomial3 + ", r = " + genSolvablePolynomialArray[1]);
            }
            return genSolvablePolynomial3;
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(genSolvablePolynomial4, genSolvablePolynomial5);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial6 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial7 = genSolvablePolynomialArray[1];
        if (debug && !genSolvablePolynomial7.isZERO()) {
            System.out.println("rDivPol, pr = " + genSolvablePolynomial4);
            System.out.println("rDivPol, sr = " + genSolvablePolynomial5);
            throw new RuntimeException("non zero remainder, q = " + genSolvablePolynomial6 + ", r = " + genSolvablePolynomial7);
        }
        GenSolvablePolynomial genSolvablePolynomial8 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial6);
        return genSolvablePolynomial8;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightDivide(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genSolvablePolynomial + ", " + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        if (!(genSolvablePolynomial instanceof RecSolvablePolynomial)) {
            // empty if block
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            // empty if block
        }
        GenSolvablePolynomial genSolvablePolynomial3 = recSolvablePolynomialRing.getONE();
        ExpVector expVector = recSolvablePolynomialRing.evzero;
        GenSolvablePolynomial genSolvablePolynomial4 = recSolvablePolynomialRing.getZERO();
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial;
        while (!recSolvablePolynomial.isZERO()) {
            ExpVector expVector2 = recSolvablePolynomial.leadingExpVector();
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)recSolvablePolynomial.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial5, genSolvablePolynomial2);
            if (!(!debug || genSolvablePolynomialArray[1].isZERO() && genSolvablePolynomial5.remainder(genSolvablePolynomial2).isZERO())) {
                logger.info((Object)("no exact division, rem = " + genSolvablePolynomial5.remainder(genSolvablePolynomial2) + ", r =" + genSolvablePolynomialArray[1]));
                throw new RuntimeException("no exact division: r = " + genSolvablePolynomialArray[1]);
            }
            GenSolvablePolynomial<C> genSolvablePolynomial6 = genSolvablePolynomialArray[0];
            if (genSolvablePolynomial6.isZERO()) {
                System.out.println("rDiv, P  = " + genSolvablePolynomial);
                System.out.println("rDiv, a  = " + genSolvablePolynomial5);
                System.out.println("rDiv, s  = " + genSolvablePolynomial2);
                System.out.println("rDiv, c  = " + genSolvablePolynomial6);
                throw new RuntimeException("something is wrong: c is zero");
            }
            RecSolvablePolynomial<C> recSolvablePolynomial2 = ((RecSolvablePolynomial)genSolvablePolynomial3).multiply(genSolvablePolynomial6, expVector2, genSolvablePolynomial2, expVector);
            recSolvablePolynomial = (RecSolvablePolynomial)recSolvablePolynomial.subtract(recSolvablePolynomial2);
            genSolvablePolynomial4 = (RecSolvablePolynomial)genSolvablePolynomial4.sum(genSolvablePolynomial6, expVector2);
        }
        return genSolvablePolynomial4;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> multiplyRightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenPolynomial<C> genPolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomial.ring.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        SortedMap sortedMap = genSolvablePolynomial.getMap();
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial3.multiply(genPolynomial);
            if (genPolynomial4.isZERO()) continue;
            genPolynomial2.doPutToMap(expVector, genPolynomial4);
        }
        return genPolynomial2;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, GenSolvablePolynomial<SolvableQuotient<C>> genSolvablePolynomial) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        GenSolvablePolynomial<Object> genSolvablePolynomial2 = null;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomialRing.coFac;
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive(genPolynomialRing.coFac);
        int n = 0;
        SortedMap sortedMap = genSolvablePolynomial.getMap();
        for (SolvableQuotient object : sortedMap.values()) {
            GenSolvablePolynomial genSolvablePolynomial3 = object.den;
            if (genSolvablePolynomial2 == null) {
                genSolvablePolynomial2 = genSolvablePolynomial3;
                n = genSolvablePolynomial3.signum();
                continue;
            }
            GenSolvablePolynomial genSolvablePolynomial4 = greatestCommonDivisorPrimitive.leftGcd(genSolvablePolynomial2, genSolvablePolynomial3);
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial3.divide(genSolvablePolynomial4);
            genSolvablePolynomial2 = genSolvablePolynomial5.multiply(genSolvablePolynomial2);
        }
        if (n < 0) {
            genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial2.negate();
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            SolvableQuotient solvableQuotient = (SolvableQuotient)entry.getValue();
            GenPolynomial genPolynomial2 = genSolvablePolynomial2.divide(solvableQuotient.den);
            GenPolynomial genPolynomial3 = ((GenPolynomial)solvableQuotient.num).multiply(genPolynomial2);
            genPolynomial.doPutToMap(expVector, genPolynomial3);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, Collection<GenSolvablePolynomial<SolvableQuotient<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(collection.size());
        for (GenSolvablePolynomial<SolvableQuotient<C>> genSolvablePolynomial : collection) {
            arrayList.add(FDUtil.integralFromQuotientCoefficients(genSolvablePolynomialRing, genSolvablePolynomial));
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<SolvableQuotient<C>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> genSolvablePolynomialRing, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        RingFactory ringFactory = genSolvablePolynomialRing.coFac;
        SolvableQuotientRing solvableQuotientRing = (SolvableQuotientRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)entry.getValue();
            SolvableQuotient solvableQuotient = new SolvableQuotient(solvableQuotientRing, genSolvablePolynomial2);
            if (solvableQuotient.isZERO()) continue;
            genPolynomial.doPutToMap(expVector, solvableQuotient);
        }
        return genPolynomial;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<SolvableQuotient<C>>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> genSolvablePolynomialRing, Collection<GenSolvablePolynomial<GenPolynomial<C>>> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>> arrayList = new ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>>(collection.size());
        for (GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial : collection) {
            arrayList.add(FDUtil.quotientFromIntegralCoefficients(genSolvablePolynomialRing, genSolvablePolynomial));
        }
        return arrayList;
    }
}

