/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SolvableQuotient<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableQuotient<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(SolvableQuotient.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableQuotientRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;

    public SolvableQuotient(SolvableQuotientRing<C> solvableQuotientRing) {
        this(solvableQuotientRing, (GenSolvablePolynomial<C>)solvableQuotientRing.ring.getZERO());
    }

    public SolvableQuotient(SolvableQuotientRing<C> solvableQuotientRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        this(solvableQuotientRing, genSolvablePolynomial, (GenSolvablePolynomial<C>)solvableQuotientRing.ring.getONE(), true);
    }

    public SolvableQuotient(SolvableQuotientRing<C> solvableQuotientRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        this(solvableQuotientRing, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    protected SolvableQuotient(SolvableQuotientRing<C> solvableQuotientRing, GenSolvablePolynomial<C> object, GenSolvablePolynomial<C> object2, boolean bl) {
        if (object2 == null || ((GenPolynomial)object2).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = solvableQuotientRing;
        if (((GenPolynomial)object2).signum() < 0) {
            object = (GenSolvablePolynomial)((GenPolynomial)object).negate();
            object2 = (GenSolvablePolynomial)((GenPolynomial)object2).negate();
        }
        if (bl) {
            this.num = object;
            this.den = object2;
            return;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)((GenPolynomial)object2).leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            object = ((GenSolvablePolynomial)object).multiply(gcdRingElem);
            object2 = ((GenSolvablePolynomial)object2).multiply(gcdRingElem);
        }
        if (((GenPolynomial)object).compareTo(object2) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)object).negate()).compareTo(object2) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isZERO()) {
            this.num = object;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)object).isConstant() || ((GenPolynomial)object2).isConstant()) {
            this.num = object;
            this.den = object2;
            return;
        }
        Object[] objectArray = PolyGBUtil.syzGcdCofactors(solvableQuotientRing.ring, object, object2);
        if (!objectArray[0].isONE()) {
            logger.info((Object)("constructor: gcd = " + Arrays.toString(objectArray)));
            object = objectArray[1];
            object2 = objectArray[2];
            if (((GenPolynomial)object).isConstant() || ((GenPolynomial)object2).isConstant()) {
                this.num = object;
                this.den = object2;
                return;
            }
        }
        Object[] objectArray2 = this.ring.engine.leftSimplifier(object, object2);
        logger.info((Object)("simp: " + Arrays.toString(objectArray2) + ", " + object + ", " + object2));
        this.num = objectArray2[0];
        this.den = objectArray2[1];
    }

    @Override
    public SolvableQuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableQuotient<C> copy() {
        return new SolvableQuotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String string = "{ " + this.num.toString(this.ring.ring.getVars());
            if (!this.den.isONE()) {
                string = string + " | " + this.den.toString(this.ring.ring.getVars());
            }
            return string + " }";
        }
        return "SolvableQuotient[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableQuotientRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableQuotient<C> solvableQuotient) {
        int n;
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -solvableQuotient.signum();
        }
        int n2 = this.num.signum();
        int n3 = (n2 - (n = solvableQuotient.num.signum())) / 2;
        if (n3 != 0) {
            return n3;
        }
        if (this.den.compareTo(solvableQuotient.den) == 0) {
            return this.num.compareTo(solvableQuotient.num);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.den, solvableQuotient.den);
        if (this.debug) {
            System.out.println("oc[0] den =<>= oc[1] b.den: (" + genSolvablePolynomialArray[0] + ") (" + this.den + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableQuotient.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomialArray[1].multiply(solvableQuotient.num);
        return genSolvablePolynomial.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)genSolvablePolynomial2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SolvableQuotient)) {
            return false;
        }
        SolvableQuotient solvableQuotient = (SolvableQuotient)object;
        if (this.num.equals(solvableQuotient.num) && this.den.equals(solvableQuotient.den)) {
            return true;
        }
        return this.compareTo(solvableQuotient) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    public SolvableQuotient<C> rightFraction() {
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.rightOreCond(this.num, this.den);
        return new SolvableQuotient<C>(this.ring, genSolvablePolynomialArray[1], genSolvablePolynomialArray[0], true);
    }

    public boolean isRightFraction(SolvableQuotient<C> solvableQuotient) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial;
        if (this.isZERO()) {
            return solvableQuotient.isZERO();
        }
        if (this.isONE()) {
            return solvableQuotient.isONE();
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> genSolvablePolynomial2 = this.den.multiply(solvableQuotient.num);
        return genSolvablePolynomial2.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)(genSolvablePolynomial = this.num.multiply(solvableQuotient.den))) == 0;
    }

    @Override
    public SolvableQuotient<C> abs() {
        return new SolvableQuotient<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableQuotient<C> sum(SolvableQuotient<C> solvableQuotient) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableQuotient;
        }
        if (this.den.isONE() && solvableQuotient.den.isONE()) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableQuotient.num);
            return new SolvableQuotient<C>(this.ring, genSolvablePolynomial, this.den, true);
        }
        if (this.den.compareTo(solvableQuotient.den) == 0) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.num.sum(solvableQuotient.num);
            return new SolvableQuotient<C>(this.ring, genSolvablePolynomial, this.den, false);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.den, solvableQuotient.den);
        if (this.debug) {
            System.out.println("oc[0] den =sum= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.den + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableQuotient.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial3 = genSolvablePolynomialArray[1].multiply(solvableQuotient.num);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial2.sum(genSolvablePolynomial3);
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial4, genSolvablePolynomial, false);
    }

    @Override
    public SolvableQuotient<C> negate() {
        return new SolvableQuotient<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableQuotient<C> subtract(SolvableQuotient<C> solvableQuotient) {
        return this.sum((SolvableQuotient<C>)solvableQuotient.negate());
    }

    @Override
    public SolvableQuotient<C> divide(SolvableQuotient<C> solvableQuotient) {
        return this.multiply((C)solvableQuotient.inverse());
    }

    @Override
    public SolvableQuotient<C> inverse() {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return new SolvableQuotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public SolvableQuotient<C> remainder(SolvableQuotient<C> solvableQuotient) {
        if (solvableQuotient.isZERO()) {
            throw new ArithmeticException("element not invertible " + solvableQuotient);
        }
        return this.ring.getZERO();
    }

    public SolvableQuotient<C>[] quotientRemainder(SolvableQuotient<C> solvableQuotient) {
        return new SolvableQuotient[]{this.divide(solvableQuotient), this.remainder(solvableQuotient)};
    }

    @Override
    public SolvableQuotient<C> multiply(SolvableQuotient<C> solvableQuotient) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return solvableQuotient;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (solvableQuotient.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return solvableQuotient;
        }
        if (this.den.isONE() && solvableQuotient.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = this.num.multiply(solvableQuotient.num);
            return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, this.den, true);
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.ring.engine.leftOreCond(this.num, solvableQuotient.den);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial = genSolvablePolynomialArray[1].multiply(solvableQuotient.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply(this.den);
        if (this.debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + genSolvablePolynomialArray[0] + ") (" + this.num + ") = (" + genSolvablePolynomialArray[1] + ") (" + solvableQuotient.den + ")");
        }
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial, genSolvablePolynomial2, false);
    }

    @Override
    public SolvableQuotient<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (genSolvablePolynomial.isONE()) {
            return this;
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = this.num.multiply(genSolvablePolynomial);
        return new SolvableQuotient<GenSolvablePolynomial<C>>(this.ring, genSolvablePolynomial2, this.den, false);
    }

    @Override
    public SolvableQuotient<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (c.isONE()) {
            return this;
        }
        GenPolynomial genPolynomial = this.num.multiply((RingElem)c);
        return new SolvableQuotient<C>(this.ring, genPolynomial, this.den, false);
    }

    @Override
    public SolvableQuotient<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.num.multiply(expVector);
        return new SolvableQuotient<C>(this.ring, genPolynomial, this.den, false);
    }

    public SolvableQuotient<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)this.num.leadingBaseCoefficient();
        if (!gcdRingElem.isUnit()) {
            return this;
        }
        gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
        GenPolynomial genPolynomial = this.num.multiply(gcdRingElem);
        return new SolvableQuotient<C>(this.ring, genPolynomial, this.den, true);
    }

    @Override
    public SolvableQuotient<C> gcd(SolvableQuotient<C> solvableQuotient) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return solvableQuotient;
        }
        if (this.equals(solvableQuotient)) {
            return this;
        }
        return this.ring.getONE();
    }

    public SolvableQuotient<C>[] egcd(SolvableQuotient<C> solvableQuotient) {
        SolvableQuotient[] solvableQuotientArray = new SolvableQuotient[]{null, null, null};
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            solvableQuotientArray[0] = this;
            return solvableQuotientArray;
        }
        if (this.isZERO()) {
            solvableQuotientArray[0] = solvableQuotient;
            return solvableQuotientArray;
        }
        GenPolynomial genPolynomial = this.ring.ring.fromInteger(2L);
        solvableQuotientArray[0] = this.ring.getONE();
        solvableQuotientArray[1] = this.multiply((C)genPolynomial).inverse();
        solvableQuotientArray[2] = solvableQuotient.multiply(genPolynomial).inverse();
        return solvableQuotientArray;
    }
}

