/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorFactory;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRealReal<C extends GcdRingElem<C> & Rational>
extends FactorAbstract<RealAlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorRealReal.class);
    private final boolean debug = logger.isInfoEnabled();
    public final FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> factorAlgebraic;

    protected FactorRealReal() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorRealReal(RealAlgebraicRing<C> realAlgebraicRing) {
        this(realAlgebraicRing, FactorFactory.getImplementation(realAlgebraicRing.realRing));
    }

    public FactorRealReal(RealAlgebraicRing<C> realAlgebraicRing, FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> factorAbstract) {
        super(realAlgebraicRing);
        this.factorAlgebraic = factorAbstract;
    }

    @Override
    public List<GenPolynomial<RealAlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<RealAlgebraicNumber<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<RealAlgebraicNumber<C>>> arrayList = new ArrayList<GenPolynomial<RealAlgebraicNumber<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        edu.jas.root.RealAlgebraicRing realAlgebraicRing2 = realAlgebraicRing.realRing;
        RealAlgebraicNumber<C> realAlgebraicNumber = genPolynomial.leadingBaseCoefficient();
        if (!realAlgebraicNumber.isONE()) {
            genPolynomial = genPolynomial.monic();
            arrayList.add(((GenPolynomial)genPolynomialRing.getONE()).multiply(realAlgebraicNumber));
        }
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(realAlgebraicRing2, genPolynomialRing);
        GenPolynomial genPolynomial2 = PolyUtilApp.realAlgFromRealCoefficients(genPolynomialRing2, genPolynomial);
        List list = this.factorAlgebraic.baseFactorsSquarefree(genPolynomial2);
        for (GenPolynomial genPolynomial3 : list) {
            GenPolynomial genPolynomial4 = PolyUtilApp.realFromRealAlgCoefficients(genPolynomialRing, genPolynomial3);
            arrayList.add(genPolynomial4);
        }
        if (this.debug) {
            logger.info((Object)("rafactors = " + arrayList));
        }
        return arrayList;
    }
}

