/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;

public class IdealWithRealAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<RealAlgebraicNumber<D>>> ran;
    protected List<List<BigDecimal>> droots = null;

    protected IdealWithRealAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithRealAlgebraicRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, List<List<RealAlgebraicNumber<D>>> list2) {
        super(ideal, list);
        this.ran = list2;
    }

    public IdealWithRealAlgebraicRoots(IdealWithUniv<D> idealWithUniv, List<List<RealAlgebraicNumber<D>>> list) {
        super(idealWithUniv.ideal, idealWithUniv.upolys);
        this.ran = list;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "\nreal roots:\n");
        stringBuffer.append("[");
        boolean bl = true;
        for (List<RealAlgebraicNumber<D>> list : this.ran) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("[");
            boolean bl2 = true;
            for (RealAlgebraicNumber<D> realAlgebraicNumber : list) {
                if (!bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = false;
                }
                stringBuffer.append(realAlgebraicNumber.ring.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        if (this.droots != null) {
            stringBuffer.append("\ndecimal real root approximation:\n");
            for (List<GcdRingElem<RealAlgebraicNumber<Object>>> list : this.droots) {
                stringBuffer.append(list.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.ran.toString();
    }

    public synchronized List<List<BigDecimal>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<BigDecimal>> arrayList = new ArrayList<List<BigDecimal>>();
        for (List<RealAlgebraicNumber<D>> list : this.ran) {
            ArrayList<BigDecimal> arrayList2 = new ArrayList<BigDecimal>();
            for (RealAlgebraicNumber<D> realAlgebraicNumber : list) {
                BigDecimal bigDecimal = new BigDecimal(realAlgebraicNumber.magnitude());
                arrayList2.add(bigDecimal);
            }
            arrayList.add(arrayList2);
        }
        this.droots = arrayList;
        return arrayList;
    }

    public void doDecimalApproximation() {
        List<List<BigDecimal>> list = this.decimalApproximation();
        if (list.isEmpty()) {
            System.out.println("unused is empty");
        }
    }
}

