/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Local;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalRing<C extends RingElem<C>>
implements RingFactory<Local<C>>,
QuotPairFactory<C, Local<C>> {
    private static final Logger logger = Logger.getLogger(LocalRing.class);
    protected final C ideal;
    protected final RingFactory<C> ring;
    protected int isField = -1;

    public LocalRing(RingFactory<C> ringFactory, C c) {
        this.ring = ringFactory;
        if (c == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ideal = c;
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
    }

    @Override
    public RingFactory<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Local<C> create(C c) {
        return new Local<C>(this, c);
    }

    @Override
    public Local<C> create(C c, C c2) {
        return new Local<C>(this, c, c2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Local<C> copy(Local<C> local) {
        return new Local(local.ring, local.num, local.den, true);
    }

    @Override
    public Local<C> getZERO() {
        return new Local<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Local<C> getONE() {
        return new Local<RingElem>(this, (RingElem)this.ring.getONE());
    }

    @Override
    public List<Local<C>> generators() {
        List list = this.ring.generators();
        ArrayList<Local<C>> arrayList = new ArrayList<Local<C>>(list.size() - 1);
        for (RingElem ringElem : list) {
            if (ringElem.isONE()) continue;
            arrayList.add(new Local<RingElem>(this, ringElem));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Local<C> fromInteger(BigInteger bigInteger) {
        return new Local<RingElem>(this, (RingElem)this.ring.fromInteger(bigInteger));
    }

    @Override
    public Local<C> fromInteger(long l) {
        return new Local<RingElem>(this, (RingElem)this.ring.fromInteger(l));
    }

    public String toString() {
        return "Local[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "LocalRing(" + this.ideal.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LocalRing)) {
            return false;
        }
        LocalRing localRing = (LocalRing)object;
        if (!this.ring.equals(localRing.ring)) {
            return false;
        }
        return this.ideal.equals(localRing.ideal);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.ideal.hashCode();
        return n;
    }

    @Override
    public Local<C> random(int n) {
        RingElem ringElem = (RingElem)this.ring.random(n);
        RingElem ringElem2 = (RingElem)this.ring.random(n);
        ringElem2 = (RingElem)ringElem2.remainder(this.ideal);
        while (ringElem2.isZERO()) {
            logger.debug((Object)"zero was in ideal");
            ringElem2 = (RingElem)this.ring.random(n);
            ringElem2 = (RingElem)ringElem2.remainder(this.ideal);
        }
        return new Local<RingElem>(this, ringElem, ringElem2, false);
    }

    @Override
    public Local<C> random(int n, Random random) {
        RingElem ringElem = (RingElem)this.ring.random(n, random);
        RingElem ringElem2 = (RingElem)this.ring.random(n, random);
        ringElem2 = (RingElem)ringElem2.remainder(this.ideal);
        while (ringElem2.isZERO()) {
            logger.debug((Object)"zero was in ideal");
            ringElem2 = (RingElem)this.ring.random(n, random);
            ringElem2 = (RingElem)ringElem2.remainder(this.ideal);
        }
        return new Local<RingElem>(this, ringElem, ringElem2, false);
    }

    @Override
    public Local<C> parse(String string) {
        RingElem ringElem = (RingElem)this.ring.parse(string);
        return new Local<RingElem>(this, ringElem);
    }

    @Override
    public Local<C> parse(Reader reader) {
        RingElem ringElem = (RingElem)this.ring.parse(reader);
        return new Local<RingElem>(this, ringElem);
    }
}

