/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.FactorsMap;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class FactorRationalTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)FactorRationalTest.suite());
    }

    public FactorRationalTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorRationalTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testRationalFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder);
        FactorRational factorRational = new FactorRational();
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<BigRational>> genPolynomial;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl - 2, this.ll * i, this.el + i, this.q);
            GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl - 2, this.ll, this.el, this.q);
            if (genPolynomial3.isZERO() || genPolynomial2.isZERO()) continue;
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorRational.baseFactors(genPolynomial = genPolynomial2.multiply((BigRational)((Object)genPolynomial3)))).size() >= n) {
                FactorRationalTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorRationalTest.assertTrue((String)("#facs < " + n + ", b = " + genPolynomial3 + ", c = " + genPolynomial2 + ", sm = " + sortedMap), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorRational.isFactorization(genPolynomial, sortedMap);
            FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testRationalMultiFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2, termOrder);
        FactorRational factorRational = new FactorRational();
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<BigRational>> genPolynomial;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl - 2, this.ll * i, this.el + i, this.q);
            GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl - 2, this.ll, this.el, this.q);
            if (genPolynomial3.isZERO() || genPolynomial2.isZERO()) continue;
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorRational.factors(genPolynomial = genPolynomial2.multiply((BigRational)((Object)genPolynomial3)))).size() >= n) {
                FactorRationalTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorRationalTest.assertTrue((String)("#facs < " + n + ", b = " + genPolynomial3 + ", c = " + genPolynomial2 + ", sm = " + sortedMap), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorRational.isFactorization(genPolynomial, sortedMap);
            FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testBaseRationalAbsoluteFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"alpha"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 4L);
        genPolynomial = genPolynomial.sum((BigRational)genPolynomialRing.fromInteger(4L));
        FactorRational factorRational = new FactorRational();
        FactorsMap<BigRational> factorsMap = factorRational.baseFactorsAbsolute(genPolynomial);
        boolean bl = factorRational.isAbsoluteFactorization(factorsMap);
        FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }

    public void testRationalAbsoluteFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.univariate(1, 2L);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial3 = genPolynomial.sum((BigRational)((Object)genPolynomial2));
        FactorRational factorRational = new FactorRational();
        FactorsMap<GenPolynomial<BigRational>> factorsMap = factorRational.factorsAbsolute(genPolynomial3);
        boolean bl = factorRational.isAbsoluteFactorization(factorsMap);
        FactorRationalTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }
}

