/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.arith.BigInteger;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.KsubSet;
import edu.jas.util.LongIterable;
import edu.jas.util.PowerSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class IteratorsTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)IteratorsTest.suite());
    }

    public IteratorsTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(IteratorsTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testCartesianProduct() {
        int n;
        BigInteger bigInteger = new BigInteger();
        int n2 = 5;
        int n3 = 3;
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            n4 *= n3;
        }
        ArrayList<Iterable<Object>> arrayList = new ArrayList<Iterable<Object>>(n2);
        for (n = 0; n < n2; ++n) {
            ArrayList arrayList2 = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList2.add(bigInteger.fromInteger(i));
            }
            arrayList.add(arrayList2);
        }
        n = 0;
        for (List list : new CartesianProduct(arrayList)) {
            ++n;
            IteratorsTest.assertTrue((String)("|tuple| == " + n2 + " "), (n2 == list.size() ? 1 : 0) != 0);
        }
        IteratorsTest.assertTrue((String)("#tuple == " + n4 + " == " + n + " "), (n == n4 ? 1 : 0) != 0);
    }

    public void testPowerSet() {
        int n;
        BigInteger bigInteger = new BigInteger();
        int n2 = 5;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= 2;
        }
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(bigInteger.random(7));
        }
        n = 0;
        for (List list : new PowerSet(arrayList)) {
            ++n;
            IteratorsTest.assertFalse((String)"tuple != null", (list == null ? 1 : 0) != 0);
        }
        IteratorsTest.assertTrue((String)("#tuple == " + n3 + " == " + n + " "), (n == n3 ? 1 : 0) != 0);
    }

    public void testKsubSet() {
        int n;
        BigInteger bigInteger = new BigInteger();
        int n2 = 5;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= 2;
        }
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(bigInteger.random(7));
        }
        n = 0;
        for (int i = 0; i <= n2; ++i) {
            for (List list : new KsubSet(arrayList, i)) {
                ++n;
                IteratorsTest.assertTrue((String)("|tuple| == " + i + " "), (i == list.size() ? 1 : 0) != 0);
            }
        }
        IteratorsTest.assertTrue((String)("#tuple == " + n3 + " == " + n + " "), (n == n3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void testInfiniteCartesianProductTwoList() {
        int n;
        BigInteger bigInteger = new BigInteger();
        bigInteger.setNonNegativeIterator();
        int n2 = 2;
        ArrayList<Iterable<BigInteger>> arrayList = new ArrayList<Iterable<BigInteger>>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(bigInteger);
        }
        HashSet<List> hashSet = new HashSet<List>();
        int n3 = 5;
        ArrayList<Iterable<Object>> arrayList2 = new ArrayList<Iterable<Object>>(n2);
        for (n = 0; n < n2; ++n) {
            ArrayList arrayList3 = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList3.add(bigInteger.fromInteger(i));
            }
            arrayList2.add(arrayList3);
        }
        n = 0;
        for (List list : new CartesianProduct(arrayList2)) {
            ++n;
            hashSet.add(list);
        }
        int n4 = 0;
        boolean n5 = false;
        CartesianProductInfinite cartesianProductInfinite = new CartesianProductInfinite(arrayList);
        for (List list : cartesianProductInfinite) {
            void var9_15;
            ++n4;
            if (hashSet.contains(list)) {
                ++var9_15;
            }
            if (var9_15 >= n) break;
            IteratorsTest.assertTrue((String)("#tuple <= 125 " + n4), (n4 <= 125 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testInfiniteCartesianProduct() {
        int n;
        BigInteger bigInteger = new BigInteger();
        bigInteger.setNonNegativeIterator();
        int n2 = 4;
        ArrayList<Iterable<BigInteger>> arrayList = new ArrayList<Iterable<BigInteger>>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(bigInteger);
        }
        HashSet<List> hashSet = new HashSet<List>();
        int n3 = 5;
        ArrayList<Iterable<Object>> arrayList2 = new ArrayList<Iterable<Object>>(n2);
        for (n = 0; n < n2; ++n) {
            ArrayList arrayList3 = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList3.add(bigInteger.fromInteger(i));
            }
            arrayList2.add(arrayList3);
        }
        n = 0;
        for (List list : new CartesianProduct(arrayList2)) {
            ++n;
            hashSet.add(list);
        }
        int n4 = 0;
        boolean n5 = false;
        CartesianProductInfinite cartesianProductInfinite = new CartesianProductInfinite(arrayList);
        for (List list : cartesianProductInfinite) {
            void var9_15;
            ++n4;
            if (hashSet.contains(list)) {
                ++var9_15;
            }
            if (var9_15 >= n) break;
            IteratorsTest.assertTrue((String)("#tuple <= 3281 " + n4), (n4 <= 3281 ? 1 : 0) != 0);
        }
    }

    public void testLong() {
        LongIterable longIterable = new LongIterable();
        longIterable.setNonNegativeIterator();
        long l = 0L;
        long l2 = 0L;
        for (Long l3 : longIterable) {
            l = l3;
            IteratorsTest.assertTrue((String)"t == i", (l2 == l3 ? 1 : 0) != 0);
            if (++l2 <= 1000L) continue;
            break;
        }
        IteratorsTest.assertTrue((String)"i == 1000", (l == 1000L ? 1 : 0) != 0);
        longIterable.setAllIterator();
        l = 0L;
        l2 = 0L;
        for (Long l3 : longIterable) {
            l = l3;
            if (++l2 < 1000L) continue;
            break;
        }
        IteratorsTest.assertTrue((String)"i == 500", (l == 500L ? 1 : 0) != 0);
    }
}

