/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufdroot;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RootUtil;
import edu.jas.structure.RingElem;
import edu.jas.ufdroot.FactorRealAlgebraic;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class FactorRealAlgebraicTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)FactorRealAlgebraicTest.suite());
    }

    public FactorRealAlgebraicTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorRealAlgebraicTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testRealAlgebraicFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"alpha"};
        String[] stringArray2 = new String[]{"z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L);
        genPolynomial = genPolynomial.subtract((BigRational)genPolynomialRing.fromInteger(2L));
        Interval<BigRational> interval = RootUtil.parseInterval(bigRational, "[0,2]");
        RealAlgebraicRing<BigRational> realAlgebraicRing = new RealAlgebraicRing<BigRational>(genPolynomial, interval, true);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(realAlgebraicRing, 1, termOrder, stringArray2);
        FactorRealAlgebraic<BigRational> factorRealAlgebraic = new FactorRealAlgebraic<BigRational>(realAlgebraicRing);
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial2;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing2.random(2, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial4 = genPolynomialRing2.random(2, this.ll + i, this.el + i, this.q);
            if (genPolynomial4.degree() == 0L) {
                genPolynomial4 = genPolynomial4.multiply((RingElem<BigRational>)genPolynomialRing2.univariate(0));
            }
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial4.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorRealAlgebraic.baseFactors(genPolynomial2 = genPolynomial3.multiply((BigRational)((Object)genPolynomial4)))).size() >= n) {
                FactorRealAlgebraicTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + n);
            }
            boolean bl = factorRealAlgebraic.isFactorization(genPolynomial2, sortedMap);
            FactorRealAlgebraicTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }
}

