/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.OverlapList;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class WordTest
extends TestCase {
    Word a;
    Word b;
    Word c;
    Word d;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)WordTest.suite());
    }

    public WordTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        WordFactory wordFactory = new WordFactory("abcdefg");
        this.b = this.a = new Word(wordFactory);
        WordTest.assertEquals((String)"() = ()", (Object)this.a, (Object)this.b);
        WordTest.assertEquals((String)"length( () ) = 0", (int)this.a.length(), (int)0);
        WordTest.assertTrue((String)"isONE( () )", (boolean)this.a.isONE());
        WordTest.assertTrue((String)"isUnit( () )", (boolean)this.a.isUnit());
        this.b = new Word(wordFactory, "abc");
        this.c = wordFactory.parse(" a b c ");
        WordTest.assertEquals((String)"b = c: ", (Object)this.b, (Object)this.c);
        WordTest.assertFalse((String)"isONE( () )", (boolean)this.b.isONE());
        WordTest.assertFalse((String)"isUnit( () )", (boolean)this.b.isUnit());
        WordTest.assertFalse((String)"isONE( () )", (boolean)this.c.isONE());
        WordTest.assertFalse((String)"isUnit( () )", (boolean)this.c.isUnit());
        String string = this.b.toString();
        String string2 = this.c.toString();
        WordTest.assertEquals((String)"s = t: ", (String)string, (String)string2);
    }

    public void testFactory() {
        WordFactory wordFactory = new WordFactory("abcdefg");
        Word word = wordFactory.getONE();
        WordTest.assertTrue((String)"w == (): ", (boolean)word.isONE());
        word = wordFactory.parse("aaabbbcccaaa");
        WordTest.assertFalse((String)"w != (): ", (boolean)word.isONE());
        this.a = wordFactory.parse(word.toString());
        WordTest.assertEquals((String)"w = a", (Object)this.a, (Object)word);
        WordFactory wordFactory2 = new WordFactory(word.toString());
        this.a = wordFactory2.parse(word.toString());
        WordTest.assertEquals((String)"w = a", (Object)this.a, (Object)word);
        List<Word> list = wordFactory.generators();
        WordTest.assertTrue((String)"#gens == 7: ", (list.size() == 7 ? 1 : 0) != 0);
        for (Word word2 : list) {
            this.a = wordFactory.parse(word2.toString());
            WordTest.assertEquals((String)"a == v", (Object)this.a, (Object)word2);
        }
    }

    public void testRandom() {
        WordFactory wordFactory = new WordFactory("uvw");
        this.a = wordFactory.random(5);
        this.b = wordFactory.random(6);
        this.c = wordFactory.random(7);
        WordTest.assertFalse((String)"a != (): ", (boolean)this.a.isONE());
        WordTest.assertFalse((String)"b != (): ", (boolean)this.b.isONE());
        WordTest.assertFalse((String)"c != (): ", (boolean)this.c.isONE());
        WordTest.assertTrue((String)"#a == 5", (this.a.length() == 5 ? 1 : 0) != 0);
        WordTest.assertTrue((String)"#b == 6", (this.b.length() == 6 ? 1 : 0) != 0);
        WordTest.assertTrue((String)"#c == 7", (this.c.length() == 7 ? 1 : 0) != 0);
        SortedMap<String, Integer> sortedMap = this.a.dependencyOnVariables();
        SortedMap<String, Integer> sortedMap2 = this.b.dependencyOnVariables();
        SortedMap<String, Integer> sortedMap3 = this.c.dependencyOnVariables();
        WordTest.assertTrue((String)"#ma <= 3", (sortedMap.size() <= wordFactory.length() ? 1 : 0) != 0);
        WordTest.assertTrue((String)"#mb <= 3", (sortedMap2.size() <= wordFactory.length() ? 1 : 0) != 0);
        WordTest.assertTrue((String)"#mc <= 3", (sortedMap3.size() <= wordFactory.length() ? 1 : 0) != 0);
        WordTest.assertTrue((String)"S ma <= #a", (this.sum(sortedMap.values()) == this.a.length() ? 1 : 0) != 0);
        WordTest.assertTrue((String)"S mb <= #b", (this.sum(sortedMap2.values()) == this.b.length() ? 1 : 0) != 0);
        WordTest.assertTrue((String)"S mc <= #c", (this.sum(sortedMap3.values()) == this.c.length() ? 1 : 0) != 0);
    }

    int sum(Collection<Integer> collection) {
        int n = 0;
        for (Integer n2 : collection) {
            n += n2.intValue();
        }
        return n;
    }

    public void testMultiplication() {
        WordFactory wordFactory = new WordFactory("abcdefgx");
        this.a = new Word(wordFactory, "abc");
        this.b = new Word(wordFactory, "cddaa");
        this.c = this.a.multiply(this.b);
        WordTest.assertTrue((String)"divides: ", (boolean)this.a.divides(this.c));
        WordTest.assertTrue((String)"divides: ", (boolean)this.b.divides(this.c));
        WordTest.assertTrue((String)"multiple: ", (boolean)this.c.multipleOf(this.a));
        WordTest.assertTrue((String)"multiple: ", (boolean)this.c.multipleOf(this.b));
        this.d = this.c.divide(this.a);
        WordTest.assertEquals((String)"d = b", (Object)this.d, (Object)this.b);
        this.d = this.c.divide(this.b);
        WordTest.assertEquals((String)"d = a", (Object)this.d, (Object)this.a);
        this.d = this.c.divide(this.c);
        WordTest.assertTrue((String)"isONE( () )", (boolean)this.d.isONE());
        this.d = new Word(wordFactory, "xx");
        this.c = this.a.multiply(this.d).multiply(this.b);
        WordTest.assertTrue((String)"divides: ", (boolean)this.d.divides(this.c));
        Word[] wordArray = this.c.divideWord(this.d);
        WordTest.assertEquals((String)"prefix(c/d) = a", (Object)this.a, (Object)wordArray[0]);
        WordTest.assertEquals((String)"suffix(c/d) = b", (Object)this.b, (Object)wordArray[1]);
        Word word = wordArray[0].multiply(this.d).multiply(wordArray[1]);
        WordTest.assertEquals((String)"prefix(c/d) d suffix(c/d) = e", (Object)word, (Object)this.c);
    }

    public void testOverlap() {
        WordFactory wordFactory = new WordFactory("abcdefg");
        this.a = new Word(wordFactory, "abc");
        this.b = new Word(wordFactory, "ddabca");
        OverlapList overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
        this.a = new Word(wordFactory, "abcfff");
        this.b = new Word(wordFactory, "ddabc");
        overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
        this.a = new Word(wordFactory, "fffabc");
        this.b = new Word(wordFactory, "abcdd");
        overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
        this.a = new Word(wordFactory, "ab");
        this.b = new Word(wordFactory, "dabeabfabc");
        overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
        this.a = new Word(wordFactory, "abc");
        this.b = new Word(wordFactory, "abceabcfabc");
        overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
        this.a = new Word(wordFactory, "aa");
        this.b = new Word(wordFactory, "aaaaaaaaa");
        overlapList = this.a.overlap(this.b);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.a, this.b));
        overlapList = this.b.overlap(this.a);
        WordTest.assertTrue((String)"isOverlap: ", (boolean)overlapList.isOverlap(this.b, this.a));
    }

    public void testValueOf() {
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        WordFactory wordFactory = new WordFactory(stringArray);
        ExpVector expVector = ExpVector.random(4, 5L, 0.5f);
        this.a = wordFactory.valueOf(expVector);
        WordTest.assertTrue((String)("deg(ef) == deg(a): " + expVector + ", " + this.a), (expVector.degree() == this.a.degree() ? 1 : 0) != 0);
        String string = expVector.toString(stringArray);
        WordTest.assertTrue((String)("ef != ''" + expVector), (string.length() >= 0 ? 1 : 0) != 0);
    }

    public void testMultiLetters() {
        String[] stringArray = new String[]{"a1", "b", " e23", "tt*", "x y"};
        WordFactory wordFactory = new WordFactory(stringArray);
        String string = wordFactory.toString();
        WordTest.assertEquals((String)"w == vars: ", (String)string, (String)"\"a1,b,e23,tt,xy\"");
        Word word = wordFactory.parse("a1 a1 b*b*b tt xy e23 tt xy");
        string = word.toString();
        String string2 = "\"a1 a1 b b b tt xy e23 tt xy\"";
        WordTest.assertEquals((String)"w == parse: ", (String)string, (String)string2);
        Word word2 = wordFactory.parse("xy e23 tt xy a1 a1 b*b*b tt");
        string = word2.toString();
        String string3 = "\"xy e23 tt xy a1 a1 b b b tt\"";
        WordTest.assertEquals((String)"w == parse: ", (String)string, (String)string3);
        Word word3 = word2.multiply(word);
        string = word3.toString();
        String string4 = string3.substring(0, string3.length() - 1) + " " + string2.substring(1);
        WordTest.assertEquals((String)"w == parse: ", (String)string, (String)string4);
        word3 = word.multiply(word2);
        string = word3.toString();
        string4 = string2.substring(0, string2.length() - 1) + " " + string3.substring(1);
        WordTest.assertEquals((String)"w == parse: ", (String)string, (String)string4);
        word = wordFactory.random(5);
        word2 = wordFactory.random(5);
        word3 = word2.multiply(word);
        WordTest.assertTrue((String)"#v = #w+#u: ", (word3.length() == word.length() + word2.length() ? 1 : 0) != 0);
        List<Word> list = wordFactory.generators();
        WordTest.assertTrue((String)"#gens == 5: ", (list.size() == 5 ? 1 : 0) != 0);
        for (Word word4 : list) {
            this.a = wordFactory.parse(word4.toString());
            WordTest.assertEquals((String)"a == x", (Object)this.a, (Object)word4);
        }
    }

    public void testExpVector() {
        String[] stringArray = new String[]{"a", "b", "cc", "d1", "g"};
        WordFactory wordFactory = new WordFactory(stringArray);
        Word word = wordFactory.random(10);
        long l = word.degree();
        long l2 = 0L;
        Word word2 = word;
        while (!word2.isONE()) {
            ExpVector expVector = word2.leadingExpVector();
            Word word3 = word2.reductum();
            l2 += expVector.degree();
            Word word4 = wordFactory.valueOf(expVector);
            Word word5 = word4.multiply(word3);
            WordTest.assertEquals((String)"r == w2", (Object)word2, (Object)word5);
            word2 = word3;
        }
        WordTest.assertTrue((String)("deg(prod(ef)) == deg(w): " + l + ", " + l2), (l == l2 ? 1 : 0) != 0);
    }
}

