/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.PersistentObject;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;

public abstract class AbstractFormatter
extends PersistentObject {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String DECIMAL = "decimal";
    public static final int DEFAULT_MIN_COLUMN_WIDTH = 1;
    public static final String DEFAULT_COLUMN_SEPARATOR = " ";
    public static final String DEFAULT_ROW_SEPARATOR = "\n";
    public static final String DEFAULT_SLICE_SEPARATOR = "\n\n";
    protected String alignment = "left";
    protected String format = "%G";
    protected int minColumnWidth = 1;
    protected String columnSeparator = " ";
    protected String rowSeparator = "\n";
    protected String sliceSeparator = "\n\n";
    protected boolean printShape = true;
    private static String[] blanksCache;
    protected static final FormerFactory factory;

    protected AbstractFormatter() {
    }

    protected void align(String[][] stringArray) {
        int n;
        int n2 = stringArray.length;
        int n3 = 0;
        if (n2 > 0) {
            n3 = stringArray[0].length;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = null;
        boolean bl = this.alignment.equals(DECIMAL);
        if (bl) {
            nArray2 = new int[n3];
        }
        for (n = 0; n < n3; ++n) {
            int n4 = this.minColumnWidth;
            int n5 = Integer.MIN_VALUE;
            for (int i = 0; i < n2; ++i) {
                String string = stringArray[i][n];
                n4 = Math.max(n4, string.length());
                if (!bl) continue;
                n5 = Math.max(n5, this.lead(string));
            }
            nArray[n] = n4;
            if (!bl) continue;
            nArray2[n] = n5;
        }
        for (n = 0; n < n2; ++n) {
            this.alignRow(stringArray[n], nArray, nArray2);
        }
    }

    protected int alignmentCode(String string) {
        if (string.equals(LEFT)) {
            return -1;
        }
        if (string.equals(CENTER)) {
            return 0;
        }
        if (string.equals(RIGHT)) {
            return 1;
        }
        if (string.equals(DECIMAL)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown alignment: " + string);
    }

    protected void alignRow(String[] stringArray, int[] nArray, int[] nArray2) {
        int n = this.alignmentCode(this.alignment);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.setLength(0);
            String string = stringArray[i];
            if (this.alignment.equals(RIGHT)) {
                stringBuffer.append(this.blanks(nArray[i] - stringBuffer.length()));
                stringBuffer.append(string);
            } else if (this.alignment.equals(DECIMAL)) {
                stringBuffer.append(this.blanks(nArray2[i] - this.lead(string)));
                stringBuffer.append(string);
                stringBuffer.append(this.blanks(nArray[i] - stringBuffer.length()));
            } else if (this.alignment.equals(CENTER)) {
                stringBuffer.append(this.blanks((nArray[i] - string.length()) / 2));
                stringBuffer.append(string);
                stringBuffer.append(this.blanks(nArray[i] - stringBuffer.length()));
            } else if (this.alignment.equals(LEFT)) {
                stringBuffer.append(string);
                stringBuffer.append(this.blanks(nArray[i] - stringBuffer.length()));
            } else {
                throw new InternalError();
            }
            stringArray[i] = stringBuffer.toString();
        }
    }

    protected String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n < blanksCache.length) {
            return blanksCache[n];
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void demo1() {
    }

    public static void demo2() {
    }

    public static void demo3(int n, Object object) {
    }

    protected abstract String form(AbstractMatrix1D var1, int var2, Former var3);

    protected abstract String[][] format(AbstractMatrix2D var1);

    protected String[] formatRow(AbstractMatrix1D abstractMatrix1D) {
        Former former = null;
        former = factory.create(this.format);
        int n = abstractMatrix1D.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.form(abstractMatrix1D, i, former);
        }
        return stringArray;
    }

    protected int lead(String string) {
        return string.length();
    }

    protected String repeat(char c, int n) {
        if (c == ' ') {
            return this.blanks(n);
        }
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void setAlignment(String string) {
        this.alignment = string;
    }

    public void setColumnSeparator(String string) {
        this.columnSeparator = string;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setMinColumnWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minColumnWidth = n;
    }

    public void setPrintShape(boolean bl) {
        this.printShape = bl;
    }

    public void setRowSeparator(String string) {
        this.rowSeparator = string;
    }

    public void setSliceSeparator(String string) {
        this.sliceSeparator = string;
    }

    protected static void setupBlanksCache() {
        int n = 40;
        blanksCache = new String[n];
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = n;
        while (--n2 >= 0) {
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        int n3 = n;
        while (--n3 >= 0) {
            AbstractFormatter.blanksCache[n3] = string.substring(0, n3);
        }
    }

    public static String shape(AbstractMatrix1D abstractMatrix1D) {
        return abstractMatrix1D.size() + " matrix";
    }

    public static String shape(AbstractMatrix2D abstractMatrix2D) {
        return abstractMatrix2D.rows() + " x " + abstractMatrix2D.columns() + " matrix";
    }

    public static String shape(AbstractMatrix3D abstractMatrix3D) {
        return abstractMatrix3D.slices() + " x " + abstractMatrix3D.rows() + " x " + abstractMatrix3D.columns() + " matrix";
    }

    protected String toString(String[][] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray.length <= 0 ? 0 : stringArray[0].length;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer2.setLength(0);
            for (int j = 0; j < n2; ++j) {
                stringBuffer2.append(stringArray[i][j]);
                if (j >= n2 - 1) continue;
                stringBuffer2.append(this.columnSeparator);
            }
            stringBuffer.append(stringBuffer2);
            if (i >= n - 1) continue;
            stringBuffer.append(this.rowSeparator);
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        String[][] stringArray = this.format(abstractMatrix2D);
        this.align(stringArray);
        StringBuffer stringBuffer = new StringBuffer(this.toString(stringArray));
        if (this.printShape) {
            stringBuffer.insert(0, AbstractFormatter.shape(abstractMatrix2D) + DEFAULT_ROW_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    static {
        factory = new FormerFactory();
        AbstractFormatter.setupBlanksCache();
    }
}

