/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ProductTest
extends TestCase {
    ProductRing<BigRational> fac;
    ModIntegerRing pfac;
    ProductRing<ModInteger> mfac;
    ProductRing<BigInteger> ifac;
    Product<BigRational> a;
    Product<BigRational> b;
    Product<BigRational> c;
    Product<BigRational> d;
    Product<BigRational> e;
    Product<BigRational> f;
    Product<ModInteger> ap;
    Product<ModInteger> bp;
    Product<ModInteger> cp;
    Product<ModInteger> dp;
    Product<ModInteger> ep;
    Product<ModInteger> fp;
    Product<BigInteger> ai;
    Product<BigInteger> bi;
    Product<BigInteger> ci;
    Product<BigInteger> di;
    Product<BigInteger> ei;
    Product<BigInteger> fi;
    int pl = 5;
    int rl = 1;
    int kl = 13;
    int ll = 7;
    int el = 3;
    float q = 0.9f;
    int il = 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ProductTest.suite());
    }

    public ProductTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ProductTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        BigRational bigRational = new BigRational(2L, 3L);
        this.fac = new ProductRing<BigRational>(bigRational, this.pl);
        ArrayList arrayList = new ArrayList();
        this.pfac = new ModIntegerRing(2L);
        arrayList.add(this.pfac);
        this.pfac = new ModIntegerRing(3L);
        arrayList.add(this.pfac);
        this.pfac = new ModIntegerRing(5L);
        arrayList.add(this.pfac);
        this.pfac = new ModIntegerRing(7L);
        arrayList.add(this.pfac);
        this.mfac = new ProductRing(arrayList);
        BigInteger bigInteger = new BigInteger(3L);
        this.ifac = new ProductRing<BigInteger>(bigInteger, this.pl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.fac = null;
        this.pfac = null;
        this.mfac = null;
        this.ifac = null;
    }

    public void testRatConstruction() {
        this.c = this.fac.getONE();
        ProductTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ProductTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ProductTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ProductTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testModConstruction() {
        this.cp = this.mfac.getONE();
        ProductTest.assertTrue((String)"isZERO( cp )", (!this.cp.isZERO() ? 1 : 0) != 0);
        ProductTest.assertTrue((String)"isONE( cp )", (boolean)this.cp.isONE());
        this.dp = this.mfac.getZERO();
        ProductTest.assertTrue((String)"isZERO( dp )", (boolean)this.dp.isZERO());
        ProductTest.assertTrue((String)"isONE( dp )", (!this.dp.isONE() ? 1 : 0) != 0);
    }

    public void testRatRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1));
            if (this.a.isZERO()) continue;
            ProductTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ProductTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            this.a = this.fac.random(this.kl, this.q);
            if (this.a.isZERO()) continue;
            ProductTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ProductTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testModRandom() {
        for (int i = 0; i < 7; ++i) {
            this.ap = this.mfac.random(this.kl, this.q);
            if (this.ap.isZERO() || this.ap.isONE()) continue;
            ProductTest.assertTrue((String)(" not isZERO( ap" + i + " )"), (!this.ap.isZERO() ? 1 : 0) != 0);
            ProductTest.assertTrue((String)(" not isONE( ap" + i + " )"), (!this.ap.isONE() ? 1 : 0) != 0);
        }
    }

    public void testRatAddition() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        ProductTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ProductTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        ProductTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Product<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((Product<BigRational>)this.fac.getZERO());
        ProductTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Product)this.fac.getZERO()).sum(this.a);
        this.d = ((Product)this.fac.getZERO()).subtract(this.a.negate());
        ProductTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testIntAddition() {
        this.ai = this.ifac.random(this.kl, this.q);
        this.bi = this.ifac.random(this.kl, this.q);
        this.ci = this.ai.sum(this.bi);
        this.di = this.ci.subtract(this.bi);
        ProductTest.assertEquals((String)"a+b-b = a", this.ai, this.di);
        this.ci = this.ai.sum(this.bi);
        this.di = this.bi.sum(this.ai);
        ProductTest.assertEquals((String)"a+b = b+a", this.ci, this.di);
        this.ci = this.ifac.random(this.kl, this.q);
        this.di = this.ci.sum(this.ai.sum(this.bi));
        this.ei = this.ci.sum(this.ai).sum(this.bi);
        ProductTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.di, this.ei);
        this.ci = this.ai.sum((Product<BigInteger>)this.ifac.getZERO());
        this.di = this.ai.subtract((Product<BigInteger>)this.ifac.getZERO());
        ProductTest.assertEquals((String)"a+0 = a-0", this.ci, this.di);
        this.ci = ((Product)this.ifac.getZERO()).sum(this.ai);
        this.di = ((Product)this.ifac.getZERO()).subtract(this.ai.negate());
        ProductTest.assertEquals((String)"0+a = 0+(-a)", this.ci, this.di);
    }

    public void testModAddition() {
        this.ap = this.mfac.random(this.kl, this.q);
        this.bp = this.mfac.random(this.kl, this.q);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.cp.subtract(this.bp);
        ProductTest.assertEquals((String)"a+b-b = a", this.ap, this.dp);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.bp.sum(this.ap);
        ProductTest.assertEquals((String)"a+b = b+a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl, this.q);
        this.dp = this.cp.sum(this.ap.sum(this.bp));
        this.ep = this.cp.sum(this.ap).sum(this.bp);
        ProductTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dp, this.ep);
        this.cp = this.ap.sum((Product<ModInteger>)this.mfac.getZERO());
        this.dp = this.ap.subtract((Product<ModInteger>)this.mfac.getZERO());
        ProductTest.assertEquals((String)"a+0 = a-0", this.cp, this.dp);
        this.cp = ((Product)this.mfac.getZERO()).sum(this.ap);
        this.dp = ((Product)this.mfac.getZERO()).subtract(this.ap.negate());
        ProductTest.assertEquals((String)"0+a = 0+(-a)", this.cp, this.dp);
    }

    public void testRatMultiplication() {
        this.a = this.fac.random(this.kl);
        if (this.a.isZERO()) {
            return;
        }
        ProductTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl, this.q);
        if (this.b.isZERO()) {
            return;
        }
        ProductTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.d.subtract(this.c);
        ProductTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ProductTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ProductTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        ProductTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ProductTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.divide(this.b);
        this.d = this.a.remainder(this.b);
        this.e = this.c.multiply((BigRational)((Object)this.b)).sum((Product<Product<BigRational>>)this.d);
        this.f = this.a.multiply((BigRational)((Object)this.e.idempotent()));
        ProductTest.assertEquals((String)"a = (a/b)c+d ", this.e, this.f);
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((Product)this.fac.getONE()).multiply(this.a);
        ProductTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.b = this.a.idempotent();
        this.c = this.a.idemComplement();
        this.d = this.b.multiply((BigRational)((Object)this.c));
        ProductTest.assertEquals((String)"idem(a)*idemComp(a) = 0", this.d, (Object)this.fac.getZERO());
        this.d = this.b.sum(this.c);
        ProductTest.assertEquals((String)"idem(a)+idemComp(a) = 1", this.d, (Object)this.fac.getONE());
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            this.e = this.a.idempotent();
            ProductTest.assertEquals((String)"a*1/a = 1", this.e, this.d);
        }
    }

    public void testIntMultiplication() {
        this.ai = this.ifac.random(this.kl);
        while (this.ai.isZERO()) {
            this.ai = this.ifac.random(this.kl);
        }
        ProductTest.assertTrue((String)"not isZERO( a )", (!this.ai.isZERO() ? 1 : 0) != 0);
        this.bi = this.ifac.random(this.kl, this.q);
        if (this.bi.isZERO()) {
            this.bi = this.ifac.random(this.kl, this.q);
        }
        ProductTest.assertTrue((String)"not isZERO( b )", (!this.bi.isZERO() ? 1 : 0) != 0);
        this.ci = this.bi.multiply((BigInteger)((Object)this.ai));
        this.di = this.ai.multiply((BigInteger)((Object)this.bi));
        this.ei = this.di.subtract(this.ci);
        ProductTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ei), (boolean)this.ei.isZERO());
        ProductTest.assertTrue((String)"a*b = b*a", (boolean)this.ci.equals(this.di));
        ProductTest.assertEquals((String)"a*b = b*a", this.ci, this.di);
        this.ci = this.ifac.random(this.kl, this.q);
        this.di = this.ai.multiply((BigInteger)((Object)this.bi.multiply((BigInteger)((Object)this.ci))));
        this.ei = this.ai.multiply((BigInteger)((Object)this.bi)).multiply(this.ci);
        ProductTest.assertEquals((String)"a(bc) = (ab)c", this.di, this.ei);
        ProductTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.di.equals(this.ei));
        this.ci = this.ai.divide(this.bi);
        this.di = this.ai.remainder(this.bi);
        this.ei = this.ci.multiply((BigInteger)((Object)this.bi)).sum((Product<Product<BigInteger>>)this.di);
        this.fi = this.ai.multiply((BigInteger)((Object)this.ei.idempotent()));
        ProductTest.assertEquals((String)"a = (a/b)c+d ", this.ei, this.fi);
        this.ci = this.ai.gcd(this.bi);
        this.di = this.ai.remainder(this.ci);
        this.ei = this.bi.remainder(this.ci);
        ProductTest.assertTrue((String)"gcd(a,b) | a ", (boolean)this.di.isZERO());
        ProductTest.assertTrue((String)"gcd(a,b) | b ", (boolean)this.ei.isZERO());
        Product<BigInteger>[] productArray = this.ai.egcd(this.bi);
        this.ci = productArray[0];
        this.di = this.ai.remainder(this.ci);
        this.ei = this.bi.remainder(this.ci);
        ProductTest.assertTrue((String)"gcd(a,b) | a ", (boolean)this.di.isZERO());
        ProductTest.assertTrue((String)"gcd(a,b) | b ", (boolean)this.ei.isZERO());
        this.di = this.ai.multiply((BigInteger)((Object)productArray[1]));
        this.ei = this.bi.multiply((BigInteger)((Object)productArray[2]));
        this.fi = this.di.sum(this.ei);
        ProductTest.assertEquals((String)"gcd(a,b) = c1*a + c2*b ", this.ci, this.fi);
        this.ci = this.ai.multiply((BigInteger)this.ifac.getONE());
        this.di = ((Product)this.ifac.getONE()).multiply(this.ai);
        ProductTest.assertEquals((String)"a*1 = 1*a", this.ci, this.di);
        this.bi = this.ai.idempotent();
        this.ci = this.ai.idemComplement();
        this.di = this.bi.multiply((BigInteger)((Object)this.ci));
        ProductTest.assertEquals((String)"idem(a)*idemComp(a) = 0", this.di, (Object)this.ifac.getZERO());
        this.di = this.bi.sum(this.ci);
        ProductTest.assertEquals((String)"idem(a)+idemComp(a) = 1", this.di, (Object)this.ifac.getONE());
        if (this.ai.isUnit()) {
            this.ci = this.ai.inverse();
            this.di = this.ci.multiply((BigInteger)((Object)this.ai));
            this.ei = this.ai.idempotent();
            ProductTest.assertEquals((String)"a*1/a = 1", this.ei, this.di);
        }
    }

    public void testModMultiplication() {
        this.ap = this.mfac.random(this.kl, this.q);
        if (this.ap.isZERO()) {
            return;
        }
        ProductTest.assertTrue((String)"not isZERO( a )", (!this.ap.isZERO() ? 1 : 0) != 0);
        this.bp = this.mfac.random(this.kl, this.q);
        if (this.bp.isZERO()) {
            return;
        }
        ProductTest.assertTrue((String)"not isZERO( b )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.bp.multiply((ModInteger)((Object)this.ap));
        this.dp = this.ap.multiply((ModInteger)((Object)this.bp));
        this.ep = this.dp.subtract(this.cp);
        ProductTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ep), (boolean)this.ep.isZERO());
        ProductTest.assertTrue((String)"a*b = b*a", (boolean)this.cp.equals(this.dp));
        ProductTest.assertEquals((String)"a*b = b*a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl, this.q);
        this.dp = this.ap.multiply((ModInteger)((Object)this.bp.multiply((ModInteger)((Object)this.cp))));
        this.ep = this.ap.multiply((ModInteger)((Object)this.bp)).multiply(this.cp);
        ProductTest.assertEquals((String)"a(bc) = (ab)c", this.dp, this.ep);
        ProductTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.dp.equals(this.ep));
        this.cp = this.ap.divide(this.bp);
        this.dp = this.ap.remainder(this.bp);
        this.ep = this.cp.multiply((ModInteger)((Object)this.bp)).sum((Product<Product<ModInteger>>)this.dp);
        this.fp = this.ap.multiply((ModInteger)((Object)this.ep.idempotent()));
        ProductTest.assertEquals((String)"a = (a/b)c+d ", this.ep, this.fp);
        this.cp = this.ap.multiply((ModInteger)this.mfac.getONE());
        this.dp = ((Product)this.mfac.getONE()).multiply(this.ap);
        ProductTest.assertEquals((String)"a*1 = 1*a", this.cp, this.dp);
        this.bp = this.ap.idempotent();
        this.cp = this.ap.idemComplement();
        this.dp = this.bp.multiply((ModInteger)((Object)this.cp));
        ProductTest.assertEquals((String)"idem(a)*idemComp(a) = 0", this.dp, (Object)this.mfac.getZERO());
        this.dp = this.bp.sum(this.cp);
        ProductTest.assertEquals((String)"idem(a)+idemComp(a) = 1", this.dp, (Object)this.mfac.getONE());
        if (this.ap.isUnit()) {
            this.cp = this.ap.inverse();
            this.dp = this.cp.multiply((ModInteger)((Object)this.ap));
            this.ep = this.ap.idempotent();
            ProductTest.assertEquals((String)"a*1/a = 1", this.ep, this.dp);
        }
    }
}

