/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.SolvableReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SolvableReductionAbstract<C extends RingElem<C>>
implements SolvableReduction<C> {
    private static final Logger logger = Logger.getLogger(SolvableReductionAbstract.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public GenSolvablePolynomial<C> leftSPolynomial(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (logger.isInfoEnabled()) {
            if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
                if (genSolvablePolynomial != null) {
                    return genSolvablePolynomial.ring.getZERO();
                }
                return null;
            }
            if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
                return genSolvablePolynomial2.ring.getZERO();
            }
            if (!genSolvablePolynomial.ring.equals(genSolvablePolynomial2.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry entry = genSolvablePolynomial.leadingMonomial();
        Map.Entry entry2 = genSolvablePolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        GenSolvablePolynomial<RingElem> genSolvablePolynomial3 = genSolvablePolynomial.multiplyLeft(ringElem2, expVector4);
        GenSolvablePolynomial<RingElem> genSolvablePolynomial4 = genSolvablePolynomial2.multiplyLeft(ringElem, expVector5);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial4);
        return genSolvablePolynomial5;
    }

    @Override
    public GenSolvablePolynomial<C> leftSPolynomial(List<GenSolvablePolynomial<C>> list, int n, GenSolvablePolynomial<C> genSolvablePolynomial, int n2, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (this.debug) {
            if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
                throw new ArithmeticException("Spol B is zero");
            }
            if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
                throw new ArithmeticException("Spol A is zero");
            }
            if (!genSolvablePolynomial.ring.equals(genSolvablePolynomial2.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        Map.Entry entry = genSolvablePolynomial.leadingMonomial();
        Map.Entry entry2 = genSolvablePolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        GenSolvablePolynomial<RingElem> genSolvablePolynomial3 = genSolvablePolynomial.multiplyLeft(ringElem2, expVector4);
        GenSolvablePolynomial<RingElem> genSolvablePolynomial4 = genSolvablePolynomial2.multiplyLeft(ringElem, expVector5);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial4);
        GenPolynomial genPolynomial = genSolvablePolynomial.ring.getZERO();
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)genPolynomial.sum((RingElem)ringElem2.negate(), expVector4);
        GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)genPolynomial.sum(ringElem, expVector5);
        list.set(n, genSolvablePolynomial6);
        list.set(n2, genSolvablePolynomial7);
        return genSolvablePolynomial5;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftNormalform(List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2) {
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list2;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
            genSolvablePolynomial = this.leftNormalform(list, genSolvablePolynomial);
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftIrreducibleSet(List<GenSolvablePolynomial<C>> list) {
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenPolynomial genPolynomial : list) {
            if (genPolynomial.length() == 0) continue;
            genPolynomial = genPolynomial.monic();
            arrayList.add((GenSolvablePolynomial<C>)genPolynomial);
        }
        int n = arrayList.size();
        if (n <= 1) {
            return arrayList;
        }
        int n2 = 0;
        logger.debug((Object)"irr = ");
        while (n2 != n) {
            ListIterator<GenSolvablePolynomial<C>> listIterator = arrayList.listIterator();
            GenPolynomial genPolynomial = (GenSolvablePolynomial<C>)listIterator.next();
            arrayList.remove(0);
            ExpVector expVector = genPolynomial.leadingExpVector();
            genPolynomial = this.leftNormalform(arrayList, genPolynomial);
            logger.debug((Object)String.valueOf(n2));
            if (genPolynomial.length() == 0) {
                if (--n > 1) continue;
                return arrayList;
            }
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            if (expVector2.signum() == 0) {
                arrayList = new ArrayList();
                arrayList.add((GenSolvablePolynomial<C>)genPolynomial.monic());
                return arrayList;
            }
            if (expVector.equals(expVector2)) {
                ++n2;
            } else {
                n2 = 0;
                genPolynomial = genPolynomial.monic();
            }
            arrayList.add((GenSolvablePolynomial<C>)genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isLeftReductionNF(List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (list == null && list2 == null) {
            if (genSolvablePolynomial == null) {
                return genSolvablePolynomial2 == null;
            }
            return genSolvablePolynomial.equals(genSolvablePolynomial2);
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial2;
        for (int i = 0; i < list2.size(); ++i) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial4 = list.get(i);
            GenSolvablePolynomial<C> genSolvablePolynomial5 = list2.get(i);
            if (genSolvablePolynomial4 == null || genSolvablePolynomial5 == null) continue;
            genSolvablePolynomial3 = genSolvablePolynomial3 == null ? genSolvablePolynomial4.multiply(genSolvablePolynomial5) : (GenSolvablePolynomial)genSolvablePolynomial3.sum(genSolvablePolynomial4.multiply(genSolvablePolynomial5));
        }
        if (this.debug) {
            logger.info((Object)("t = " + genSolvablePolynomial3));
            logger.info((Object)("a = " + genSolvablePolynomial));
        }
        if (genSolvablePolynomial3 == null) {
            if (genSolvablePolynomial == null) {
                return true;
            }
            return genSolvablePolynomial.isZERO();
        }
        genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.subtract(genSolvablePolynomial);
        return genSolvablePolynomial3.isZERO();
    }

    @Override
    public GenSolvablePolynomial<C> rightSPolynomial(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (logger.isInfoEnabled()) {
            if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
                if (genSolvablePolynomial != null) {
                    return genSolvablePolynomial.ring.getZERO();
                }
                return null;
            }
            if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
                return genSolvablePolynomial2.ring.getZERO();
            }
            if (!genSolvablePolynomial.ring.equals(genSolvablePolynomial2.ring)) {
                logger.error((Object)"rings not equal");
            }
        }
        ExpVector expVector = genSolvablePolynomial.leadingExpVector();
        ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        GenPolynomial genPolynomial = genSolvablePolynomial.multiply(expVector4);
        GenPolynomial genPolynomial2 = genSolvablePolynomial2.multiply(expVector5);
        Object c = genPolynomial.leadingBaseCoefficient();
        Object c2 = genPolynomial2.leadingBaseCoefficient();
        genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply((RingElem)c2);
        genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply((RingElem)c);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial.subtract(genPolynomial2);
        return genSolvablePolynomial3;
    }

    @Override
    public boolean isTopReducible(List<GenSolvablePolynomial<C>> list, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = genSolvablePolynomial.leadingExpVector();
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
            bl = expVector.multipleOf(genSolvablePolynomial2.leadingExpVector());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReducible(List<GenSolvablePolynomial<C>> list, GenSolvablePolynomial<C> genSolvablePolynomial) {
        return !this.isNormalform(list, genSolvablePolynomial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenSolvablePolynomial<C>> list, GenSolvablePolynomial<C> genSolvablePolynomial) {
        int n;
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return true;
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{};
        List<GenSolvablePolynomial<C>> list2 = list;
        synchronized (list2) {
            genSolvablePolynomialArray = list.toArray(genSolvablePolynomialArray);
        }
        int n2 = genSolvablePolynomialArray.length;
        ExpVector[] expVectorArray = new ExpVector[n2];
        GenSolvablePolynomial[] genSolvablePolynomialArray2 = new GenSolvablePolynomial[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            genSolvablePolynomialArray2[n] = genSolvablePolynomialArray[n];
            ExpVector expVector = genSolvablePolynomialArray2[n].leadingExpVector();
            if (expVector == null) continue;
            genSolvablePolynomialArray2[n3] = genSolvablePolynomialArray2[n];
            expVectorArray[n3] = expVector;
            ++n3;
        }
        n2 = n3;
        boolean bl = false;
        for (ExpVector expVector : genSolvablePolynomial.getMap().keySet()) {
            for (n = 0; n < n2; ++n) {
                bl = expVector.multipleOf(expVectorArray[n]);
                if (!bl) continue;
                return false;
            }
        }
        return true;
    }
}

