/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.gbufd.MultiplicativeSetCoPrime;
import edu.jas.gbufd.MultiplicativeSetFactors;
import edu.jas.gbufd.MultiplicativeSetSquarefree;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class MultiplicativeSetTest
extends TestCase {
    TermOrder to;
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<? extends GenPolynomial<BigRational>> M;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)MultiplicativeSetTest.suite());
    }

    public MultiplicativeSetTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(MultiplicativeSetTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        ComputerThreads.terminate();
    }

    public void testContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSet<BigRational> multiplicativeSet = new MultiplicativeSet<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSet.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSet.contains(this.a));
        }
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSet2.contains(this.b));
        }
        MultiplicativeSet<BigRational> multiplicativeSet3 = multiplicativeSet2.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet3.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet3.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet3.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSet3.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet3.contains(this.e));
        }
        MultiplicativeSet<BigRational> multiplicativeSet4 = multiplicativeSet3.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)multiplicativeSet3.equals(multiplicativeSet4));
    }

    public void testRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSet<BigRational> multiplicativeSet = new MultiplicativeSet<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSet.isEmpty());
        this.e = multiplicativeSet.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.a));
            this.e = multiplicativeSet2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = multiplicativeSet2.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> multiplicativeSet3 = multiplicativeSet2.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet3.isEmpty());
            this.e = multiplicativeSet3.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet3.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet3.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = multiplicativeSet3.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testCoPrimeContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetCoPrime<BigRational> multiplicativeSetCoPrime = new MultiplicativeSetCoPrime<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetCoPrime.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSetCoPrime.contains(this.a));
        }
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetCoPrime).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet), (boolean)multiplicativeSet.contains(this.b));
        }
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet2), (boolean)multiplicativeSet2.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.e));
        }
        MultiplicativeSet<BigRational> multiplicativeSet3 = multiplicativeSet2.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)multiplicativeSet2.equals(multiplicativeSet3));
    }

    public void testCoPrimeRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetCoPrime<BigRational> multiplicativeSetCoPrime = new MultiplicativeSetCoPrime<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetCoPrime.isEmpty());
        this.e = multiplicativeSetCoPrime.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetCoPrime).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
            this.e = multiplicativeSet.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = multiplicativeSet.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            this.e = multiplicativeSet2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = multiplicativeSet2.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testSquarefreeContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetSquarefree<BigRational> multiplicativeSetSquarefree = new MultiplicativeSetSquarefree<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetSquarefree.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSetSquarefree.contains(this.a));
        }
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetSquarefree).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet), (boolean)multiplicativeSet.contains(this.b));
        }
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet2), (boolean)multiplicativeSet2.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.e));
        }
        MultiplicativeSet<BigRational> multiplicativeSet3 = multiplicativeSet2.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)multiplicativeSet2.equals(multiplicativeSet3));
    }

    public void testSquarefreeRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetSquarefree<BigRational> multiplicativeSetSquarefree = new MultiplicativeSetSquarefree<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetSquarefree.isEmpty());
        this.e = multiplicativeSetSquarefree.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetSquarefree).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
            this.e = multiplicativeSet.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = multiplicativeSet.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            this.e = multiplicativeSet2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = multiplicativeSet2.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testFactorsContaines() {
        this.a = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.c = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q).monic();
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetFactors<BigRational> multiplicativeSetFactors = new MultiplicativeSetFactors<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetFactors.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)multiplicativeSetFactors.contains(this.a));
        }
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetFactors).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
            if (!this.a.equals(this.b) && !this.b.isConstant()) {
                MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet + ", " + this.b), (boolean)multiplicativeSet.contains(this.b));
            }
        }
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.b);
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.b));
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            if (!(this.a.monic().equals(this.c) || this.b.monic().equals(this.c) || this.c.isConstant() || multiplicativeSet2.mset.contains(this.c))) {
                MultiplicativeSetTest.assertFalse((String)("not contained " + multiplicativeSet2 + ", " + this.c), (boolean)multiplicativeSet2.contains(this.c));
            }
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet2.contains(this.e));
        }
        MultiplicativeSet<BigRational> multiplicativeSet3 = multiplicativeSet2.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)multiplicativeSet2.equals(multiplicativeSet3));
    }

    public void testFactorsRemoveFactors() {
        this.a = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.c = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.d = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetFactors<BigRational> multiplicativeSetFactors = new MultiplicativeSetFactors<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)multiplicativeSetFactors.isEmpty());
        this.e = multiplicativeSetFactors.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> multiplicativeSet = ((MultiplicativeSet)multiplicativeSetFactors).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)multiplicativeSet.contains(this.a));
            this.e = multiplicativeSet.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = multiplicativeSet.removeFactors(this.b);
                MultiplicativeSetTest.assertTrue((String)"remove(b) | b ", (boolean)this.b.remainder(this.e).isZERO());
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> multiplicativeSet2 = multiplicativeSet.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)multiplicativeSet2.isEmpty());
            this.e = multiplicativeSet2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = multiplicativeSet2.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = multiplicativeSet2.removeFactors(this.c);
                MultiplicativeSetTest.assertTrue((String)"remove(c) | c ", (boolean)this.c.remainder(this.e).isZERO());
            }
        }
    }
}

