/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.WordIdeal;
import edu.jas.application.WordResidue;
import edu.jas.application.WordResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.structure.NotInvertibleException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class WordResidueTest
extends TestCase {
    WordIdeal<BigRational> id;
    WordResidueRing<BigRational> fac;
    GenWordPolynomialRing<BigRational> mfac;
    List<GenWordPolynomial<BigRational>> F;
    WordResidue<BigRational> a;
    WordResidue<BigRational> b;
    WordResidue<BigRational> c;
    WordResidue<BigRational> d;
    WordResidue<BigRational> e;
    int rl = 4;
    int kl = 3;
    int ll = 4;
    int el = 2;
    int il = this.rl == 1 ? 1 : 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)WordResidueTest.suite());
    }

    public WordResidueTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordResidueTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.mfac = new GenWordPolynomialRing<BigRational>(new BigRational(1L), stringArray);
        do {
            this.F = new ArrayList<GenWordPolynomial<BigRational>>(this.il);
            for (int i = 0; i < this.il; ++i) {
                GenWordPolynomial<BigRational> genWordPolynomial = this.mfac.random(this.kl, this.ll, this.el);
                while (genWordPolynomial.isConstant()) {
                    genWordPolynomial = this.mfac.random(this.kl, this.ll, this.el);
                }
                this.F.add(genWordPolynomial);
            }
            this.id = new WordIdeal<BigRational>(this.mfac, this.F);
            this.id.doGB();
        } while (this.id.isONE());
        assert (!this.id.isONE()) : "id = " + this.id;
        this.fac = new WordResidueRing<BigRational>(this.id);
        this.F = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.id = null;
        this.mfac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        WordResidueTest.assertTrue((String)"length( c ) = 1 ", (this.c.val.length() == 1 || this.id.isONE() ? 1 : 0) != 0);
        WordResidueTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() || this.id.isONE() ? 1 : 0) != 0);
        WordResidueTest.assertTrue((String)"isONE( c )", (this.c.isONE() || this.id.isONE() ? 1 : 0) != 0);
        this.d = this.fac.getZERO();
        WordResidueTest.assertTrue((String)"length( d ) = 0", (this.d.val.length() == 0 ? 1 : 0) != 0);
        WordResidueTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        WordResidueTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (WordResidue<BigRational> wordResidue : this.fac.generators()) {
            WordResidueTest.assertFalse((String)"not isZERO( g )", (boolean)wordResidue.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 1; i < 7; ++i) {
            this.a = this.fac.random(this.kl * i / 2, this.ll + i, this.el + i / 2);
            if (this.a.isZERO() || this.a.isONE()) continue;
            WordResidueTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.val.length() >= 0 ? 1 : 0) != 0);
            WordResidueTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            WordResidueTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el + 1);
        this.b = this.fac.random(this.kl, this.ll, this.el + 1);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        WordResidueTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        WordResidueTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        WordResidueTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((WordResidue<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((WordResidue<BigRational>)this.fac.getZERO());
        WordResidueTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((WordResidue)this.fac.getZERO()).sum(this.a);
        this.d = ((WordResidue)this.fac.getZERO()).subtract(this.a.negate());
        WordResidueTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        List<WordResidue<BigRational>> list = this.fac.generators();
        this.a = list.get(1);
        if (this.a.isZERO()) {
            this.a = this.fac.getONE();
        }
        WordResidueTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        if (this.b.isZERO()) {
            this.b = this.fac.getONE();
        }
        WordResidueTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((WordResidue)this.fac.getONE()).multiply(this.a);
        WordResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        WordResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.a);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        WordResidueTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        WordResidueTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.c = this.fac.random(this.kl, this.ll + 1, this.el);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        WordResidueTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        if (this.a.isUnit()) {
            try {
                this.c = this.a.inverse();
                this.d = this.c.multiply((BigRational)((Object)this.a));
                WordResidueTest.assertTrue((String)("a*1/a = 1: " + this.fac), (boolean)this.d.isONE());
            }
            catch (NotInvertibleException notInvertibleException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

