/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.gbufd.RGroebnerBasePseudoSeq;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GBFactoryTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GBFactoryTest.suite());
        ComputerThreads.terminate();
    }

    public GBFactoryTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GBFactoryTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract = GBFactory.getImplementation(bigInteger);
        GBFactoryTest.assertTrue((String)("bba integer " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoSeq));
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(modIntegerRing);
        GBFactoryTest.assertTrue((String)("bba modular field " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeq));
        modIntegerRing = new ModIntegerRing(30L);
        groebnerBaseAbstract = GBFactory.getImplementation(modIntegerRing);
        GBFactoryTest.assertTrue((String)("bba modular ring " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoSeq));
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        GBFactoryTest.assertTrue((String)("bba field " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeq));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        GroebnerBaseAbstract<BigComplex> groebnerBaseAbstract = GBFactory.getImplementation(bigComplex);
        GBFactoryTest.assertTrue((String)("bba field " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeq));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(algebraicNumberRing);
        GBFactoryTest.assertTrue((String)("bba algebraic ring " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoSeq));
        genPolynomial = genPolynomialRing.univariate(0).subtract((BigRational)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        groebnerBaseAbstract = GBFactory.getImplementation(algebraicNumberRing);
        GBFactoryTest.assertTrue((String)("bba algebraic field " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBaseSeq));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial);
        MonoidElem monoidElem = algebraicNumberRing.getONE();
        GBFactoryTest.assertTrue((String)("a == 1 " + monoidElem), (boolean)((AlgebraicNumber)monoidElem).isONE());
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(algebraicNumberRing);
        GBFactoryTest.assertTrue((String)("bba algebraic ring " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoSeq));
    }

    public void testGenPolynomial() {
        GenPolynomialRing<BigRational> genPolynomialRing;
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing2 = genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        GroebnerBaseAbstract<GenPolynomial<BigRational>> groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing);
        GBFactoryTest.assertTrue((String)("bba recursive polynomial " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GroebnerBasePseudoRecSeq));
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract2 = GBFactory.getImplementation(genPolynomialRing2);
        GBFactoryTest.assertTrue((String)("bba recursive polynomial " + groebnerBaseAbstract2), (boolean)(groebnerBaseAbstract2 instanceof GroebnerBasePseudoRecSeq));
    }

    public void testProduct() {
        ProductRing<ModInteger> productRing;
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        ProductRing<ModInteger> productRing2 = productRing = new ProductRing<ModInteger>(modIntegerRing, 3);
        GroebnerBaseAbstract<Product<ModInteger>> groebnerBaseAbstract = GBFactory.getImplementation(productRing);
        GBFactoryTest.assertTrue((String)("bba product " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof RGroebnerBaseSeq));
        modIntegerRing = new ModIntegerRing(30L);
        productRing2 = productRing = new ProductRing<ModInteger>(modIntegerRing, 3);
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract2 = GBFactory.getImplementation(productRing2);
        GBFactoryTest.assertTrue((String)("bba product " + groebnerBaseAbstract2), (boolean)(groebnerBaseAbstract2 instanceof RGroebnerBasePseudoSeq));
    }

    public void testProxy() {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getProxy(bigRational);
        GBFactoryTest.assertTrue((String)("bba field " + groebnerBaseAbstract), (boolean)(groebnerBaseAbstract instanceof GBProxy));
        groebnerBaseAbstract.terminate();
        ModIntegerRing modIntegerRing = new ModIntegerRing(6L);
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract2 = GBFactory.getProxy(modIntegerRing);
        GBFactoryTest.assertTrue((String)("bbm ! field " + groebnerBaseAbstract2), (!(groebnerBaseAbstract2 instanceof GBProxy) ? 1 : 0) != 0);
        groebnerBaseAbstract2.terminate();
    }
}

