/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigInteger;
import edu.jas.gb.EGroebnerBaseSeq;
import edu.jas.gb.GroebnerBase;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class EGroebnerBaseSeqTest
extends TestCase {
    GenPolynomialRing<BigInteger> fac;
    List<GenPolynomial<BigInteger>> L;
    PolynomialList<BigInteger> F;
    List<GenPolynomial<BigInteger>> G;
    GroebnerBase<BigInteger> bb;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 3;
    int kl = 4;
    int ll = 4;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)EGroebnerBaseSeqTest.suite());
    }

    public EGroebnerBaseSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(EGroebnerBaseSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        this.fac = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new EGroebnerBaseSeq<BigInteger>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q).abs();
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q).abs();
        this.c = this.fac.random(this.kl, this.ll / 2, this.el, this.q).abs();
        this.d = this.fac.random(this.kl, this.ll / 2, this.el, this.q).abs();
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void xtestTrinks7GBaseZ() {
        String string = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            EGroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            EGroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        System.out.println("F = " + this.F);
        this.G = this.bb.GB(this.F.list);
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        System.out.println("G = " + polynomialList);
        System.out.println("G.size() = " + this.G.size());
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( eGB(Trinks7) )", (boolean)this.bb.isGB(this.G));
    }

    public void xtestTrinks7GBaseZ_B() {
        String string = "IntFunc{ B } (S,T,Z,P,W) G ( ( { 45 } P + { 35 } S - { 165 B } - { 36 } ), ( { 35 } P + { 40 } Z + { 25 } T - { 27 } S ), ( { 15 } W + { 25 } S P + { 30 } Z - { 18 } T - { 165 B**2 } ), ( { - 9 } W + { 15 } T P + { 20 } S Z ), ( P W + { 2 } T Z - { 11 B**3 } ), ( { 99 } W - { 11 B } S + { 3 B**2 } ), ( { 10000 B**2 + 6600 B + 2673 } ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        EGroebnerBaseSeq eGroebnerBaseSeq = new EGroebnerBaseSeq();
        PolynomialList polynomialList2 = null;
        List list = null;
        try {
            polynomialList2 = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            EGroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            EGroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        System.out.println("F = " + polynomialList2);
        ArrayList arrayList = new ArrayList(polynomialList2.list.size());
        for (GenPolynomial genPolynomial : polynomialList2.list) {
            GenPolynomial polynomialList3 = PolyUtil.monic(genPolynomial);
            arrayList.add(polynomialList3);
        }
        list = eGroebnerBaseSeq.GB(arrayList);
        ArrayList arrayList2 = new ArrayList(polynomialList2.list.size());
        for (GenPolynomial genPolynomial : list) {
            GenPolynomial genPolynomial2 = PolyUtil.monic(genPolynomial);
            arrayList2.add(genPolynomial2);
        }
        PolynomialList polynomialList = new PolynomialList(polynomialList2.ring, arrayList2);
        System.out.println("G = " + polynomialList);
        System.out.println("G.size() = " + list.size());
        ComputerThreads.terminate();
        EGroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)eGroebnerBaseSeq.isGB(list));
    }
}

