/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;

class CoeffToRecAlg<C extends GcdRingElem<C>>
implements UnaryFunctor<C, AlgebraicNumber<C>> {
    protected final List<AlgebraicNumberRing<C>> lfac;
    final int depth;

    public CoeffToRecAlg(int n, AlgebraicNumberRing<C> algebraicNumberRing) {
        if (algebraicNumberRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        AlgebraicNumberRing algebraicNumberRing2 = algebraicNumberRing;
        this.depth = n;
        this.lfac = new ArrayList<AlgebraicNumberRing<C>>(this.depth);
        this.lfac.add(algebraicNumberRing);
        for (int i = 1; i < this.depth; ++i) {
            RingFactory ringFactory = algebraicNumberRing2.ring.coFac;
            if (!(ringFactory instanceof AlgebraicNumberRing)) {
                throw new IllegalArgumentException("fac depth to low");
            }
            algebraicNumberRing2 = (AlgebraicNumberRing)ringFactory;
            this.lfac.add(algebraicNumberRing2);
        }
    }

    @Override
    public AlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.lfac.get(0).getZERO();
        }
        Object object = c;
        AlgebraicNumberRing<C> algebraicNumberRing = this.lfac.get(this.lfac.size() - 1);
        AbelianGroupElem abelianGroupElem = algebraicNumberRing.ring.getZERO();
        AlgebraicNumber<C> algebraicNumber = new AlgebraicNumber<C>(algebraicNumberRing, ((GenPolynomial)abelianGroupElem).sum(object));
        for (int i = this.lfac.size() - 2; i >= 0; --i) {
            algebraicNumberRing = this.lfac.get(i);
            abelianGroupElem = algebraicNumberRing.ring.getZERO();
            object = algebraicNumber;
            algebraicNumber = new AlgebraicNumber<C>(algebraicNumberRing, ((GenPolynomial)abelianGroupElem).sum(object));
        }
        return algebraicNumber;
    }
}

