/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigQuaternion
implements StarRingElem<BigQuaternion>,
GcdRingElem<BigQuaternion>,
RingFactory<BigQuaternion> {
    public final BigRational re;
    public final BigRational im;
    public final BigRational jm;
    public final BigRational km;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigQuaternion.class);
    private final boolean debug = logger.isDebugEnabled();
    public static final BigQuaternion ZERO = new BigQuaternion();
    public static final BigQuaternion ONE = new BigQuaternion(BigRational.ONE);
    public static final BigQuaternion I = new BigQuaternion(BigRational.ZERO, BigRational.ONE);
    public static final BigQuaternion J = new BigQuaternion(BigRational.ZERO, BigRational.ZERO, BigRational.ONE);
    public static final BigQuaternion K = new BigQuaternion(BigRational.ZERO, BigRational.ZERO, BigRational.ZERO, BigRational.ONE);

    public BigQuaternion(BigRational bigRational, BigRational bigRational2, BigRational bigRational3, BigRational bigRational4) {
        this.re = bigRational;
        this.im = bigRational2;
        this.jm = bigRational3;
        this.km = bigRational4;
    }

    public BigQuaternion(BigRational bigRational, BigRational bigRational2, BigRational bigRational3) {
        this(bigRational, bigRational2, bigRational3, BigRational.ZERO);
    }

    public BigQuaternion(BigRational bigRational, BigRational bigRational2) {
        this(bigRational, bigRational2, BigRational.ZERO);
    }

    public BigQuaternion(BigRational bigRational) {
        this(bigRational, BigRational.ZERO);
    }

    public BigQuaternion(BigComplex bigComplex) {
        this(bigComplex.re, bigComplex.im);
    }

    public BigQuaternion(long l) {
        this(new BigRational(l), BigRational.ZERO);
    }

    public BigQuaternion() {
        this(BigRational.ZERO);
    }

    public BigQuaternion(String string) throws NumberFormatException {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            this.re = BigRational.ZERO;
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        int n3 = (string = string.trim()).indexOf("i") + string.indexOf("j") + string.indexOf("k");
        if (n3 == -3) {
            this.re = new BigRational(string);
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        int n4 = string.indexOf("i");
        String string2 = "";
        if (n4 > 0) {
            string2 = string.substring(0, n4);
        } else if (n4 < 0) {
            throw new NumberFormatException("BigQuaternion missing i");
        }
        String string3 = "";
        if (n4 < string.length()) {
            string = string.substring(n4 + 1, string.length());
        }
        if ((n2 = string.indexOf("j")) > 0) {
            string3 = string.substring(0, n2);
        } else if (n2 < 0) {
            throw new NumberFormatException("BigQuaternion missing j");
        }
        String string4 = "";
        if (n2 < string.length()) {
            string = string.substring(n2 + 1, string.length());
        }
        if ((n = string.indexOf("k")) > 0) {
            string4 = string.substring(0, n);
        } else if (n < 0) {
            throw new NumberFormatException("BigQuaternion missing k");
        }
        String string5 = "";
        if (n < string.length()) {
            string = string.substring(n + 1, string.length());
        }
        string5 = string;
        this.re = new BigRational(string2.trim());
        this.im = new BigRational(string3.trim());
        this.jm = new BigRational(string4.trim());
        this.km = new BigRational(string5.trim());
    }

    public BigQuaternion factory() {
        return this;
    }

    @Override
    public List<BigQuaternion> generators() {
        ArrayList<BigQuaternion> arrayList = new ArrayList<BigQuaternion>(4);
        arrayList.add(this.getONE());
        arrayList.add(I);
        arrayList.add(J);
        arrayList.add(K);
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigQuaternion copy() {
        return new BigQuaternion(this.re, this.im, this.jm, this.km);
    }

    @Override
    public BigQuaternion copy(BigQuaternion bigQuaternion) {
        return new BigQuaternion(bigQuaternion.re, bigQuaternion.im, bigQuaternion.jm, bigQuaternion.km);
    }

    @Override
    public BigQuaternion getZERO() {
        return ZERO;
    }

    @Override
    public BigQuaternion getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigQuaternion fromInteger(BigInteger bigInteger) {
        return new BigQuaternion(new BigRational(bigInteger));
    }

    @Override
    public BigQuaternion fromInteger(long l) {
        return new BigQuaternion(new BigRational(l));
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public BigRational getJm() {
        return this.jm;
    }

    public BigRational getKm() {
        return this.km;
    }

    public String toString() {
        String string = "" + this.re;
        int n = this.im.compareTo(BigRational.ZERO);
        int n2 = this.jm.compareTo(BigRational.ZERO);
        int n3 = this.km.compareTo(BigRational.ZERO);
        if (this.debug) {
            logger.debug((Object)("compareTo " + this.im + " ? 0 = " + n));
            logger.debug((Object)("compareTo " + this.jm + " ? 0 = " + n2));
            logger.debug((Object)("compareTo " + this.km + " ? 0 = " + n3));
        }
        if (n == 0 && n2 == 0 && n3 == 0) {
            return string;
        }
        string = string + "i" + this.im;
        string = string + "j" + this.jm;
        string = string + "k" + this.km;
        return string;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.im.isZERO();
        boolean bl2 = this.jm.isZERO();
        boolean bl3 = this.km.isZERO();
        if (bl && bl2 && bl3) {
            if (this.re.isZERO()) {
                return "0 ";
            }
            if (!this.re.isONE()) {
                stringBuffer.append(this.re.toScript() + "*");
            }
            stringBuffer.append("oneQ ");
            return stringBuffer.toString();
        }
        if (!this.re.isZERO()) {
            if (!this.re.isONE()) {
                stringBuffer.append(this.re.toScript() + "*");
            }
            stringBuffer.append("oneQ ");
        }
        if (!bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.im.isONE()) {
                stringBuffer.append(this.im.toScript() + "*");
            }
            stringBuffer.append("IQ ");
        }
        if (!bl2) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.jm.isONE()) {
                stringBuffer.append(this.jm.toScript() + "*");
            }
            stringBuffer.append("JQ ");
        }
        if (!bl3) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.km.isONE()) {
                stringBuffer.append(this.km.toScript() + "*");
            }
            stringBuffer.append("KQ ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "Quat()";
    }

    public static boolean isQZERO(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return false;
        }
        return bigQuaternion.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ZERO) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    public static boolean isQONE(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return false;
        }
        return bigQuaternion.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.equals(BigRational.ONE) && this.im.equals(BigRational.ZERO) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    public boolean isIMAG() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ONE) && this.jm.equals(BigRational.ZERO) && this.km.equals(BigRational.ZERO);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigQuaternion)) {
            return false;
        }
        BigQuaternion bigQuaternion = (BigQuaternion)object;
        return this.re.equals(bigQuaternion.re) && this.im.equals(bigQuaternion.im) && this.jm.equals(bigQuaternion.jm) && this.km.equals(bigQuaternion.km);
    }

    @Override
    public int hashCode() {
        int n = 37 * this.re.hashCode();
        n += 37 * this.im.hashCode();
        n += 37 * this.jm.hashCode();
        return n += 37 * this.km.hashCode();
    }

    @Override
    public int compareTo(BigQuaternion bigQuaternion) {
        int n = this.re.compareTo(bigQuaternion.re);
        if (n != 0) {
            return n;
        }
        n = this.im.compareTo(bigQuaternion.im);
        if (n != 0) {
            return n;
        }
        n = this.jm.compareTo(bigQuaternion.jm);
        if (n != 0) {
            return n;
        }
        return this.km.compareTo(bigQuaternion.km);
    }

    @Override
    public int signum() {
        int n = this.re.signum();
        if (n != 0) {
            return n;
        }
        n = this.im.signum();
        if (n != 0) {
            return n;
        }
        n = this.jm.signum();
        if (n != 0) {
            return n;
        }
        return this.km.signum();
    }

    @Override
    public BigQuaternion sum(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.re.sum(bigQuaternion.re), this.im.sum(bigQuaternion.im), this.jm.sum(bigQuaternion.jm), this.km.sum(bigQuaternion.km));
    }

    public static BigQuaternion QSUM(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.sum(bigQuaternion2);
    }

    public static BigQuaternion QDIF(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.subtract(bigQuaternion2);
    }

    @Override
    public BigQuaternion subtract(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.re.subtract(bigQuaternion.re), this.im.subtract(bigQuaternion.im), this.jm.subtract(bigQuaternion.jm), this.km.subtract(bigQuaternion.km));
    }

    public static BigQuaternion QNEG(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.negate();
    }

    @Override
    public BigQuaternion negate() {
        return new BigQuaternion(this.re.negate(), this.im.negate(), this.jm.negate(), this.km.negate());
    }

    public static BigQuaternion QCON(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.conjugate();
    }

    @Override
    public BigQuaternion conjugate() {
        return new BigQuaternion(this.re, this.im.negate(), this.jm.negate(), this.km.negate());
    }

    @Override
    public BigQuaternion norm() {
        BigRational bigRational = this.re.multiply(this.re);
        bigRational = bigRational.sum(this.im.multiply(this.im));
        bigRational = bigRational.sum(this.jm.multiply(this.jm));
        bigRational = bigRational.sum(this.km.multiply(this.km));
        return new BigQuaternion(bigRational);
    }

    @Override
    public BigQuaternion abs() {
        BigQuaternion bigQuaternion = this.norm();
        logger.error((Object)"abs() square root missing");
        return bigQuaternion;
    }

    public static BigRational QABS(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.abs().re;
    }

    public static BigQuaternion QPROD(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.multiply(bigQuaternion2);
    }

    @Override
    public BigQuaternion multiply(BigQuaternion bigQuaternion) {
        BigRational bigRational = this.re.multiply(bigQuaternion.re);
        bigRational = bigRational.subtract(this.im.multiply(bigQuaternion.im));
        bigRational = bigRational.subtract(this.jm.multiply(bigQuaternion.jm));
        bigRational = bigRational.subtract(this.km.multiply(bigQuaternion.km));
        BigRational bigRational2 = this.re.multiply(bigQuaternion.im);
        bigRational2 = bigRational2.sum(this.im.multiply(bigQuaternion.re));
        bigRational2 = bigRational2.sum(this.jm.multiply(bigQuaternion.km));
        bigRational2 = bigRational2.subtract(this.km.multiply(bigQuaternion.jm));
        BigRational bigRational3 = this.re.multiply(bigQuaternion.jm);
        bigRational3 = bigRational3.subtract(this.im.multiply(bigQuaternion.km));
        bigRational3 = bigRational3.sum(this.jm.multiply(bigQuaternion.re));
        bigRational3 = bigRational3.sum(this.km.multiply(bigQuaternion.im));
        BigRational bigRational4 = this.re.multiply(bigQuaternion.km);
        bigRational4 = bigRational4.sum(this.im.multiply(bigQuaternion.jm));
        bigRational4 = bigRational4.subtract(this.jm.multiply(bigQuaternion.im));
        bigRational4 = bigRational4.sum(this.km.multiply(bigQuaternion.re));
        return new BigQuaternion(bigRational, bigRational2, bigRational3, bigRational4);
    }

    public static BigQuaternion QINV(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.inverse();
    }

    @Override
    public BigQuaternion inverse() {
        BigRational bigRational = this.norm().re.inverse();
        return new BigQuaternion(this.re.multiply(bigRational), this.im.multiply(bigRational.negate()), this.jm.multiply(bigRational.negate()), this.km.multiply(bigRational.negate()));
    }

    @Override
    public BigQuaternion remainder(BigQuaternion bigQuaternion) {
        if (bigQuaternion.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigQuaternion QQ(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.divide(bigQuaternion2);
    }

    @Override
    public BigQuaternion divide(BigQuaternion bigQuaternion) {
        return this.multiply(bigQuaternion.inverse());
    }

    @Override
    public BigQuaternion divide(BigRational bigRational) {
        BigRational bigRational2 = bigRational.inverse();
        return new BigQuaternion(this.re.multiply(bigRational2), this.im.multiply(bigRational2), this.jm.multiply(bigRational2), this.km.multiply(bigRational2));
    }

    public BigQuaternion[] quotientRemainder(BigQuaternion bigQuaternion) {
        return new BigQuaternion[]{this.divide(bigQuaternion), ZERO};
    }

    @Override
    public BigQuaternion random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigQuaternion random(int n, Random random) {
        BigRational bigRational = BigRational.ONE.random(n, random);
        BigRational bigRational2 = BigRational.ONE.random(n, random);
        BigRational bigRational3 = BigRational.ONE.random(n, random);
        BigRational bigRational4 = BigRational.ONE.random(n, random);
        return new BigQuaternion(bigRational, bigRational2, bigRational3, bigRational4);
    }

    public static BigQuaternion QRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigQuaternion parse(String string) {
        return new BigQuaternion(string);
    }

    @Override
    public BigQuaternion parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigQuaternion gcd(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigQuaternion;
        }
        return ONE;
    }

    public BigQuaternion[] egcd(BigQuaternion bigQuaternion) {
        BigQuaternion[] bigQuaternionArray = new BigQuaternion[]{null, null, null};
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            bigQuaternionArray[0] = this;
            return bigQuaternionArray;
        }
        if (this.isZERO()) {
            bigQuaternionArray[0] = bigQuaternion;
            return bigQuaternionArray;
        }
        BigQuaternion bigQuaternion2 = new BigQuaternion(new BigRational(1L, 2L));
        bigQuaternionArray[0] = ONE;
        bigQuaternionArray[1] = this.inverse().multiply(bigQuaternion2);
        bigQuaternionArray[2] = bigQuaternion.inverse().multiply(bigQuaternion2);
        return bigQuaternionArray;
    }
}

