/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.Timer;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.ExactDoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import cern.jet.stat.quantile.Utils;

class QuantileFinderTest {
    QuantileFinderTest() {
    }

    protected static IntArrayList binaryMultiSearch(DoubleArrayList doubleArrayList, double d) {
        int n;
        int n2;
        int n3 = doubleArrayList.binarySearch(d);
        if (n3 < 0) {
            return null;
        }
        for (n2 = n3 - 1; n2 >= 0 && doubleArrayList.get(n2) == d; --n2) {
        }
        ++n2;
        for (n = n3 + 1; n < doubleArrayList.size() && doubleArrayList.get(n) == d; ++n) {
        }
        return new IntArrayList(new int[]{n2, --n});
    }

    public static double epsilon(int n, double d, double d2) {
        double d3 = n;
        return Math.abs(d2 / d3 - d);
    }

    public static double epsilon(DoubleArrayList doubleArrayList, double d, double d2) {
        double d3 = Descriptive.rankInterpolated(doubleArrayList, d2);
        return QuantileFinderTest.epsilon(doubleArrayList.size(), d, d3);
    }

    public static double epsilon(DoubleArrayList doubleArrayList, DoubleQuantileFinder doubleQuantileFinder, double d) {
        double d2 = doubleQuantileFinder.quantileElements(new DoubleArrayList(new double[]{d})).get(0);
        return QuantileFinderTest.epsilon(doubleArrayList, d, d2);
    }

    public static void main(String[] stringArray) {
        QuantileFinderTest.testBestBandKCalculation(stringArray);
    }

    public static double observedEpsilonAtPhi(double d, ExactDoubleQuantileFinder exactDoubleQuantileFinder, DoubleQuantileFinder doubleQuantileFinder) {
        int n = (int)exactDoubleQuantileFinder.size();
        int n2 = (int)Utils.epsilonCeiling(d * (double)n) - 1;
        exactDoubleQuantileFinder.quantileElements(new DoubleArrayList(new double[]{d})).get(0);
        double d2 = doubleQuantileFinder.quantileElements(new DoubleArrayList(new double[]{d})).get(0);
        IntArrayList intArrayList = QuantileFinderTest.binaryMultiSearch(exactDoubleQuantileFinder.buffer, d2);
        int n3 = intArrayList.get(0);
        int n4 = intArrayList.get(1);
        int n5 = n3 <= n2 && n2 <= n4 ? 0 : (n3 > n2 ? Math.abs(n3 - n2) : Math.abs(n2 - n4));
        double d3 = (double)n5 / (double)n;
        return d3;
    }

    public static DoubleArrayList observedEpsilonsAtPhis(DoubleArrayList doubleArrayList, ExactDoubleQuantileFinder exactDoubleQuantileFinder, DoubleQuantileFinder doubleQuantileFinder, double d) {
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(doubleArrayList.size());
        int n = doubleArrayList.size();
        while (--n >= 0) {
            double d2 = QuantileFinderTest.observedEpsilonAtPhi(doubleArrayList.get(n), exactDoubleQuantileFinder, doubleQuantileFinder);
            doubleArrayList2.add(d2);
            if (!(d2 > d)) continue;
            System.out.println("Real epsilon = " + d2 + " is larger than desired by " + (d2 - d));
        }
        return doubleArrayList2;
    }

    public static void test() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String[] stringArray = new String[20];
        stringArray[0] = string11 = "10000";
        stringArray[1] = string10 = "12";
        stringArray[2] = string9 = "2290";
        stringArray[3] = string8 = "log";
        stringArray[4] = string7 = "10";
        stringArray[5] = string6 = "exact";
        stringArray[6] = string5 = "shuffle";
        stringArray[7] = string4 = "0.001";
        stringArray[8] = string3 = "0.0001";
        stringArray[9] = string2 = "1";
        stringArray[10] = string = "-1";
        QuantileFinderTest.testQuantileCalculation(stringArray);
    }

    public static void testBestBandKCalculation(String[] stringArray) {
        int[] nArray = new int[]{100, 10000};
        long[] lArray = new long[]{Long.MAX_VALUE, 1000000L, 10000000L, 100000000L};
        double[] dArray = new double[]{0.0, 0.1, 1.0E-5};
        double[] dArray2 = new double[]{0.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6};
        System.out.println("\n\n");
        System.out.println("mem [Math.round(elements/1000.0)]");
        System.out.println("***********************************");
        Timer timer = new Timer().start();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            System.out.println("------------------------------");
            System.out.println("computing for p = " + n);
            for (int j = 0; j < lArray.length; ++j) {
                long l = lArray[j];
                System.out.println("   ------------------------------");
                System.out.println("   computing for N = " + l);
                for (int k = 0; k < dArray2.length; ++k) {
                    double d = dArray2[k];
                    System.out.println("      ------------------------------");
                    System.out.println("      computing for e = " + d);
                    for (int i2 = 0; i2 < dArray.length; ++i2) {
                        double d2 = dArray[i2];
                        for (int i3 = 0; i3 < 2; ++i3) {
                            boolean bl = i3 == 0;
                            DoubleQuantileFinder doubleQuantileFinder = QuantileFinderFactory.newDoubleQuantileFinder(bl, l, d, d2, n, null);
                            String string = bl ? "  known" : "unknown";
                            long l2 = doubleQuantileFinder.totalMemory();
                            if (l2 == 0L) {
                                l2 = l;
                            }
                            System.out.print("         (known, d)=(" + string + ", " + d2 + ") --> ");
                            System.out.print("(MB,mem");
                            System.out.print(")=(" + (double)l2 * 8.0 / 1024.0 / 1024.0 + ",  " + (double)l2 / 1000.0 + ",  " + Math.round((double)l2 * 8.0 / 1024.0 / 1024.0));
                            System.out.println(")");
                        }
                    }
                }
            }
        }
        timer.stop().display();
    }

    public static void testLocalVarDeclarationSpeed(int n) {
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
        Timer timer = new Timer().start();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Object var2_3 = null;
                int n2 = 10;
                double d = 1.0;
            }
        }
        System.out.println(timer.stop());
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
    }

    public static void testQuantileCalculation(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[4]);
        boolean bl = stringArray[5].equals("exact");
        boolean bl2 = stringArray[6].equals("shuffle");
        double d = new Double(stringArray[7]);
        double d2 = new Double(stringArray[8]);
        int n5 = Integer.parseInt(stringArray[9]);
        long l = Long.parseLong(stringArray[10]);
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
        double[] dArray = new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999, 1.0};
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        DoubleQuantileFinder doubleQuantileFinder = QuantileFinderFactory.newDoubleQuantileFinder(false, l, d, d2, n5, null);
        System.out.println(doubleQuantileFinder);
        DoubleQuantileFinder doubleQuantileFinder2 = QuantileFinderFactory.newDoubleQuantileFinder(false, -1L, 0.0, d2, n5, null);
        System.out.println(doubleQuantileFinder2);
        DoubleArrayList doubleArrayList = new DoubleArrayList(n);
        for (int i = 0; i < n4; ++i) {
            doubleArrayList.setSize(0);
            int n6 = i * n;
            timer2.start();
            for (int j = 0; j < n; ++j) {
                doubleArrayList.add(j + n6);
            }
            timer2.stop();
            if (bl2) {
                Timer timer3 = new Timer().start();
                doubleArrayList.shuffle();
                System.out.println("shuffling took ");
                timer3.stop().display();
            }
            timer.start();
            doubleQuantileFinder.addAllOf(doubleArrayList);
            timer.stop();
            if (!bl) continue;
            doubleQuantileFinder2.addAllOf(doubleArrayList);
        }
        System.out.println("list.add() took" + timer2);
        System.out.println("approxFinder.add() took" + timer);
        timer.reset().start();
        DoubleArrayList doubleArrayList2 = doubleQuantileFinder.quantileElements(new DoubleArrayList(dArray));
        timer.stop().display();
        System.out.println("Phis=" + new DoubleArrayList(dArray));
        System.out.println("ApproxQuantiles=" + doubleArrayList2);
        if (bl) {
            System.out.println("Comparing with exact quantile computation...");
            timer.reset().start();
            DoubleArrayList doubleArrayList3 = doubleQuantileFinder2.quantileElements(new DoubleArrayList(dArray));
            timer.stop().display();
            System.out.println("ExactQuantiles=" + doubleArrayList3);
            DoubleArrayList doubleArrayList4 = QuantileFinderTest.observedEpsilonsAtPhis(new DoubleArrayList(dArray), (ExactDoubleQuantileFinder)doubleQuantileFinder2, doubleQuantileFinder, d);
            System.out.println("observedEpsilons=" + doubleArrayList4);
            double d3 = 1000.0;
            System.out.println("exact phi(" + d3 + ")=" + doubleQuantileFinder2.phi(d3));
            System.out.println("apprx phi(" + d3 + ")=" + doubleQuantileFinder.phi(d3));
            System.out.println("exact elem(phi(" + d3 + "))=" + doubleQuantileFinder2.quantileElements(new DoubleArrayList(new double[]{doubleQuantileFinder2.phi(d3)})));
            System.out.println("apprx elem(phi(" + d3 + "))=" + doubleQuantileFinder.quantileElements(new DoubleArrayList(new double[]{doubleQuantileFinder.phi(d3)})));
        }
    }

    public static void testRank() {
        DoubleArrayList doubleArrayList = new DoubleArrayList(new double[]{1.0, 5.0, 5.0, 5.0, 7.0, 10.0});
    }
}

