/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.arith.BigRational;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class QuotientSolvablePolynomialQLRTest
extends TestCase {
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> a;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> b;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> c;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> d;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> e;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> f;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> x1;
    QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational> x2;
    int rl = 4;
    int kl = 1;
    int ll = 3;
    int el = 3;
    float q = 0.17f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    QLRSolvablePolynomialRing<SolvableQuotient<BigRational>, BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<SolvableQuotient<BigRational>> sring;
    GenSolvablePolynomialRing<BigRational> cring;
    SolvableQuotientRing<BigRational> qcring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)QuotientSolvablePolynomialQLRTest.suite());
    }

    public QuotientSolvablePolynomialQLRTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotientSolvablePolynomialQLRTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        this.cring.addRelations(weylRelations);
        this.qcring = new SolvableQuotientRing<BigRational>(this.cring);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.tord, this.vars);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        QuotientSolvablePolynomialQLRTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational>(this.ring);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            QuotientSolvablePolynomialQLRTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative: ", (boolean)this.ring.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.ring.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            QuotientSolvablePolynomialQLRTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuotientSolvablePolynomialQLRTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotientSolvablePolynomialQLRTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl + 1, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableQuotient<BigRational>)((Object)this.a));
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.a));
        this.c = (QLRSolvablePolynomial)this.b.subtract((SolvableQuotient<BigRational>)((Object)this.a));
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableQuotient<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.b));
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.c.subtract((SolvableQuotient<BigRational>)((Object)this.b));
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.b.sum((SolvableQuotient<BigRational>)((Object)this.c))));
        this.e = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.b)).sum(this.c);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        Element element = this.qcring.random(this.kl);
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)element, expVector);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableQuotient<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableQuotient<BigRational>)element, expVector);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableQuotient<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableQuotient<BigRational>)element, expVector);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableQuotient<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableQuotient<BigRational>)element, expVector);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.b = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.b.multiply((SolvableQuotient<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b));
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b.multiply((SolvableQuotient<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b)).multiply(this.c);
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MonoidElem monoidElem = ((SolvableQuotient)this.a.leadingBaseCoefficient()).inverse();
        this.d = this.a.multiply((SolvableQuotient<BigRational>)monoidElem);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((SolvableQuotient)this.d.leadingBaseCoefficient()).isONE());
        this.d = (QLRSolvablePolynomial)this.a.monic();
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a.monic(): ", (boolean)((SolvableQuotient)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testCommutative() {
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        this.qcring = new SolvableQuotientRing<BigRational>(this.cring);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.ring);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableQuotient<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b));
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"b*a == a*b: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((SolvableQuotient<BigRational>)((Object)((QLRSolvablePolynomial)this.b.sum((SolvableQuotient<BigRational>)((Object)this.c)))));
        this.e = (QLRSolvablePolynomial)this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b)).sum(this.a.multiply((SolvableQuotient<BigRational>)((Object)this.c)));
        QuotientSolvablePolynomialQLRTest.assertEquals((String)"a*(b+c) = a*b+a*c", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        SolvableQuotientRing<BigRational> solvableQuotientRing = new SolvableQuotientRing<BigRational>(genSolvablePolynomialRing);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)solvableQuotientRing.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)solvableQuotientRing.isAssociative());
        this.ring = new QLRSolvablePolynomialRing(solvableQuotientRing, this.ring);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        QuotientSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.polCoeff.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.polCoeff.parse("b x + a");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial2);
        QuotientSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial2 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial2;
            this.a = new QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial3 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3;
                this.b = new QLRSolvablePolynomial<SolvableQuotient<BigRational>, BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b));
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                QuotientSolvablePolynomialQLRTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.parse("x^2 + a b");
        this.b = this.ring.parse("a b + a");
        this.b = (QLRSolvablePolynomial)this.b.inverse();
        this.c = this.b.multiply((SolvableQuotient<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableQuotient<BigRational>)((Object)this.b));
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = (QLRSolvablePolynomial)this.b.inverse();
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"b*b^-1 == 1", (boolean)this.e.multiply((SolvableQuotient<BigRational>)((Object)this.b)).isONE());
        this.c = this.e.multiply((SolvableQuotient<BigRational>)((Object)this.c));
        this.d = this.d.multiply((SolvableQuotient<BigRational>)((Object)this.e));
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a == b * 1/b * a", (boolean)this.a.equals(this.c));
        QuotientSolvablePolynomialQLRTest.assertTrue((String)"a == a * 1/b * b", (boolean)this.a.equals(this.d));
    }
}

