/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ElementaryIntegrationTest
extends TestCase {
    TermOrder tord;
    QuotientRing<BigRational> qfac;
    GenPolynomialRing<BigRational> mfac;
    ElementaryIntegration<BigRational> integrator;
    QuotIntegral<BigRational> rint;
    Quotient<BigRational> a;
    Quotient<BigRational> b;
    Quotient<BigRational> c;
    Quotient<BigRational> d;
    Quotient<BigRational> e;
    int rl = 1;
    int kl = 5;
    int ll = 3;
    int el = 4;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ElementaryIntegrationTest.suite());
    }

    public ElementaryIntegrationTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ElementaryIntegrationTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.tord = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        this.mfac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.tord, stringArray);
        this.qfac = new QuotientRing<BigRational>(this.mfac);
        this.integrator = new ElementaryIntegration<BigRational>(bigRational);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.qfac = null;
        ComputerThreads.terminate();
    }

    public void testRational() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void testPureLogarithm1() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void testPureLogarithmD() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial genPolynomial = PolyUtil.baseDeriviative(this.a.den);
            this.b = new Quotient<BigRational>(this.qfac, genPolynomial, this.a.den);
            this.rint = this.integrator.integrate(this.b);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void testRationalWithLogarithmD() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            GenPolynomial genPolynomial = PolyUtil.baseDeriviative(this.a.den);
            this.c = new Quotient<BigRational>(this.qfac, genPolynomial, this.a.den);
            this.e = this.b.sum(this.c);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void xtestRationalWithLogarithm1() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            this.d = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.e = this.b.sum(this.d);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void testRationalWithLogarithm() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl, this.ll + i, this.el + i, this.q);
            this.b = this.integrator.deriviative(this.a);
            GenPolynomial genPolynomial = PolyUtil.baseDeriviative(this.a.den);
            this.c = new Quotient<BigRational>(this.qfac, genPolynomial, this.a.den);
            this.d = new Quotient<BigRational>(this.qfac, ((Quotient)this.qfac.getONE()).num, this.a.den);
            this.e = this.b.sum(this.c).sum(this.d);
            this.rint = this.integrator.integrate(this.e);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
        }
    }

    public void testRationalRecursive() {
        String[] stringArray = new String[]{"y"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(this.qfac, 1, this.tord, stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegration<BigRational> elementaryIntegration = new ElementaryIntegration<BigRational>(this.qfac);
        for (int i = 0; i < 2; ++i) {
            Quotient<BigRational> quotient = quotientRing.random(2, this.ll, this.el, this.q);
            Quotient<BigRational> quotient2 = elementaryIntegration.deriviative(quotient);
            QuotIntegral<BigRational> quotIntegral = elementaryIntegration.integrate(quotient2);
            ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)elementaryIntegration.isIntegral(quotIntegral));
        }
    }

    public void testMixedRational() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        Element element = genPolynomialRing.parse("(3*x^16-19*x^15+43*x^14-20*x^13-91*x^12+183*x^11-81*x^10-166*x^9+271*x^8-101*x^7-127*x^6+168*x^5-53*x^4-31*x^3+41*x^2-2*x-2)");
        Element element2 = genPolynomialRing.parse("(4*x^14-20*x^13+28*x^12+24*x^11-108*x^10+84*x^9+76*x^8-176*x^7+76*x^6+84*x^5-108*x^4+24*x^3+28*x^2-20*x+4)");
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        QuotIntegral<BigRational> quotIntegral = this.integrator.integrate(quotient);
        ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(quotIntegral));
        Element element3 = quotientRing.parse("{ 3*x^16-19*x^15+43*x^14-20*x^13-91*x^12+183*x^11-81*x^10-166*x^9+271*x^8-101*x^7-127*x^6+168*x^5-53*x^4-31*x^3+41*x^2-2*x-2 | 4*x^14-20*x^13+28*x^12+24*x^11-108*x^10+84*x^9+76*x^8-176*x^7+76*x^6+84*x^5-108*x^4+24*x^3+28*x^2-20*x+4 }");
        ElementaryIntegrationTest.assertEquals((String)"a == b: ", quotient, (Object)element3);
        quotIntegral = this.integrator.integrate((Quotient<BigRational>)element3);
        ElementaryIntegrationTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(quotIntegral));
    }
}

