/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;

class AnyToComplex<C extends GcdRingElem<C>>
implements UnaryFunctor<C, Complex<C>> {
    protected final ComplexRing<C> cfac;

    public AnyToComplex(ComplexRing<C> complexRing) {
        if (complexRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = complexRing;
    }

    public AnyToComplex(RingFactory<C> ringFactory) {
        this(new ComplexRing<C>(ringFactory));
    }

    @Override
    public Complex<C> eval(C c) {
        if (c == null || c.isZERO()) {
            return this.cfac.getZERO();
        }
        if (c.isONE()) {
            return this.cfac.getONE();
        }
        return new Complex<C>(this.cfac, c);
    }
}

