/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PolyGBUtil {
    private static final Logger logger = Logger.getLogger(PolyGBUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> boolean isResultant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        if (genPolynomial3 == null || genPolynomial3.isZERO()) {
            return true;
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomial3.ring.coFac);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genPolynomial);
        arrayList.add(genPolynomial2);
        List list = groebnerBaseAbstract.GB(arrayList);
        GenPolynomial genPolynomial4 = groebnerBaseAbstract.red.normalform(list, genPolynomial3);
        return genPolynomial4.isZERO();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topPseudoRemainder(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return genPolynomial.monic();
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 1) {
            GenPolynomial<C> genPolynomial2 = PolyUtil.baseSparsePseudoRemainder(genPolynomial, list.get(0));
            return genPolynomial2.monic();
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial<C> genPolynomial3 = list.get(0);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
        GenPolynomial genPolynomial5 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        if (genPolynomial4.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial6 = genPolynomial4.degree(0) > 0L ? PolyUtil.recursiveSparsePseudoRemainder(genPolynomial5, genPolynomial4) : genPolynomial5;
        if (genPolynomial6.degree(0) > 0L) {
            GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
            return genPolynomial7.monic();
        }
        List<GenPolynomial<C>> list2 = PolyGBUtil.zeroDegrees(list);
        GenPolynomial genPolynomial8 = PolyGBUtil.topPseudoRemainder(list2, genPolynomial6.leadingBaseCoefficient());
        genPolynomial8 = genPolynomial8.extend(genPolynomialRing, 0, 0L);
        return genPolynomial8.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topCoefficientPseudoRemainder(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return genPolynomial.monic();
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        if (genPolynomialRing2.nvar <= 1) {
            GenPolynomial<C> genPolynomial2 = list.get(0);
            GenPolynomialRing genPolynomialRing3 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
            GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
            GenPolynomial genPolynomial4 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial3, genPolynomial2);
            GenPolynomial genPolynomial5 = PolyUtil.distribute(genPolynomialRing, genPolynomial4);
            return genPolynomial5.monic();
        }
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing2.recursive(1);
        int n = genPolynomialRing.nvar - genPolynomialRing2.nvar;
        GenPolynomialRing genPolynomialRing5 = genPolynomialRing.recursive(1 + n);
        GenPolynomialRing genPolynomialRing6 = genPolynomialRing5.recursive(n);
        if (debug) {
            logger.info((Object)("rfac =" + genPolynomialRing5));
        }
        GenPolynomial genPolynomial6 = PolyUtil.recursive(genPolynomialRing5, genPolynomial);
        GenPolynomial genPolynomial7 = PolyUtil.recursive(genPolynomialRing6, genPolynomial6);
        GenPolynomial<C> genPolynomial8 = list.get(0);
        GenPolynomial genPolynomial9 = PolyUtil.recursive(genPolynomialRing4, genPolynomial8);
        if (genPolynomial9.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial10 = genPolynomial9.degree(0) > 0L ? PolyGBUtil.coefficientPseudoRemainder(genPolynomial7, genPolynomial9) : genPolynomial7;
        List<GenPolynomial<C>> list2 = PolyGBUtil.zeroDegrees(list);
        GenPolynomial genPolynomial11 = PolyUtil.distribute(genPolynomialRing5, genPolynomial10);
        GenPolynomial genPolynomial12 = PolyUtil.distribute(genPolynomialRing, genPolynomial11);
        genPolynomial12 = PolyGBUtil.topCoefficientPseudoRemainder(list2, genPolynomial12);
        return genPolynomial12.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<GenPolynomial<C>>> coefficientPseudoRemainder(GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        if (genPolynomial.isZERO() || genPolynomial.isONE()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>> genPolynomial3 = genPolynomial;
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial.leadingBaseCoefficient();
        long l = genPolynomial4.degree(0);
        long l2 = genPolynomial2.degree(0);
        GenPolynomial<C> genPolynomial5 = genPolynomial2.leadingBaseCoefficient();
        GenPolynomial<GenPolynomial<C>> genPolynomial6 = ((GenPolynomial)genPolynomialRing2.getZERO()).sum(genPolynomial5);
        ExpVector expVector = genPolynomial2.leadingExpVector();
        for (long i = l; i >= l2; --i) {
            if (genPolynomial3.isZERO()) {
                return genPolynomial3;
            }
            GenPolynomial<GenPolynomial<C>> genPolynomial7 = genPolynomial3.leadingBaseCoefficient();
            ExpVector expVector2 = genPolynomial3.leadingExpVector();
            long l3 = genPolynomial7.degree(0);
            if (i == l3) {
                GenPolynomial<C> genPolynomial8 = genPolynomial7.leadingBaseCoefficient();
                ExpVector expVector3 = genPolynomial7.leadingExpVector();
                expVector3 = expVector3.subtract(expVector);
                genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial6);
                GenPolynomial<GenPolynomial<C>> genPolynomial9 = genPolynomial2.multiply(genPolynomial8, expVector3);
                GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial10 = new GenPolynomial<GenPolynomial<GenPolynomial<C>>>(genPolynomialRing, genPolynomial9, expVector2);
                genPolynomial3 = genPolynomial3.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial10);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial6);
        }
        if (genPolynomial3.degree(0) < genPolynomial.degree(0)) {
            genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial3, genPolynomial2);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoRemainderBase(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        if (genPolynomial.isZERO() || genPolynomial.isONE()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = genPolynomial;
        GenPolynomial<C> genPolynomial4 = genPolynomial.leadingBaseCoefficient();
        long l = genPolynomial4.degree(0);
        long l2 = genPolynomial2.degree(0);
        C c = genPolynomial2.leadingBaseCoefficient();
        GenPolynomial<C> genPolynomial5 = ((GenPolynomial)genPolynomialRing2.getZERO()).sum(c);
        ExpVector expVector = genPolynomial2.leadingExpVector();
        for (long i = l; i >= l2; --i) {
            if (genPolynomial3.isZERO()) {
                return genPolynomial3;
            }
            GenPolynomial<C> genPolynomial6 = genPolynomial3.leadingBaseCoefficient();
            ExpVector expVector2 = genPolynomial3.leadingExpVector();
            long l3 = genPolynomial6.degree(0);
            if (i == l3) {
                C c2 = genPolynomial6.leadingBaseCoefficient();
                ExpVector expVector3 = genPolynomial6.leadingExpVector();
                expVector3 = expVector3.subtract(expVector);
                genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial5);
                GenPolynomial<C> genPolynomial7 = genPolynomial2.multiply(c2, expVector3);
                GenPolynomial<GenPolynomial<C>> genPolynomial8 = new GenPolynomial<GenPolynomial<C>>(genPolynomialRing, genPolynomial7, expVector2);
                genPolynomial3 = genPolynomial3.subtract(genPolynomial8);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial5);
        }
        if (genPolynomial3.degree(0) < genPolynomial.degree(0)) {
            genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial3, genPolynomial2);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> zeroDegrees(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
            if (genPolynomial2.degree(0) != 0L) continue;
            arrayList.add(genPolynomial2.leadingBaseCoefficient());
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> intersect(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        Iterable<Monomial<C>> iterable;
        Iterable<Monomial<C>> iterable22;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        int n = list.size() + list2.size();
        ArrayList arrayList = new ArrayList(n);
        GenPolynomialRing<C> genPolynomialRing2 = genPolynomialRing.extend(1);
        for (Iterable<Monomial<C>> iterable22 : list) {
            iterable22 = iterable22.extend(genPolynomialRing2, 0, 1L);
            arrayList.add(iterable22);
        }
        for (Iterable<Monomial<C>> iterable22 : list2) {
            iterable = iterable22.extend(genPolynomialRing2, 0, 1L);
            GenPolynomial<GenPolynomial<C>> genPolynomial = iterable22.extend(genPolynomialRing2, 0, 0L);
            iterable22 = genPolynomial.subtract((GenPolynomial<C>)iterable);
            arrayList.add(iterable22);
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing2.coFac);
        logger.warn((Object)"intersect computing GB");
        iterable22 = groebnerBaseAbstract.GB(arrayList);
        if (debug) {
            logger.debug((Object)("intersect GB = " + iterable22));
        }
        iterable = PolyUtil.intersect(genPolynomialRing, iterable22);
        return iterable;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<C>> intersect(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2) {
        Iterable iterable;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        int n = list.size() + list2.size();
        ArrayList arrayList = new ArrayList(n);
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.extend(1);
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            GenSolvablePolynomial iterable22 = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 1L);
            arrayList.add(iterable22);
        }
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
            iterable = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 1L);
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 0L);
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial2.subtract(iterable);
            arrayList.add(genSolvablePolynomial3);
        }
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.warn((Object)"intersect computing GB");
        List list3 = solvableGroebnerBaseSeq.leftGB(arrayList);
        if (debug) {
            logger.debug((Object)("intersect GB = " + list3));
        }
        iterable = PolyUtil.intersect(genSolvablePolynomialRing, list3);
        return iterable;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzLcm(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isONE()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(1);
        arrayList.add(genSolvablePolynomial);
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(1);
        arrayList2.add(genSolvablePolynomial2);
        List<GenSolvablePolynomial<C>> list = PolyGBUtil.intersect(genSolvablePolynomialRing, arrayList, arrayList2);
        GenSolvablePolynomial<C> genSolvablePolynomial3 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial4 : list) {
            if (genSolvablePolynomial4 == null || genSolvablePolynomial4.isZERO()) continue;
            if (genSolvablePolynomial3 == null) {
                genSolvablePolynomial3 = genSolvablePolynomial4;
                continue;
            }
            if (genSolvablePolynomial3.compareTo(genSolvablePolynomial4) <= 0) continue;
            genSolvablePolynomial3 = genSolvablePolynomial4;
        }
        if (genSolvablePolynomial3 == null) {
            throw new RuntimeException("this cannot happen: lcm == null: " + list);
        }
        return genSolvablePolynomial3;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzGcd(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial.totalDegree() > 3L || genSolvablePolynomial2.totalDegree() > 3L) {
            logger.warn((Object)("skipping GB computation: degs = " + genSolvablePolynomial.totalDegree() + ", " + genSolvablePolynomial2.totalDegree()));
            return genSolvablePolynomialRing.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.warn((Object)("syzGcd computing GB: " + arrayList));
        List list = solvableGroebnerBaseSeq.rightGB(arrayList);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("G = " + list));
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.warn((Object)("gcd not determined, set to 1: " + list));
        return genSolvablePolynomialRing.getONE();
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] quotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial2.isZERO()) {
            throw new RuntimeException("division by zero: " + genSolvablePolynomial + "/" + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial;
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getZERO();
            return genSolvablePolynomialArray;
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genSolvablePolynomialRing.getZERO());
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(genSolvablePolynomial2);
        SolvableReductionSeq solvableReductionSeq = new SolvableReductionSeq();
        genSolvablePolynomialArray[1] = solvableReductionSeq.rightNormalform(arrayList, arrayList2, genSolvablePolynomial);
        genSolvablePolynomialArray[0] = (GenSolvablePolynomial)arrayList.get(0);
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] syzGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{PolyGBUtil.syzGcd(genSolvablePolynomialRing, genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray[0].isONE()) {
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = PolyGBUtil.quotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray2[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = PolyGBUtil.quotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        genSolvablePolynomialArray[1] = genSolvablePolynomialArray2[0];
        genSolvablePolynomialArray[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzLcm(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(1);
        arrayList.add(genPolynomial);
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(1);
        arrayList2.add(genPolynomial2);
        List<GenPolynomial<C>> list = PolyGBUtil.intersect(genPolynomialRing, arrayList, arrayList2);
        if (list.size() != 1) {
            logger.warn((Object)("lcm not uniqe: " + list));
        }
        GenPolynomial<C> genPolynomial3 = list.get(0);
        return genPolynomial3;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzGcd(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial.isONE()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial2;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = genPolynomial.multiply(genPolynomial2);
        GenPolynomial<C> genPolynomial4 = PolyGBUtil.syzLcm(genPolynomialRing, genPolynomial, genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial4);
        return genPolynomial5;
    }
}

