/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseDistributed;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.JunitClient;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseDistTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bbseq;
    GroebnerBaseDistributed<BigRational> bbdist;
    GroebnerBaseDistributed<BigRational> bbdists;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseDistTest.suite());
    }

    public GroebnerBaseDistTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseDistTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbdists = new GroebnerBaseDistributed(this.threads, this.port);
        this.bbdist = new GroebnerBaseDistributed(this.threads, new OrderedSyzPairlist(), this.port);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbdist.terminate();
        this.bbdist = null;
        this.bbdists.terminate();
        this.bbdists = null;
        ComputerThreads.terminate();
    }

    Thread[] startThreads() {
        Thread[] threadArray = new Thread[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            threadArray[i] = new Thread(new JunitClient(this.host, this.port));
            threadArray[i].start();
        }
        return threadArray;
    }

    void stopThreads(Thread[] threadArray) {
        for (int i = 0; i < this.threads; ++i) {
            try {
                threadArray[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void testDistributedGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L.add(this.a);
        Thread[] threadArray = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.b);
        threadArray = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.c);
        threadArray = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.d);
        threadArray = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbseq.isGB(this.L));
        this.L.add(this.e);
        threadArray = this.startThreads();
        this.L = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbseq.isGB(this.L));
    }

    public void testSequentialDistributedGBase() {
        List list = null;
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> list2 = this.bbseq.GB(this.L);
        Thread[] threadArray = this.startThreads();
        list = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.b);
        list2 = this.bbseq.GB(this.L);
        threadArray = this.startThreads();
        list = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.c);
        list2 = this.bbseq.GB(this.L);
        threadArray = this.startThreads();
        list = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.d);
        list2 = this.bbseq.GB(this.L);
        threadArray = this.startThreads();
        list = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
        this.L = list2;
        this.L.add(this.e);
        list2 = this.bbseq.GB(this.L);
        threadArray = this.startThreads();
        list = this.bbdist.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)("Gs.containsAll(Gp)" + list2 + ", " + list + ", " + this.L), (boolean)list2.containsAll(list));
        GroebnerBaseDistTest.assertTrue((String)("Gp.containsAll(Gs)" + list2 + ", " + list + ", " + this.L), (boolean)list.containsAll(list2));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistTest.fail((String)("" + iOException));
        }
        Thread[] threadArray = this.startThreads();
        this.G = this.bbdist.GB(this.F.list);
        this.stopThreads(threadArray);
        GroebnerBaseDistTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

