/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class EvaluateToComplexReal<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<GenPolynomial<Complex<C>>, Complex<RealAlgebraicNumber<C>>> {
    protected final GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> pfac;
    protected final ComplexRing<RealAlgebraicNumber<C>> cfac;
    protected final Complex<RealAlgebraicNumber<C>> root;

    public EvaluateToComplexReal(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> genPolynomialRing, Complex<RealAlgebraicNumber<C>> complex) {
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        if (complex == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.pfac = genPolynomialRing;
        this.cfac = (ComplexRing)genPolynomialRing.coFac;
        this.root = complex;
    }

    @Override
    public Complex<RealAlgebraicNumber<C>> eval(GenPolynomial<Complex<C>> genPolynomial) {
        if (genPolynomial == null) {
            return this.cfac.getZERO();
        }
        GenPolynomial<Complex<RealAlgebraicNumber<C>>> genPolynomial2 = PolyUtilApp.convertToComplexRealCoefficients(this.pfac, genPolynomial);
        Complex<RealAlgebraicNumber<C>> complex = PolyUtil.evaluateMain(this.cfac, genPolynomial2, this.root);
        return complex;
    }
}

