/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class PairListTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    PairList<BigRational> pairlist;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 5;
    int ll = 2;
    int el = 4;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)PairListTest.suite());
    }

    public PairListTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PairListTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testRandomPL() {
        int n;
        this.pairlist = new OrderedPairlist<BigRational>(this.fac);
        CriticalPairList<BigRational> criticalPairList = new CriticalPairList<BigRational>(this.fac);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        for (n = 0; n < 7; ++n) {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            if (this.a.isZERO()) continue;
            this.pairlist.put(this.a);
            criticalPairList.put(this.a);
        }
        while (this.pairlist.hasNext() && criticalPairList.hasNext()) {
            Pair<BigRational> pair = this.pairlist.removeNext();
            CriticalPair<BigRational> criticalPair = criticalPairList.getNext();
            if (criticalPair != null) {
                criticalPairList.update(criticalPair, (GenPolynomial<BigRational>)this.fac.getZERO());
            } else {
                criticalPairList.update();
            }
            if (pair == null || criticalPair == null) continue;
            boolean bl = pair.i == criticalPair.i && pair.j == criticalPair.j;
            PairListTest.assertTrue((String)"pair == cpair ", (boolean)bl);
        }
        n = this.pairlist.hasNext() || criticalPairList.hasNext() ? 1 : 0;
        PairListTest.assertFalse((String)"#pairlist == #cpl ", n != 0);
    }

    public void testRandomSyzPL() {
        int n;
        this.pairlist = new OrderedPairlist<BigRational>(this.fac);
        OrderedSyzPairlist<BigRational> orderedSyzPairlist = new OrderedSyzPairlist<BigRational>(this.fac);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        for (n = 0; n < 7; ++n) {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            if (this.a.isZERO()) continue;
            this.pairlist.put(this.a);
            orderedSyzPairlist.put(this.a);
        }
        while (this.pairlist.hasNext() && orderedSyzPairlist.hasNext()) {
            Pair<BigRational> pair = this.pairlist.removeNext();
            Pair<BigRational> pair2 = orderedSyzPairlist.removeNext();
            if (pair == null || pair2 == null) continue;
            boolean bl = pair.i == pair2.i && pair.j == pair2.j;
        }
        n = this.pairlist.hasNext() && orderedSyzPairlist.hasNext() ? 1 : 0;
        PairListTest.assertFalse((String)"#pairlist == #spl ", n != 0);
    }
}

