/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RatNumer;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolyUtilTest.suite());
    }

    public PolyUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PolyUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    protected static java.math.BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 35L));
    }

    public void testConversion() {
        this.c = this.dfac.getONE();
        PolyUtilTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.cr = PolyUtil.recursive(this.rfac, this.c);
        this.a = PolyUtil.distribute(this.dfac, this.cr);
        PolyUtilTest.assertEquals((String)"c == dist(rec(c))", this.c, this.a);
        this.d = this.dfac.getZERO();
        PolyUtilTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        PolyUtilTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        PolyUtilTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        this.dr = PolyUtil.recursive(this.rfac, this.d);
        this.b = PolyUtil.distribute(this.dfac, this.dr);
        PolyUtilTest.assertEquals((String)"d == dist(rec(d))", this.d, this.b);
    }

    public void testConversionRing() {
        GenPolynomialRing<GenPolynomial<BigInteger>> genPolynomialRing = this.dfac.recursive(1);
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        PolyUtilTest.assertEquals((String)"rfac#var == rf#var ", (int)this.rfac.nvar, (int)genPolynomialRing.nvar);
        PolyUtilTest.assertEquals((String)"rfac.coFac#var == rf.coFac#var ", (int)this.cfac.nvar, (int)genPolynomialRing2.nvar);
        PolyUtilTest.assertEquals((String)"rfac.coFac.coFac == rf.coFac.coFac ", this.cfac.coFac, genPolynomialRing2.coFac);
    }

    public void testRandomConversion() {
        for (int i = 0; i < 7; ++i) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            this.cr = PolyUtil.recursive(this.rfac, this.c);
            this.a = PolyUtil.distribute(this.dfac, this.cr);
            PolyUtilTest.assertEquals((String)"c == dist(rec(c))", this.c, this.a);
        }
    }

    public void testRationalConversion() {
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        for (int i = 0; i < 3; ++i) {
            this.c = this.dfac.random(this.kl * (i + 9), this.ll * (i + 3), this.el + i, this.q).abs();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            GenPolynomial<BigRational> genPolynomial2 = genPolynomial.monic();
            this.a = PolyUtil.integerFromRationalCoefficients(this.dfac, genPolynomial2);
            PolyUtilTest.assertEquals((String)"c == integer(rational(c))", this.c, this.a);
        }
    }

    public void testModularConversion() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(PolyUtilTest.getPrime1());
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        for (int i = 0; i < 3; ++i) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll * (i + 1), this.el + i, this.q).abs();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<ModInteger> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            this.a = PolyUtil.integerFromModularCoefficients(this.dfac, genPolynomial);
            PolyUtilTest.assertEquals((String)"c == integer(modular(c))", this.c, this.a);
        }
    }

    public void testChineseRemainder() {
        java.math.BigInteger bigInteger = PolyUtilTest.getPrime1();
        java.math.BigInteger bigInteger2 = PolyUtilTest.getPrime2();
        java.math.BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        ModIntegerRing modIntegerRing2 = new ModIntegerRing(bigInteger2);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing2, this.rl, this.to);
        ModIntegerRing modIntegerRing3 = new ModIntegerRing(bigInteger3);
        GenPolynomialRing<ModInteger> genPolynomialRing3 = new GenPolynomialRing<ModInteger>(modIntegerRing3, this.rl, this.to);
        ModInteger modInteger = modIntegerRing2.create(bigInteger);
        modInteger = modInteger.inverse();
        for (int i = 0; i < 3; ++i) {
            GenPolynomial<ModInteger> genPolynomial;
            this.c = this.dfac.random(44, this.ll * (i + 1), this.el + i, this.q);
            ExpVector expVector = this.c.degreeVector();
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!this.c.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!this.c.isONE() ? 1 : 0) != 0);
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            ExpVector expVector2 = genPolynomial2.degreeVector();
            if (!expVector.equals(expVector2) || !expVector.equals(expVector2 = (genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.c)).degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.chineseRemainder(genPolynomialRing3, genPolynomial2, modInteger, genPolynomial);
            this.a = PolyUtil.integerFromModularCoefficients(this.dfac, genPolynomial3);
            PolyUtilTest.assertEquals((String)"cra(c mod p1,c mod p2) = c", this.c, this.a);
        }
    }

    public void testComplexConversion() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        BigComplex bigComplex = new BigComplex(1L);
        GenPolynomialRing<BigComplex> genPolynomialRing2 = new GenPolynomialRing<BigComplex>(bigComplex, this.rl, this.to);
        BigComplex bigComplex2 = BigComplex.I;
        for (int i = 0; i < 3; ++i) {
            GenPolynomial<BigComplex> genPolynomial = genPolynomialRing2.random(this.kl + 2 * i, this.ll * (i + 1), this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (genPolynomial.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!genPolynomial.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!genPolynomial.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> genPolynomial2 = PolyUtil.realPart(genPolynomialRing, genPolynomial);
            GenPolynomial<BigRational> genPolynomial3 = PolyUtil.imaginaryPart(genPolynomialRing, genPolynomial);
            GenPolynomial<BigComplex> genPolynomial4 = PolyUtil.complexFromRational(genPolynomialRing2, genPolynomial2);
            GenPolynomial<BigComplex> genPolynomial5 = PolyUtil.complexFromRational(genPolynomialRing2, genPolynomial3);
            GenPolynomial<GenPolynomial<BigComplex>> genPolynomial6 = genPolynomial4.sum((BigComplex)((Object)genPolynomial5.multiply(bigComplex2)));
            PolyUtilTest.assertEquals((String)"re(c)+i*im(c) = c", genPolynomial, genPolynomial6);
        }
    }

    public void testBasePseudoDivision() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        this.a = this.dfac.random(this.kl, 2 * this.ll, this.el + 17, this.q);
        this.b = this.dfac.random(this.kl, 2 * this.ll, this.el + 3, this.q);
        GenPolynomial<BigInteger>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(this.a, this.b);
        this.c = genPolynomialArray[1];
        this.d = genPolynomialArray[0];
        boolean bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.d, this.c);
        PolyUtilTest.assertTrue((String)("lc^n a = q b + r: " + this.c), (boolean)bl);
        GenPolynomial<BigRational> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
        GenPolynomial<BigRational> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
        GenPolynomial<BigRational> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
        GenPolynomial<BigRational> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
        GenPolynomial<BigRational> genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial<BigRational> genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial7 = genPolynomial5.multiply((BigRational)((Object)genPolynomial2)).sum(genPolynomial6);
        PolyUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testBasePseudoDivisionSparse() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        this.a = this.dfac.random(this.kl, 2 * this.ll, this.el + 17, this.q);
        this.b = this.dfac.random(this.kl, 2 * this.ll, this.el + 3, this.q);
        this.d = PolyUtil.basePseudoDivide(this.a, this.b);
        this.c = PolyUtil.baseSparsePseudoRemainder(this.a, this.b);
        boolean bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.d, this.c);
        PolyUtilTest.assertTrue((String)("lc^n a = q b + r: " + this.c), (boolean)bl);
        GenPolynomial<BigRational> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
        GenPolynomial<BigRational> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
        GenPolynomial<BigRational> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
        GenPolynomial<BigRational> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
        GenPolynomial<BigRational> genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial<BigRational> genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial7 = genPolynomial5.multiply((BigRational)((Object)genPolynomial2)).sum(genPolynomial6);
        PolyUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testBasePseudoDivisionDense() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        this.a = this.dfac.random(this.kl, 2 * this.ll, this.el + 17, this.q);
        this.b = this.dfac.random(this.kl, 2 * this.ll, this.el + 3, this.q);
        this.d = PolyUtil.baseDensePseudoQuotient(this.a, this.b);
        this.c = PolyUtil.baseDensePseudoRemainder(this.a, this.b);
        boolean bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.d, this.c);
        PolyUtilTest.assertTrue((String)("lc^n a = q b + r: " + this.c), (boolean)bl);
        GenPolynomial<BigRational> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
        GenPolynomial<BigRational> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
        GenPolynomial<BigRational> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
        GenPolynomial<BigRational> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
        GenPolynomial<BigRational> genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial<BigRational> genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial7 = genPolynomial5.multiply((BigRational)((Object)genPolynomial2)).sum(genPolynomial6);
        PolyUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testRecursivePseudoDivision() {
    }

    public void testEvalMainRecursive() {
        this.ai = new BigInteger().random(this.kl);
        this.ar = this.rfac.getZERO();
        this.a = PolyUtil.evaluateMainRecursive(this.cfac, this.ar, this.ai);
        PolyUtilTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        this.ar = this.rfac.getONE();
        this.a = PolyUtil.evaluateMainRecursive(this.cfac, this.ar, this.ai);
        PolyUtilTest.assertTrue((String)"isONE( a )", (boolean)this.a.isONE());
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.br.sum((GenPolynomial<BigInteger>)this.ar);
        this.a = PolyUtil.evaluateMainRecursive(this.cfac, this.ar, this.ai);
        this.b = PolyUtil.evaluateMainRecursive(this.cfac, this.br, this.ai);
        this.c = PolyUtil.evaluateMainRecursive(this.cfac, this.cr, this.ai);
        this.d = this.a.sum((BigInteger)((Object)this.b));
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", this.c, this.d);
        this.cr = this.br.multiply((GenPolynomial<BigInteger>)this.ar);
        this.a = PolyUtil.evaluateMainRecursive(this.cfac, this.ar, this.ai);
        this.b = PolyUtil.evaluateMainRecursive(this.cfac, this.br, this.ai);
        this.c = PolyUtil.evaluateMainRecursive(this.cfac, this.cr, this.ai);
        this.d = this.a.multiply((BigInteger)((Object)this.b));
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", this.c, this.d);
    }

    public void testEvalMain() {
        this.ei = new BigInteger().random(this.kl);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.a = this.cfac.getZERO();
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isZERO( ai )", (boolean)this.ai.isZERO());
        this.a = this.cfac.getONE();
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isONE( ai )", (boolean)this.ai.isONE());
        this.a = this.cfac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.cfac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        this.bi = PolyUtil.evaluateMain(this.ei, this.b, this.ei);
        this.ci = PolyUtil.evaluateMain(this.ei, this.c, this.ei);
        this.di = this.bi.sum(this.ai);
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", (Object)this.ci, (Object)this.di);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        this.ai = PolyUtil.evaluateMain(this.ei, this.a, this.ei);
        this.bi = PolyUtil.evaluateMain(this.ei, this.b, this.ei);
        this.ci = PolyUtil.evaluateMain(this.ei, this.c, this.ei);
        this.di = this.bi.multiply(this.ai);
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", (Object)this.ci, (Object)this.di);
    }

    public void testEvalFirst() {
        this.ei = new BigInteger().random(this.kl);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.a = genPolynomialRing.getZERO();
        GenPolynomial<BigInteger> genPolynomial = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isZERO( ae )", (boolean)genPolynomial.isZERO());
        this.a = genPolynomialRing.getONE();
        genPolynomial = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        PolyUtilTest.assertTrue((String)"isONE( ae )", (boolean)genPolynomial.isONE());
        this.a = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        this.b = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        genPolynomial = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        GenPolynomial<BigInteger> genPolynomial2 = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.b, this.ei);
        GenPolynomial<BigInteger> genPolynomial3 = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.c, this.ei);
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial4 = genPolynomial2.sum((BigInteger)((Object)genPolynomial));
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", genPolynomial3, genPolynomial4);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        genPolynomial = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.a, this.ei);
        genPolynomial2 = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.b, this.ei);
        genPolynomial3 = PolyUtil.evaluateFirst(this.cfac, this.dfac, this.c, this.ei);
        genPolynomial4 = genPolynomial2.multiply((BigInteger)((Object)genPolynomial));
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", genPolynomial3, genPolynomial4);
    }

    public void testEvalAll() {
        BigInteger bigInteger = new BigInteger();
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        for (int i = 0; i < this.rl; ++i) {
            this.ei = bigInteger.random(this.kl);
            arrayList.add(this.ei);
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl, this.to);
        this.a = genPolynomialRing.getZERO();
        BigInteger bigInteger2 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.a, arrayList);
        PolyUtilTest.assertTrue((String)"isZERO( ae )", (boolean)bigInteger2.isZERO());
        this.a = genPolynomialRing.getONE();
        bigInteger2 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.a, arrayList);
        PolyUtilTest.assertTrue((String)"isONE( ae )", (boolean)bigInteger2.isONE());
        this.a = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        this.b = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        bigInteger2 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.a, arrayList);
        BigInteger bigInteger3 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.b, arrayList);
        BigInteger bigInteger4 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.c, arrayList);
        BigInteger bigInteger5 = bigInteger3.sum(bigInteger2);
        PolyUtilTest.assertEquals((String)"eval(a+b) == eval(a) + eval(b)", (Object)bigInteger4, (Object)bigInteger5);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        bigInteger4 = PolyUtil.evaluateAll(bigInteger, this.dfac, this.c, arrayList);
        bigInteger5 = bigInteger3.multiply(bigInteger2);
        PolyUtilTest.assertEquals((String)"eval(a*b) == eval(a) * eval(b)", (Object)bigInteger4, (Object)bigInteger5);
    }

    public void testInterpolateUnivariateOne() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        ModInteger modInteger = modIntegerRing.fromInteger(11L);
        ModInteger modInteger2 = PolyUtil.evaluateMain(modIntegerRing, monoidElem, modInteger);
        PolyUtilTest.assertTrue((String)"isONE( ai )", (boolean)modInteger2.isONE());
        ModInteger modInteger3 = modIntegerRing.fromInteger(13L);
        ModInteger modInteger4 = PolyUtil.evaluateMain(modIntegerRing, monoidElem, modInteger3);
        PolyUtilTest.assertTrue((String)"isONE( bi )", (boolean)modInteger4.isONE());
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial2 = genPolynomialRing.getONE();
        ModInteger modInteger5 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial2, modInteger);
        ModInteger modInteger6 = modInteger5.inverse();
        genPolynomial = PolyUtil.interpolate(genPolynomialRing, genPolynomial, genPolynomial2, modInteger6, modInteger2, modInteger);
        GenPolynomial<RingElem<ModInteger>> genPolynomial3 = genPolynomialRing.univariate(0);
        genPolynomial3 = genPolynomial3.subtract((ModInteger)((Object)((GenPolynomial)genPolynomialRing.getONE()).multiply(modInteger)));
        genPolynomial2 = genPolynomial2.multiply((GenPolynomial<ModInteger>)genPolynomial3);
        modInteger5 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial2, modInteger3);
        modInteger6 = modInteger5.inverse();
        genPolynomial = PolyUtil.interpolate(genPolynomialRing, genPolynomial, genPolynomial2, modInteger6, modInteger4, modInteger3);
        ModInteger modInteger7 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial, modInteger);
        ModInteger modInteger8 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial, modInteger3);
        PolyUtilTest.assertTrue((String)"gi == 1 ", (boolean)modInteger7.isONE());
        PolyUtilTest.assertTrue((String)"hi == 1 ", (boolean)modInteger8.isONE());
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-ei),a mod (x-di)) = a (mod 19)", (Object)monoidElem, genPolynomial);
    }

    public void testInterpolateUnivariate() {
        long l;
        GenPolynomial<ModInteger> genPolynomial;
        long l2 = PolyUtilTest.getPrime1().longValue();
        ModIntegerRing modIntegerRing = new ModIntegerRing(l2);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        int n = 19;
        long l3 = 0L;
        do {
            if ((genPolynomial = genPolynomialRing.random(this.kl, this.ll, n, this.q)).isZERO()) continue;
            l3 = genPolynomial.degree(0);
        } while (l3 <= 0L);
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial3 = genPolynomialRing.getONE();
        long l4 = -1L;
        do {
            if (++l4 >= l2) {
                PolyUtilTest.assertTrue((String)"elements of Z_prime exhausted", (l4 < l2 ? 1 : 0) != 0);
            }
            l = genPolynomial3.degree(0);
            ModInteger modInteger = modIntegerRing.fromInteger(l4);
            ModInteger modInteger2 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial, modInteger);
            ModInteger modInteger3 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial3, modInteger);
            ModInteger modInteger4 = modInteger3.inverse();
            genPolynomial2 = PolyUtil.interpolate(genPolynomialRing, genPolynomial2, genPolynomial3, modInteger4, modInteger2, modInteger);
            GenPolynomial<RingElem<ModInteger>> genPolynomial4 = genPolynomialRing.univariate(0);
            genPolynomial4 = genPolynomial4.subtract((ModInteger)((Object)((GenPolynomial)genPolynomialRing.getONE()).multiply(modInteger)));
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<ModInteger>)genPolynomial4);
        } while (l < l3);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", genPolynomial, genPolynomial2);
    }

    public void testInterpolateMultivariate() {
        long l;
        GenPolynomial<ModInteger> genPolynomial;
        long l2 = PolyUtilTest.getPrime1().longValue();
        ModIntegerRing modIntegerRing = new ModIntegerRing(l2);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(genPolynomialRing, this.rl, this.to);
        GenPolynomialRing<ModInteger> genPolynomialRing3 = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        int n = 19;
        long l3 = 0L;
        do {
            if ((genPolynomial = genPolynomialRing2.random(this.kl, this.ll + 9, n, this.q)).isZERO()) continue;
            l3 = PolyUtil.coeffMaxDegree(genPolynomial);
        } while (l3 <= 0L);
        ExpVector expVector = genPolynomial.degreeVector();
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing2.getZERO();
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial3 = genPolynomialRing.getONE();
        long l4 = -1L;
        do {
            if (++l4 >= l2) {
                PolyUtilTest.assertTrue((String)"elements of Z_prime exhausted", (l4 < l2 ? 1 : 0) != 0);
            }
            l = genPolynomial3.degree(0);
            ModInteger modInteger = modIntegerRing.fromInteger(l4);
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.evaluateFirstRec(genPolynomialRing, genPolynomialRing3, genPolynomial, modInteger);
            ExpVector expVector2 = genPolynomial4.degreeVector();
            if (!expVector.equals(expVector2)) continue;
            ModInteger modInteger2 = PolyUtil.evaluateMain(modIntegerRing, genPolynomial3, modInteger);
            ModInteger modInteger3 = modInteger2.inverse();
            genPolynomial2 = PolyUtil.interpolate(genPolynomialRing2, genPolynomial2, genPolynomial3, modInteger3, genPolynomial4, modInteger);
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.evaluateFirstRec(genPolynomialRing, genPolynomialRing3, genPolynomial2, modInteger);
            PolyUtilTest.assertEquals((String)"interpolate(a)(ei) == a ", genPolynomial5, genPolynomial4);
            GenPolynomial<RingElem<ModInteger>> genPolynomial6 = genPolynomialRing.univariate(0);
            genPolynomial6 = genPolynomial6.subtract((ModInteger)((Object)((GenPolynomial)genPolynomialRing.getONE()).multiply(modInteger)));
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<ModInteger>)genPolynomial6);
        } while (l <= l3);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", genPolynomial, (Object)genPolynomial2);
    }

    public void testInterpolateRationalMultivariate() {
        long l;
        GenPolynomial<BigRational> genPolynomial;
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, this.to);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, this.rl, this.to);
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        int n = 19;
        long l2 = 0L;
        do {
            if ((genPolynomial = genPolynomialRing2.random(this.kl, this.ll + 9, n, this.q)).isZERO()) continue;
            l2 = PolyUtil.coeffMaxDegree(genPolynomial);
        } while (l2 <= 0L);
        ExpVector expVector = genPolynomial.degreeVector();
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.getZERO();
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial3 = genPolynomialRing.getONE();
        long l3 = -1L;
        do {
            BigRational bigRational2;
            GenPolynomial<BigRational> genPolynomial4;
            ExpVector expVector2;
            l = genPolynomial3.degree(0);
            if (!expVector.equals(expVector2 = (genPolynomial4 = PolyUtil.evaluateFirstRec(genPolynomialRing, genPolynomialRing3, genPolynomial, bigRational2 = bigRational.fromInteger(++l3))).degreeVector())) continue;
            BigRational bigRational3 = PolyUtil.evaluateMain(bigRational, genPolynomial3, bigRational2);
            BigRational bigRational4 = bigRational3.inverse();
            genPolynomial2 = PolyUtil.interpolate(genPolynomialRing2, genPolynomial2, genPolynomial3, bigRational4, genPolynomial4, bigRational2);
            GenPolynomial<BigRational> genPolynomial5 = PolyUtil.evaluateFirstRec(genPolynomialRing, genPolynomialRing3, genPolynomial2, bigRational2);
            PolyUtilTest.assertEquals((String)"interpolate(a)(ei) == a ", genPolynomial5, genPolynomial4);
            GenPolynomial<RingElem<BigRational>> genPolynomial6 = genPolynomialRing.univariate(0);
            genPolynomial6 = genPolynomial6.subtract((BigRational)((Object)((GenPolynomial)genPolynomialRing.getONE()).multiply(bigRational2)));
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<BigRational>)genPolynomial6);
        } while (l <= l2);
        PolyUtilTest.assertEquals((String)"interpolate(a mod (x-e1),...,a mod (x-ei)) = a (mod 19)", genPolynomial, (Object)genPolynomial2);
    }

    public void testMap() {
        BigInteger bigInteger = new BigInteger();
        BigRational bigRational = new BigRational();
        ModIntegerRing modIntegerRing = new ModIntegerRing(17L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenPolynomialRing<ModInteger> genPolynomialRing3 = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(this.kl, 2 * this.ll, this.el, this.q).monic();
        GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing3.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial4 = PolyUtil.map(genPolynomialRing2, genPolynomial, new FromInteger<BigRational>(bigRational));
        GenPolynomial<BigInteger> genPolynomial5 = PolyUtil.map(genPolynomialRing, genPolynomial4, new RatNumer());
        PolyUtilTest.assertEquals((String)"pi == qi ", genPolynomial, genPolynomial5);
        genPolynomial5 = PolyUtil.integerFromRationalCoefficients(genPolynomialRing, genPolynomial2);
        genPolynomial4 = PolyUtil.map(genPolynomialRing2, genPolynomial5, new FromInteger<BigRational>(bigRational));
        genPolynomial4 = genPolynomial4.monic();
        PolyUtilTest.assertEquals((String)"pr == qr ", genPolynomial2, genPolynomial4);
        genPolynomial5 = PolyUtil.map(genPolynomialRing, genPolynomial3, new ModSymToInt());
        GenPolynomial<ModInteger> genPolynomial6 = PolyUtil.map(genPolynomialRing3, genPolynomial5, new FromInteger<ModInteger>(modIntegerRing));
        PolyUtilTest.assertEquals((String)"pm == qm ", genPolynomial3, genPolynomial6);
        genPolynomial5 = PolyUtil.map(genPolynomialRing, genPolynomial3, new ModToInt());
        genPolynomial6 = PolyUtil.map(genPolynomialRing3, genPolynomial5, new FromInteger<ModInteger>(modIntegerRing));
        PolyUtilTest.assertEquals((String)"pm == qm ", genPolynomial3, genPolynomial6);
        genPolynomial5 = PolyUtil.map(genPolynomialRing, genPolynomial3, new ModSymToInt());
        genPolynomial4 = PolyUtil.map(genPolynomialRing2, genPolynomial5, new FromInteger<BigRational>(bigRational));
        genPolynomial5 = PolyUtil.map(genPolynomialRing, genPolynomial4, new RatNumer());
        genPolynomial6 = PolyUtil.map(genPolynomialRing3, genPolynomial5, new FromInteger<ModInteger>(modIntegerRing));
        PolyUtilTest.assertEquals((String)"pm == qm ", genPolynomial3, genPolynomial6);
    }

    public void testSubstitution() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        GenPolynomial<BigInteger> genPolynomial = this.dfac.univariate(0).subtract((BigInteger)this.dfac.fromInteger(7L));
        GenPolynomial<BigInteger> genPolynomial2 = this.dfac.univariate(0).sum((BigInteger)this.dfac.fromInteger(7L));
        for (int i = 0; i < 5; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = PolyUtil.substituteMain(this.a, genPolynomial);
            this.c = PolyUtil.substituteMain(this.b, genPolynomial2);
            PolyUtilTest.assertEquals((String)"a == c ", this.a, this.c);
        }
    }

    public void testAlgebraicSubstitution() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"alpha"};
        String[] stringArray2 = new String[]{"z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, this.to, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L);
        genPolynomial = genPolynomial.sum((BigRational)genPolynomialRing.getONE());
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(algebraicNumberRing, 1, this.to, stringArray2);
        GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> genPolynomial2 = genPolynomialRing2.univariate(0).subtract((BigRational)((Object)((GenPolynomial)genPolynomialRing2.fromInteger(7L)).multiply(algebraicNumberRing.getGenerator())));
        GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> genPolynomial3 = genPolynomialRing2.univariate(0).sum((BigRational)((Object)((GenPolynomial)genPolynomialRing2.fromInteger(7L)).multiply(algebraicNumberRing.getGenerator())));
        for (int i = 0; i < 5; ++i) {
            GenPolynomial<BigRational> genPolynomial4 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> genPolynomial5 = PolyUtil.substituteMain(genPolynomial4, genPolynomial2);
            GenPolynomial<GenPolynomial<AlgebraicNumber<BigRational>>> genPolynomial6 = PolyUtil.substituteMain(genPolynomial5, genPolynomial3);
            PolyUtilTest.assertEquals((String)"a == c ", genPolynomial4, genPolynomial6);
        }
    }

    public void testSwitchVariables() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, this.rl, this.to);
        for (int i = 0; i < 5; ++i) {
            GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial genPolynomial2 = PolyUtil.switchVariables(genPolynomial);
            GenPolynomial genPolynomial3 = PolyUtil.switchVariables(genPolynomial2);
            PolyUtilTest.assertEquals((String)"a == c ", genPolynomial, genPolynomial3);
        }
    }

    public void testAlgebraicConversions() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"alpha"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, this.to, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L);
        genPolynomial = genPolynomial.sum((BigRational)genPolynomialRing.getONE());
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(algebraicNumberRing, this.rl, this.to);
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(genPolynomialRing, this.rl, this.to);
        for (int i = 0; i < 5; ++i) {
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial genPolynomial3 = PolyUtil.fromAlgebraicCoefficients(genPolynomialRing3, genPolynomial2);
            GenPolynomial genPolynomial4 = PolyUtil.convertRecursiveToAlgebraicCoefficients(genPolynomialRing2, genPolynomial3);
            PolyUtilTest.assertEquals((String)"a == c ", genPolynomial2, genPolynomial4);
        }
    }

    public void testTaylorSeries() {
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, this.to, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        BigRational bigRational2 = bigRational.getZERO();
        GenPolynomial<BigRational> genPolynomial2 = PolyUtil.seriesOfTaylor(genPolynomial, bigRational2);
        PolyUtilTest.assertTrue((String)"taylor(a,0) == a ", (boolean)genPolynomial.equals(genPolynomial2));
        bigRational2 = bigRational.random(this.kl);
        genPolynomial2 = PolyUtil.seriesOfTaylor(genPolynomial, bigRational2);
        GenPolynomial<BigRational> genPolynomial3 = PolyUtil.seriesOfTaylor(genPolynomial2, bigRational2.negate());
        PolyUtilTest.assertTrue((String)"tailor(taylor(a,v),-v) == a ", (boolean)genPolynomial.equals(genPolynomial3));
    }

    public void testComplexParts() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(new BigRational(1L));
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(complexRing, this.rl, this.to);
        Complex<BigRational> complex = complexRing.getIMAG();
        for (int i = 0; i < 3; ++i) {
            GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.random(this.kl + 2 * i, this.ll * (i + 1), this.el + i, this.q);
            PolyUtilTest.assertTrue((String)("length( c" + i + " ) <> 0"), (genPolynomial.length() >= 0 ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isZERO( c" + i + " )"), (!genPolynomial.isZERO() ? 1 : 0) != 0);
            PolyUtilTest.assertTrue((String)(" not isONE( c" + i + " )"), (!genPolynomial.isONE() ? 1 : 0) != 0);
            GenPolynomial<BigRational> genPolynomial2 = PolyUtil.realPartFromComplex(genPolynomialRing, genPolynomial);
            GenPolynomial<BigRational> genPolynomial3 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing, genPolynomial);
            GenPolynomial<Complex<BigRational>> genPolynomial4 = PolyUtil.toComplex(genPolynomialRing2, genPolynomial2);
            GenPolynomial<Complex<BigRational>> genPolynomial5 = PolyUtil.toComplex(genPolynomialRing2, genPolynomial3);
            GenPolynomial<GenPolynomial<Complex<BigRational>>> genPolynomial6 = genPolynomial4.sum((Complex<BigRational>)((Object)genPolynomial5.multiply(complex)));
            PolyUtilTest.assertEquals((String)"re(c)+i*im(c) = c", genPolynomial, genPolynomial6);
        }
    }

    public void testProductConversionRN() {
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        ProductRing<BigRational> productRing = new ProductRing<BigRational>(genPolynomialRing, this.rl);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.getONE();
        Product<GenPolynomial<Object>> product = PolyUtil.toProduct(productRing, genPolynomial);
        PolyUtilTest.assertTrue((String)"isONE( cp )", (boolean)product.isONE());
        genPolynomial = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q);
        product = PolyUtil.toProduct(productRing, genPolynomial);
        PolyUtilTest.assertTrue((String)"!isONE( cp )", (!product.isONE() ? 1 : 0) != 0);
    }

    public void testPolyProductConversionAN() {
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        GenPolynomial<RingElem<BigRational>> genPolynomial = genPolynomialRing.univariate(0, 2L);
        genPolynomial = genPolynomial.subtract((BigRational)((Object)genPolynomialRing.univariate(0, 1L)));
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        ProductRing<BigRational> productRing = new ProductRing<BigRational>(algebraicNumberRing, this.rl);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(productRing, 2);
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(algebraicNumberRing, 2, this.to);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing3.getONE();
        GenPolynomial<Product<Object>> genPolynomial3 = PolyUtil.toProductGen(genPolynomialRing2, genPolynomial2);
        PolyUtilTest.assertTrue((String)"isZERO( cp )", (boolean)genPolynomial3.isONE());
        genPolynomial2 = genPolynomialRing3.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = PolyUtil.toProductGen(genPolynomialRing2, genPolynomial2);
        PolyUtilTest.assertTrue((String)"!isONE( cp )", (!genPolynomial3.isONE() ? 1 : 0) != 0);
    }

    public void testRemoveUnusedUpper() {
        this.a = this.dfac.univariate(3, 2L);
        this.b = this.a.subtract((BigInteger)((Object)this.dfac.univariate(1, 1L)));
        this.c = PolyUtil.removeUnusedUpperVariables(this.b);
        PolyUtilTest.assertTrue((String)("#var == 4: " + this.c.ring.nvar), (this.c.ring.nvar == 4 ? 1 : 0) != 0);
        this.a = this.dfac.univariate(3, 2L);
        this.c = PolyUtil.removeUnusedUpperVariables(this.a);
        PolyUtilTest.assertTrue((String)("#var == 2: " + this.c.ring.nvar), (this.c.ring.nvar == 2 ? 1 : 0) != 0);
        this.a = this.dfac.univariate(1, 2L);
        this.c = PolyUtil.removeUnusedUpperVariables(this.a);
        PolyUtilTest.assertTrue((String)("#var == 4: " + this.c.ring.nvar), (this.c.ring.nvar == 4 ? 1 : 0) != 0);
    }

    public void testRemoveUnusedLower() {
        this.a = this.dfac.univariate(3, 2L);
        this.b = this.a.subtract((BigInteger)((Object)this.dfac.univariate(1, 1L)));
        this.c = PolyUtil.removeUnusedLowerVariables(this.b);
        PolyUtilTest.assertTrue((String)("#var == 4: " + this.c.ring.nvar), (this.c.ring.nvar == 4 ? 1 : 0) != 0);
        this.a = this.dfac.univariate(3, 2L);
        this.c = PolyUtil.removeUnusedLowerVariables(this.a);
        PolyUtilTest.assertTrue((String)("#var == 4: " + this.c.ring.nvar), (this.c.ring.nvar == 4 ? 1 : 0) != 0);
        this.a = this.dfac.univariate(1, 2L);
        this.c = PolyUtil.removeUnusedLowerVariables(this.a);
        PolyUtilTest.assertTrue((String)("#var == 2: " + this.c.ring.nvar), (this.c.ring.nvar == 2 ? 1 : 0) != 0);
    }

    public void testRemoveUnusedMiddle() {
        this.a = this.dfac.univariate(4, 2L);
        this.b = this.a.subtract((BigInteger)((Object)this.dfac.univariate(0, 1L)));
        this.c = PolyUtil.removeUnusedLowerVariables(this.b);
        PolyUtilTest.assertTrue((String)("#var == 5: " + this.c.ring.nvar), (this.c.ring.nvar == 5 ? 1 : 0) != 0);
        this.c = PolyUtil.removeUnusedUpperVariables(this.c);
        PolyUtilTest.assertTrue((String)("#var == 5: " + this.c.ring.nvar), (this.c.ring.nvar == 5 ? 1 : 0) != 0);
        this.c = PolyUtil.removeUnusedMiddleVariables(this.c);
        PolyUtilTest.assertTrue((String)("#var == 2: " + this.c.ring.nvar), (this.c.ring.nvar == 2 ? 1 : 0) != 0);
        this.a = this.dfac.univariate(3, 2L);
        this.b = this.a.subtract((BigInteger)((Object)this.dfac.univariate(1, 1L)));
        try {
            this.c = PolyUtil.removeUnusedMiddleVariables(this.b);
            PolyUtilTest.fail((String)("c = " + this.c + ", fac = " + this.c.ring));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.c = PolyUtil.removeUnusedLowerVariables(this.b);
        PolyUtilTest.assertTrue((String)("#var == 4: " + this.c.ring.nvar), (this.c.ring.nvar == 4 ? 1 : 0) != 0);
        this.c = PolyUtil.removeUnusedUpperVariables(this.c);
        PolyUtilTest.assertTrue((String)("#var == 3: " + this.c.ring.nvar), (this.c.ring.nvar == 3 ? 1 : 0) != 0);
        this.c = PolyUtil.removeUnusedMiddleVariables(this.c);
        PolyUtilTest.assertTrue((String)("#var == 2: " + this.c.ring.nvar), (this.c.ring.nvar == 2 ? 1 : 0) != 0);
    }
}

