/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ps.ExpVectorIterable;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.CartesianProductLong;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class IteratorsTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)IteratorsTest.suite());
    }

    public IteratorsTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(IteratorsTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testExpVector() {
        int n = 5;
        LongIterable longIterable = new LongIterable();
        longIterable.setNonNegativeIterator();
        ArrayList<Iterable<LongIterable>> arrayList = new ArrayList<Iterable<LongIterable>>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(longIterable);
        }
        TreeSet<ExpVector> treeSet = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        CartesianProductInfinite cartesianProductInfinite = new CartesianProductInfinite(arrayList);
        long l = 0L;
        for (List list : cartesianProductInfinite) {
            ExpVector expVector = ExpVector.create(list);
            IteratorsTest.assertFalse((String)"e in set", (boolean)treeSet.contains(expVector));
            treeSet.add(expVector);
            if (++l <= 100L) continue;
            break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)treeSet.size() == l ? 1 : 0) != 0);
    }

    public void testGenPolynomial() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(5L, true);
        int n = 3;
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, n);
        TreeSet<GenPolynomial<ModInteger>> treeSet = new TreeSet<GenPolynomial<ModInteger>>();
        long l = 0L;
        for (GenPolynomial<ModInteger> genPolynomial : genPolynomialRing) {
            if (treeSet.contains(genPolynomial)) {
                System.out.println("p = " + genPolynomial);
                System.out.println("set = " + treeSet);
                IteratorsTest.assertFalse((String)"p in set ", (boolean)true);
            }
            treeSet.add(genPolynomial);
            if (++l <= 650L) continue;
            break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)treeSet.size() == l ? 1 : 0) != 0);
    }

    public void testGenPolynomialMonomial() {
        BigInteger bigInteger = new BigInteger(1L);
        int n = 3;
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, n);
        TreeSet<GenPolynomial<BigInteger>> treeSet = new TreeSet<GenPolynomial<BigInteger>>();
        long l = 0L;
        for (GenPolynomial<BigInteger> genPolynomial : genPolynomialRing) {
            if (treeSet.contains(genPolynomial)) {
                System.out.println("p = " + genPolynomial);
                IteratorsTest.assertFalse((String)"p in set ", (boolean)true);
            }
            treeSet.add(genPolynomial);
            if (++l <= 650L) continue;
            break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)treeSet.size() == l ? 1 : 0) != 0);
    }

    public void testTotalDegExpVector() {
        int n = 4;
        TreeSet<ExpVector> treeSet = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        TreeMap<Long, TreeSet<ExpVector>> treeMap = new TreeMap<Long, TreeSet<ExpVector>>();
        long l = 0L;
        block0: for (long i = 0L; i < 14L; ++i) {
            LongIterable longIterable = new LongIterable();
            longIterable.setNonNegativeIterator();
            longIterable.setUpperBound(i);
            ArrayList<LongIterable> arrayList = new ArrayList<LongIterable>(n);
            for (int j = 0; j < n; ++j) {
                arrayList.add(longIterable);
            }
            long l2 = i;
            CartesianProductLong cartesianProductLong = new CartesianProductLong(arrayList, l2);
            for (List list : cartesianProductLong) {
                ExpVector expVector = ExpVector.create(list);
                long l3 = expVector.totalDeg();
                IteratorsTest.assertTrue((String)"tdeg == k", (l3 == l2 ? 1 : 0) != 0);
                TreeSet<ExpVector> treeSet2 = (TreeSet<ExpVector>)treeMap.get(l3);
                if (treeSet2 == null) {
                    treeSet2 = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
                    treeMap.put(l3, treeSet2);
                }
                treeSet2.add(expVector);
                treeSet.add(expVector);
                if (++l <= 500000L) continue;
                continue block0;
            }
        }
        for (Set set : treeMap.values()) {
            IteratorsTest.assertFalse((String)"es != null", (set == null ? 1 : 0) != 0);
        }
        IteratorsTest.assertTrue((String)"#set", ((long)treeSet.size() == l ? 1 : 0) != 0);
    }

    public void testTotalDegExpVectorIteratorInf() {
        int n = 4;
        TreeSet<ExpVector> treeSet = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(n);
        long l = 0L;
        for (ExpVector expVector : expVectorIterable) {
            if (++l > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)treeSet.contains(expVector));
            treeSet.add(expVector);
        }
    }

    public void testTotalDegExpVectorIteratorFin() {
        int n = 4;
        TreeSet<ExpVector> treeSet = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(n, 5L);
        long l = 0L;
        for (ExpVector expVector : expVectorIterable) {
            if (++l > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)treeSet.contains(expVector));
            treeSet.add(expVector);
        }
    }

    public void testTotalDegExpVectorIteratorAllFin() {
        int n = 4;
        TreeSet<ExpVector> treeSet = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(n, true, 5L);
        long l = 0L;
        for (ExpVector expVector : expVectorIterable) {
            if (++l > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)treeSet.contains(expVector));
            treeSet.add(expVector);
        }
    }
}

