/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBasePseudoSeqTest
extends TestCase {
    GenPolynomialRing<BigInteger> fac;
    List<GenPolynomial<BigInteger>> L;
    List<GenPolynomial<BigInteger>> G;
    PolynomialList<BigInteger> F;
    GroebnerBase<BigInteger> bb;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBasePseudoSeqTest.suite());
    }

    public GroebnerBasePseudoSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBasePseudoSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        this.fac = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBasePseudoSeq<BigInteger>(bigInteger);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePseudoSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePseudoSeqTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBasePseudoSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBasePseudoSeqTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        GroebnerBasePseudoSeqTest.assertTrue((String)"nonsense ", (l >= 0L ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing = this.F.ring;
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(bigRational, genPolynomialRing);
        List list = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.F.list);
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq();
        long l2 = System.currentTimeMillis();
        List list2 = groebnerBaseSeq.GB(list);
        l2 = System.currentTimeMillis() - l2;
        List list3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, this.G);
        list3 = PolyUtil.monic(list3);
        GroebnerBasePseudoSeqTest.assertEquals((String)"ratGB == intGB", list2, list3);
        GroebnerBasePseudoSeqTest.assertTrue((String)"nonsense ", (l2 >= 0L ? 1 : 0) != 0);
    }
}

