/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class FactorMoreTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)FactorMoreTest.suite());
    }

    public FactorMoreTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorMoreTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testIntegralFunctionFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0);
        FactorRational factorRational = new FactorRational();
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, 1, termOrder, stringArray2);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing2.univariate(0, 2L);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial genPolynomial4;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial5 = genPolynomialRing2.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial6 = genPolynomialRing2.random(2, 3, this.el, this.q);
            if (genPolynomial6.degree() < 1L) {
                genPolynomial6 = genPolynomial3.subtract((BigRational)((Object)((GenPolynomial)genPolynomialRing2.getONE()).multiply(genPolynomial)));
            }
            if (genPolynomial5.degree() < 1L) {
                genPolynomial5 = genPolynomial2.sum((BigRational)genPolynomialRing2.getONE());
            }
            if (genPolynomial6.degree() > 0L) {
                ++n;
            }
            if (genPolynomial5.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorRational.recursiveFactors(genPolynomial4 = genPolynomial6.multiply((RingElem<BigRational>)genPolynomial5))).size() >= n) {
                FactorMoreTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorRational.isRecursiveFactorization(genPolynomial4, sortedMap);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
        ComputerThreads.terminate();
    }

    public void testIntegerIntegralFunctionFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, termOrder, stringArray);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.univariate(0);
        FactorInteger factorInteger = new FactorInteger();
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(genPolynomialRing, 1, termOrder, stringArray2);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing2.univariate(0);
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing2.univariate(0, 2L);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial genPolynomial4;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigInteger> genPolynomial5 = genPolynomialRing2.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigInteger>> genPolynomial6 = genPolynomialRing2.random(2, 3, this.el, this.q);
            if (genPolynomial6.degree() < 1L) {
                genPolynomial6 = genPolynomial3.subtract((BigInteger)((Object)((GenPolynomial)genPolynomialRing2.getONE()).multiply(genPolynomial)));
            }
            if (genPolynomial5.degree() < 1L) {
                genPolynomial5 = genPolynomial2.sum((BigInteger)genPolynomialRing2.getONE());
            }
            if (genPolynomial6.degree() > 0L) {
                ++n;
            }
            if (genPolynomial5.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorInteger.recursiveFactors(genPolynomial4 = genPolynomial6.multiply((RingElem<BigInteger>)genPolynomial5))).size() >= n) {
                FactorMoreTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + n + ", sm = " + sortedMap), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorInteger.isRecursiveFactorization(genPolynomial4, sortedMap);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
        ComputerThreads.terminate();
    }

    public void testRationalFunctionFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        Quotient<BigRational> quotient = quotientRing.generators().get(1);
        FactorQuotient<BigRational> factorQuotient = new FactorQuotient<BigRational>(quotientRing);
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(quotientRing, 1, termOrder, stringArray2);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing2.univariate(0);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.univariate(0, 2L);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<BigRational>> genPolynomial3;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial4 = genPolynomialRing2.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial5 = genPolynomialRing2.random(2, 3, this.el, this.q);
            if (genPolynomial5.degree() < 1L) {
                genPolynomial5 = genPolynomial2.subtract((BigRational)((Object)((GenPolynomial)genPolynomialRing2.getONE()).multiply(quotient)));
            }
            if (genPolynomial4.degree() < 1L) {
                genPolynomial4 = genPolynomial.sum((BigRational)genPolynomialRing2.getONE());
            }
            if (genPolynomial5.degree() > 0L) {
                ++n;
            }
            if (genPolynomial4.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorQuotient.factors(genPolynomial3 = genPolynomial5.multiply((RingElem<BigRational>)genPolynomial4))).size() >= n) {
                FactorMoreTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorQuotient.isFactorization(genPolynomial3, sortedMap);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
        ComputerThreads.terminate();
    }

    public void testModularRationalFunctionFactorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder, stringArray);
        QuotientRing<ModInteger> quotientRing = new QuotientRing<ModInteger>(genPolynomialRing);
        Quotient<ModInteger> quotient = quotientRing.generators().get(1);
        FactorQuotient<ModInteger> factorQuotient = new FactorQuotient<ModInteger>(quotientRing);
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(quotientRing, 1, termOrder, stringArray2);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing2.univariate(0);
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing2.univariate(0, 2L);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial3;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<ModInteger> genPolynomial4 = genPolynomialRing2.random(2, 3, this.el, this.q);
            GenPolynomial<RingElem<ModInteger>> genPolynomial5 = genPolynomialRing2.random(2, 3, this.el, this.q);
            if (genPolynomial5.degree() < 1L) {
                genPolynomial5 = genPolynomial2.subtract((ModInteger)((Object)((GenPolynomial)genPolynomialRing2.getONE()).multiply(quotient)));
            }
            if (genPolynomial4.degree() < 1L) {
                genPolynomial4 = genPolynomial.sum((ModInteger)genPolynomialRing2.getONE());
            }
            if (genPolynomial5.degree() > 0L) {
                ++n;
            }
            if (genPolynomial4.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorQuotient.factors(genPolynomial3 = genPolynomial5.multiply((RingElem<ModInteger>)genPolynomial4))).size() >= n) {
                FactorMoreTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorMoreTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorQuotient.isFactorization(genPolynomial3, sortedMap);
            FactorMoreTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
        ComputerThreads.terminate();
    }
}

