/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.ModGroebnerBase;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ModGroebnerBaseAbstract<C extends GcdRingElem<C>>
implements ModGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(ModGroebnerBaseAbstract.class);

    @Override
    public boolean isGB(ModuleList<C> moduleList) {
        if (moduleList == null || moduleList.list == null) {
            return true;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return true;
        }
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        return this.isGB(n, polynomialList.list);
    }

    @Override
    public ModuleList<C> GB(ModuleList<C> moduleList) {
        ModuleList<C> moduleList2 = moduleList;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        List list = this.GB(n, polynomialList.list);
        polynomialList = new PolynomialList(polynomialList.ring, list);
        moduleList2 = polynomialList.getModuleList(n);
        return moduleList2;
    }

    public void terminate() {
        logger.info((Object)"terminate not implemented");
    }

    public int cancel() {
        logger.info((Object)"cancel not implemented");
        return 0;
    }
}

