/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBasePseudoParTest
extends TestCase {
    GenPolynomialRing<BigInteger> fac;
    List<GenPolynomial<BigInteger>> L;
    PolynomialList<BigInteger> F;
    List<GenPolynomial<BigInteger>> G;
    GroebnerBaseAbstract<BigInteger> bb;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBasePseudoParTest.suite());
    }

    public GroebnerBasePseudoParTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBasePseudoParTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        this.fac = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBasePseudoParallel<BigInteger>(this.threads, bigInteger);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb.terminate();
        this.bb = null;
    }

    public void testParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePseudoParTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePseudoParTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBasePseudoParTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBasePseudoParTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBasePseudoParTest.assertTrue((String)"nonsense ", (l >= 0L ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing = this.F.ring;
        GroebnerBasePseudoSeq groebnerBasePseudoSeq = new GroebnerBasePseudoSeq(genPolynomialRing.coFac);
        long l2 = System.currentTimeMillis();
        List list = groebnerBasePseudoSeq.GB(this.F.list);
        l2 = System.currentTimeMillis() - l2;
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, list);
        GroebnerBasePseudoParTest.assertEquals((String)"seqGB == parGB", polynomialList, polynomialList2);
        GroebnerBasePseudoParTest.assertTrue((String)"nonsense ", (l2 >= 0L ? 1 : 0) != 0);
    }
}

