/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GCDModularTest
extends TestCase {
    GreatestCommonDivisorAbstract<ModInteger> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<ModInteger> dfac;
    GenPolynomialRing<ModInteger> cfac;
    GenPolynomialRing<GenPolynomial<ModInteger>> rfac;
    PrimeList primes = new PrimeList();
    ModIntegerRing mi;
    ModInteger ai;
    ModInteger bi;
    ModInteger ci;
    ModInteger di;
    ModInteger ei;
    GenPolynomial<ModInteger> a;
    GenPolynomial<ModInteger> b;
    GenPolynomial<ModInteger> c;
    GenPolynomial<ModInteger> d;
    GenPolynomial<ModInteger> e;
    GenPolynomial<ModInteger> ac;
    GenPolynomial<ModInteger> bc;
    GenPolynomial<GenPolynomial<ModInteger>> ar;
    GenPolynomial<GenPolynomial<ModInteger>> br;
    GenPolynomial<GenPolynomial<ModInteger>> cr;
    GenPolynomial<GenPolynomial<ModInteger>> dr;
    GenPolynomial<GenPolynomial<ModInteger>> er;
    GenPolynomial<GenPolynomial<ModInteger>> arc;
    GenPolynomial<GenPolynomial<ModInteger>> brc;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GCDModularTest.suite());
    }

    public GCDModularTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDModularTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new ModIntegerRing(19L, true);
        this.ufd = new GreatestCommonDivisorPrimitive<ModInteger>();
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, this.rl, this.to);
        this.cfac = new GenPolynomialRing<ModInteger>(this.mi, this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<ModInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testModularEvaluationGcd() {
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        for (int i = 0; i < 2; ++i) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            abelianGroupElem = abelianGroupElem.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomialRing.univariate(0)))));
            if (genPolynomial.isZERO() || genPolynomial2.isZERO() || abelianGroupElem.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (abelianGroupElem.length() > 0 ? 1 : 0) != 0);
            genPolynomial = genPolynomial.multiply((BigInteger)abelianGroupElem);
            genPolynomial2 = genPolynomial2.multiply((BigInteger)abelianGroupElem);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).gcd(genPolynomial, genPolynomial2);
            abelianGroupElem = greatestCommonDivisorPrimitive.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)abelianGroupElem).abs();
            GenPolynomial<BigInteger> genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial3, abelianGroupElem);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial, genPolynomial3);
            GCDModularTest.assertTrue((String)("gcd(a,b) | a" + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial2, genPolynomial3);
            GCDModularTest.assertTrue((String)("gcd(a,b) | b" + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
    }

    public void testModularSimpleGcd() {
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular(true);
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            abelianGroupElem = abelianGroupElem.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomialRing.univariate(0)))));
            if (genPolynomial.isZERO() || genPolynomial2.isZERO() || abelianGroupElem.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (abelianGroupElem.length() > 0 ? 1 : 0) != 0);
            genPolynomial = genPolynomial.multiply((BigInteger)abelianGroupElem);
            genPolynomial2 = genPolynomial2.multiply((BigInteger)abelianGroupElem);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).gcd(genPolynomial, genPolynomial2);
            abelianGroupElem = greatestCommonDivisorPrimitive.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)abelianGroupElem).abs();
            GenPolynomial<BigInteger> genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial3, abelianGroupElem);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial, genPolynomial3);
            GCDModularTest.assertTrue((String)("gcd(a,b) | a" + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial2, genPolynomial3);
            GCDModularTest.assertTrue((String)("gcd(a,b) | b" + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
    }

    public void testRecursiveContentPPmodular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModInteger>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModInteger>(this.cfac, 1, this.to);
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive();
        for (int i = 0; i < 1; ++i) {
            this.a = this.cfac.random(this.kl, this.ll + 2 * i, this.el + i, this.q).monic();
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.cr = PolyUtil.monic(this.cr);
            this.cr = this.cr.multiply(this.a);
            if (this.cr.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.c = greatestCommonDivisorPrimitive.recursiveContent(this.cr).monic();
            this.dr = greatestCommonDivisorPrimitive.recursivePrimitivePart(this.cr);
            this.dr = PolyUtil.monic(this.dr);
            this.ar = this.dr.multiply(this.c);
            GCDModularTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
        }
    }

    public void testGCDbaseModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 1, this.to);
        GreatestCommonDivisorPrimitive<ModInteger> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModInteger>();
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.ac = this.a.multiply((ModInteger)((Object)this.c));
            this.bc = this.b.multiply((ModInteger)((Object)this.c));
            this.d = ((GreatestCommonDivisorAbstract)greatestCommonDivisorPrimitive).baseGcd(this.ac, this.bc);
            this.d = this.d.monic();
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModInteger>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModInteger>(this.cfac, 1, this.to);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.arc = this.ar.multiply((GenPolynomial<ModInteger>)this.cr);
            this.brc = this.br.multiply((GenPolynomial<ModInteger>)this.cr);
            this.dr = this.ufd.recursiveUnivariateGcd(this.arc, this.brc);
            this.dr = PolyUtil.monic(this.dr);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testArbitraryRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModInteger>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModInteger>(this.cfac, 1, this.to);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.arc = this.ar.multiply((GenPolynomial<ModInteger>)this.cr);
            this.brc = this.br.multiply((GenPolynomial<ModInteger>)this.cr);
            this.dr = this.ufd.recursiveGcd(this.arc, this.brc);
            this.dr = PolyUtil.monic(this.dr);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testGcdModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.ac = this.a.multiply((ModInteger)((Object)this.c));
            this.bc = this.b.multiply((ModInteger)((Object)this.c));
            this.d = this.ufd.gcd(this.ac, this.bc);
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDModularTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.ac, this.d);
            GCDModularTest.assertTrue((String)("gcd(ac,bc) | ac " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.bc, this.d);
            GCDModularTest.assertTrue((String)("gcd(ac,bc) | bc " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDModularTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((ModInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        ArrayList arrayList = new ArrayList(5);
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        arrayList.add(this.d);
        arrayList.add(this.e);
        List<GenPolynomial<Object>> list = this.ufd.coPrime(arrayList);
        GCDModularTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDModularTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
        list = this.ufd.coPrimeRec(arrayList);
        GCDModularTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDModularTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
    }

    public void testResultantBaseModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 1, this.to);
        GreatestCommonDivisorSimple<ModInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModInteger>();
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            if (this.c.isConstant()) {
                this.c = this.dfac.univariate(0, 1L);
            }
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.d = greatestCommonDivisorSimple.baseResultant(this.a, this.b);
            this.e = greatestCommonDivisorSubres.baseResultant(this.a, this.b);
            GCDModularTest.assertEquals((String)("d == e: " + this.d.subtract((ModInteger)((Object)this.e))), (int)this.d.signum(), (int)this.e.signum());
            this.ac = this.a.multiply((ModInteger)((Object)this.c));
            this.bc = this.b.multiply((ModInteger)((Object)this.c));
            this.d = greatestCommonDivisorSimple.baseResultant(this.ac, this.bc);
            GCDModularTest.assertTrue((String)("d == 0: " + this.d), (boolean)this.d.isZERO());
            this.e = greatestCommonDivisorSubres.baseResultant(this.ac, this.bc);
            GCDModularTest.assertTrue((String)("e == 0: " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveResultantModular() {
        this.cfac = new GenPolynomialRing<ModInteger>(this.mi, 2, this.to);
        this.rfac = new GenPolynomialRing<ModInteger>(this.cfac, 1, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 3, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 1, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            if (this.cr.isConstant()) {
                this.cr = this.rfac.univariate(0, 1L);
            }
            GCDModularTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.dr = greatestCommonDivisorSimple.recursiveUnivariateResultant(this.ar, this.br);
            this.er = greatestCommonDivisorSubres.recursiveUnivariateResultant(this.ar, this.br);
            GCDModularTest.assertEquals((String)("dr == er: " + this.dr.subtract((GenPolynomial<ModInteger>)this.er)), (int)this.dr.signum(), (int)this.er.signum());
            this.arc = this.ar.multiply((GenPolynomial<ModInteger>)this.cr);
            this.brc = this.br.multiply((GenPolynomial<ModInteger>)this.cr);
            this.dr = greatestCommonDivisorSimple.recursiveUnivariateResultant(this.arc, this.brc);
            this.er = greatestCommonDivisorSubres.recursiveUnivariateResultant(this.arc, this.brc);
            GCDModularTest.assertEquals((String)("dr == er: " + this.dr.subtract((GenPolynomial<ModInteger>)this.er)), (int)this.dr.signum(), (int)this.er.signum());
        }
    }

    public void testResultantModular() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.mi, 4, this.to);
        GreatestCommonDivisorSimple<ModInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModInteger>();
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            if (this.c.isConstant()) {
                this.c = this.dfac.univariate(0, 1L);
            }
            GCDModularTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.d = greatestCommonDivisorSimple.resultant(this.a, this.b);
            this.e = greatestCommonDivisorSubres.resultant(this.a, this.b);
            GCDModularTest.assertEquals((String)("d == e: " + this.d.subtract((ModInteger)((Object)this.e))), (int)this.d.signum(), (int)this.e.signum());
            this.ac = this.a.multiply((ModInteger)((Object)this.c));
            this.bc = this.b.multiply((ModInteger)((Object)this.c));
            this.d = greatestCommonDivisorSimple.resultant(this.ac, this.bc);
            this.e = greatestCommonDivisorSubres.resultant(this.ac, this.bc);
            GCDModularTest.assertEquals((String)("d == e: " + this.d.subtract((ModInteger)((Object)this.e))), (int)this.d.signum(), (int)this.e.signum());
        }
    }
}

