/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Reduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ReductionAbstract<C extends RingElem<C>>
implements Reduction<C> {
    private static final Logger logger = Logger.getLogger(ReductionAbstract.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public GenPolynomial<C> SPolynomial(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            if (genPolynomial == null) {
                return genPolynomial2;
            }
            return genPolynomial.ring.getZERO();
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2.ring.getZERO();
        }
        if (this.debug && !genPolynomial.ring.equals(genPolynomial2.ring)) {
            logger.error((Object)("rings not equal " + genPolynomial.ring + ", " + genPolynomial2.ring));
        }
        Map.Entry<ExpVector, C> entry = genPolynomial.leadingMonomial();
        Map.Entry<ExpVector, C> entry2 = genPolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        GenPolynomial<RingElem> genPolynomial3 = genPolynomial.scaleSubtractMultiple(ringElem2, expVector4, ringElem, expVector5, genPolynomial2);
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<C> SPolynomial(List<GenPolynomial<C>> list, int n, GenPolynomial<C> genPolynomial, int n2, GenPolynomial<C> genPolynomial2) {
        if (this.debug) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) {
                throw new ArithmeticException("Spol B is zero");
            }
            if (genPolynomial == null || genPolynomial.isZERO()) {
                throw new ArithmeticException("Spol A is zero");
            }
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error((Object)("rings not equal " + genPolynomial.ring + ", " + genPolynomial2.ring));
            }
        }
        Map.Entry<ExpVector, C> entry = genPolynomial.leadingMonomial();
        Map.Entry<ExpVector, C> entry2 = genPolynomial2.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        GenPolynomial<RingElem> genPolynomial3 = genPolynomial.scaleSubtractMultiple(ringElem2, expVector4, ringElem, expVector5, genPolynomial2);
        AbelianGroupElem abelianGroupElem = genPolynomial.ring.getZERO();
        GenPolynomial<RingElem> genPolynomial4 = ((GenPolynomial)abelianGroupElem).sum((RingElem)ringElem2.negate(), expVector4);
        GenPolynomial<RingElem> genPolynomial5 = ((GenPolynomial)abelianGroupElem).sum(ringElem, expVector5);
        list.set(n, genPolynomial4);
        list.set(n2, genPolynomial5);
        return genPolynomial3;
    }

    @Override
    public boolean moduleCriterion(int n, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (n == 0) {
            return true;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        return this.moduleCriterion(n, expVector, expVector2);
    }

    @Override
    public boolean moduleCriterion(int n, ExpVector expVector, ExpVector expVector2) {
        if (n == 0) {
            return true;
        }
        return expVector.invLexCompareTo(expVector2, 0, n) == 0;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, ExpVector expVector) {
        if (logger.isInfoEnabled()) {
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error((Object)("rings not equal " + genPolynomial.ring + ", " + genPolynomial2.ring));
            }
            if (!genPolynomial.ring.isCommutative()) {
                logger.error((Object)"GBCriterion4 not applicabable to non-commutative polynomials");
                return true;
            }
        }
        ExpVector expVector2 = genPolynomial.leadingExpVector();
        ExpVector expVector3 = genPolynomial2.leadingExpVector();
        return this.criterion4(expVector2, expVector3, expVector);
    }

    @Override
    public boolean criterion4(ExpVector expVector, ExpVector expVector2, ExpVector expVector3) {
        ExpVector expVector4 = expVector.sum(expVector2);
        ExpVector expVector5 = expVector4.subtract(expVector3);
        int n = expVector5.signum();
        return n != 0;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (!(!logger.isInfoEnabled() || genPolynomial.ring.isCommutative() && genPolynomial2.ring.isCommutative())) {
            logger.error((Object)"GBCriterion4 not applicabable to non-commutative polynomials");
            return true;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        ExpVector expVector3 = expVector.lcm(expVector2);
        return this.criterion4(expVector, expVector2, expVector3);
    }

    @Override
    public List<GenPolynomial<C>> normalform(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list2;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list2) {
            genPolynomial = this.normalform(list, genPolynomial);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = genPolynomial.leadingExpVector();
        for (GenPolynomial<C> genPolynomial2 : list) {
            bl = expVector.multipleOf(genPolynomial2.leadingExpVector());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReducible(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        return !this.isNormalform(list, genPolynomial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> expVectorArray, GenPolynomial<C> genPolynomial) {
        if (expVectorArray == null || expVectorArray.isEmpty()) {
            return true;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        ExpVector[] expVectorArray2 = expVectorArray;
        synchronized (expVectorArray) {
            int n;
            int n2 = expVectorArray.size();
            GenPolynomial[] genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < expVectorArray.size(); ++i) {
                genPolynomialArray[i] = expVectorArray.get(i);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            expVectorArray2 = new ExpVector[n2];
            GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                genPolynomialArray2[n] = genPolynomialArray[n];
                Map.Entry entry = genPolynomialArray2[n].leadingMonomial();
                if (entry == null) continue;
                genPolynomialArray2[n3] = genPolynomialArray2[n];
                expVectorArray2[n3] = entry.getKey();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            for (ExpVector expVector : genPolynomial.getMap().keySet()) {
                for (n = 0; n < n2; ++n) {
                    bl = expVector.multipleOf(expVectorArray2[n]);
                    if (!bl) continue;
                    return false;
                }
            }
            return true;
        }
    }

    @Override
    public boolean isNormalform(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        LinkedList<GenPolynomial<C>> linkedList = new LinkedList<GenPolynomial<C>>(list);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            GenPolynomial genPolynomial = (GenPolynomial)linkedList.remove(i);
            if (!this.isNormalform(linkedList, genPolynomial)) {
                return false;
            }
            linkedList.add(genPolynomial);
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.length() == 0) continue;
            if ((genPolynomial = genPolynomial.monic()).isONE()) {
                arrayList.clear();
                arrayList.add(genPolynomial);
                return arrayList;
            }
            arrayList.add(genPolynomial);
        }
        int n = arrayList.size();
        if (n <= 1) {
            return arrayList;
        }
        int n2 = 0;
        logger.debug((Object)"irr = ");
        while (n2 != n) {
            GenPolynomial<C> genPolynomial = arrayList.remove(0);
            ExpVector expVector = genPolynomial.leadingExpVector();
            genPolynomial = this.normalform(arrayList, genPolynomial);
            logger.debug((Object)String.valueOf(n2));
            if (genPolynomial.length() == 0) {
                if (--n > 1) continue;
                return arrayList;
            }
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            if (expVector2.signum() == 0) {
                arrayList = new ArrayList();
                arrayList.add(genPolynomial.monic());
                return arrayList;
            }
            if (expVector.equals(expVector2)) {
                ++n2;
            } else {
                n2 = 0;
                genPolynomial = genPolynomial.monic();
            }
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isReductionNF(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        GenPolynomial<Object> genPolynomial3;
        int n;
        if (list == null && list2 == null) {
            if (genPolynomial == null) {
                return genPolynomial2 == null;
            }
            return genPolynomial.equals(genPolynomial2);
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial4 = genPolynomial2;
        for (n = 0; n < list2.size(); n += 1) {
            genPolynomial3 = list.get(n);
            GenPolynomial<C> genPolynomial5 = list2.get(n);
            if (genPolynomial3 == null || genPolynomial5 == null) continue;
            genPolynomial4 = genPolynomial4 == null ? genPolynomial3.multiply((Object)genPolynomial5) : genPolynomial4.sum((GenPolynomial<Object>)genPolynomial3.multiply((Object)genPolynomial5));
        }
        if (genPolynomial4 == null) {
            if (genPolynomial == null) {
                return true;
            }
            return genPolynomial.isZERO();
        }
        genPolynomial3 = genPolynomial4.subtract((GenPolynomial<Object>)genPolynomial);
        n = genPolynomial3.isZERO() ? 1 : 0;
        if (!n) {
            logger.info((Object)("t = " + genPolynomial4));
            logger.info((Object)("a = " + genPolynomial));
            logger.info((Object)("t-a = " + genPolynomial3));
        }
        return n != 0;
    }
}

