/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.QuotSolvablePolynomial;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class QuotSolvablePolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<SolvableQuotient<C>> {
    public final RecSolvablePolynomialRing<C> polCoeff;
    public final QuotSolvablePolynomial<C> ZERO;
    public final QuotSolvablePolynomial<C> ONE;
    private static final Logger logger = Logger.getLogger(QuotSolvablePolynomialRing.class);

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n, RelationTable<SolvableQuotient<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n, TermOrder termOrder, RelationTable<SolvableQuotient<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<SolvableQuotient<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        SolvableQuotient solvableQuotient;
        SolvableQuotientRing solvableQuotientRing = (SolvableQuotientRing)ringFactory;
        this.polCoeff = new RecSolvablePolynomialRing(solvableQuotientRing.ring, n, termOrder, stringArray);
        if (this.table.size() > 0) {
            solvableQuotient = null;
            ExpVector expVector = null;
            GenSolvablePolynomial genSolvablePolynomial = null;
            this.polCoeff.table.update((ExpVector)((Object)solvableQuotient), expVector, genSolvablePolynomial);
        }
        this.ZERO = new QuotSolvablePolynomial(this);
        solvableQuotient = (SolvableQuotient)this.coFac.getONE();
        this.ONE = new QuotSolvablePolynomial(this, solvableQuotient, this.evzero);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, GenSolvablePolynomialRing genSolvablePolynomialRing) {
        this(ringFactory, genSolvablePolynomialRing.nvar, genSolvablePolynomialRing.tord, genSolvablePolynomialRing.getVars(), (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> ringFactory, QuotSolvablePolynomialRing quotSolvablePolynomialRing) {
        this(ringFactory, (GenSolvablePolynomialRing)quotSolvablePolynomialRing);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = PrettyPrint.isTrue() ? string + "\n" + this.polCoeff.coeffTable.toString(this.vars) : string + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return string;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            string2 = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            string2 = "PolyRing.grad";
        }
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            string = this.polCoeff.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QuotSolvablePolynomialRing)) {
            return false;
        }
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = (QuotSolvablePolynomialRing)object;
        if (!super.equals(object)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(quotSolvablePolynomialRing.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.polCoeff.coeffTable.hashCode();
        return n;
    }

    @Override
    public QuotSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public QuotSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QuotSolvablePolynomial quotSolvablePolynomial = (QuotSolvablePolynomial)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                QuotSolvablePolynomial quotSolvablePolynomial2 = (QuotSolvablePolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    QuotSolvablePolynomial quotSolvablePolynomial3;
                    QuotSolvablePolynomial quotSolvablePolynomial4 = (QuotSolvablePolynomial)list.get(k);
                    QuotSolvablePolynomial quotSolvablePolynomial5 = quotSolvablePolynomial4.multiply(quotSolvablePolynomial2).multiply(quotSolvablePolynomial);
                    if (quotSolvablePolynomial5.equals(quotSolvablePolynomial3 = quotSolvablePolynomial4.multiply(quotSolvablePolynomial2.multiply(quotSolvablePolynomial)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Xk = " + quotSolvablePolynomial4 + ", Xj = " + quotSolvablePolynomial2 + ", Xi = " + quotSolvablePolynomial));
                        logger.info((Object)("p = ( Xk * Xj ) * Xi = " + quotSolvablePolynomial5));
                        logger.info((Object)("q = Xk * ( Xj * Xi ) = " + quotSolvablePolynomial3));
                        logger.info((Object)("q-p = " + quotSolvablePolynomial5.subtract(quotSolvablePolynomial3)));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public QuotSolvablePolynomial<C> fromInteger(long l) {
        return new QuotSolvablePolynomial(this, (SolvableQuotient)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public QuotSolvablePolynomial<C> fromInteger(BigInteger bigInteger) {
        return new QuotSolvablePolynomial(this, (SolvableQuotient)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.EVRAND(this.nvar, n3, f, random);
            SolvableQuotient solvableQuotient = (SolvableQuotient)this.coFac.random(n, random);
            genSolvablePolynomial = (QuotSolvablePolynomial)genSolvablePolynomial.sum(solvableQuotient, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public QuotSolvablePolynomial<C> copy(QuotSolvablePolynomial<C> quotSolvablePolynomial) {
        return new QuotSolvablePolynomial(this, quotSolvablePolynomial.getMap());
    }

    @Override
    public QuotSolvablePolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public QuotSolvablePolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        QuotSolvablePolynomial quotSolvablePolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            quotSolvablePolynomial = new QuotSolvablePolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error((Object)(iOException.toString() + " parse " + this));
            quotSolvablePolynomial = this.ZERO;
        }
        return quotSolvablePolynomial;
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int n) {
        return (QuotSolvablePolynomial)super.univariate(n);
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int n, long l) {
        return (QuotSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int n, int n2, long l) {
        return (QuotSolvablePolynomial)super.univariate(n, n2, l);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList() {
        return this.univariateList(0, 1L);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList(int n) {
        return this.univariateList(n, 1L);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList(int n, long l) {
        ArrayList<QuotSolvablePolynomial<C>> arrayList = new ArrayList<QuotSolvablePolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((QuotSolvablePolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public QuotSolvablePolynomialRing<C> extend(int n) {
        GenPolynomialRing genPolynomialRing = super.extend(n);
        QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing = new QuotSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        quotSolvablePolynomialRing.table.extend(this.table);
        quotSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return quotSolvablePolynomialRing;
    }

    @Override
    public QuotSolvablePolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing = new QuotSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        quotSolvablePolynomialRing.table.contract(this.table);
        quotSolvablePolynomialRing.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return quotSolvablePolynomialRing;
    }

    @Override
    public QuotSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public QuotSolvablePolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing = new QuotSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        quotSolvablePolynomialRing.partial = bl;
        quotSolvablePolynomialRing.table.reverse(this.table);
        quotSolvablePolynomialRing.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return quotSolvablePolynomialRing;
    }

    public QuotSolvablePolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial2 = ((QuotSolvablePolynomial)this.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        RingFactory ringFactory = this.coFac;
        SolvableQuotientRing solvableQuotientRing = (SolvableQuotientRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)entry.getValue();
            SolvableQuotient solvableQuotient = new SolvableQuotient(solvableQuotientRing, genSolvablePolynomial3);
            if (solvableQuotient.isZERO()) continue;
            genSolvablePolynomial2.doPutToMap(expVector, solvableQuotient);
        }
        return genSolvablePolynomial2;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(QuotSolvablePolynomial<C> quotSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (quotSolvablePolynomial == null || quotSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry entry : quotSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableQuotient solvableQuotient = (SolvableQuotient)entry.getValue();
            if (!solvableQuotient.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + solvableQuotient);
            }
            GenSolvablePolynomial genSolvablePolynomial2 = solvableQuotient.num;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(GenPolynomial<SolvableQuotient<C>> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry<ExpVector, SolvableQuotient<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableQuotient<C> solvableQuotient = entry.getValue();
            if (!solvableQuotient.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + solvableQuotient);
            }
            GenSolvablePolynomial genSolvablePolynomial2 = solvableQuotient.num;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }
}

