/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNotInvertibleException;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;

public class AlgebraicNumber<C extends RingElem<C>>
implements GcdRingElem<AlgebraicNumber<C>> {
    public final AlgebraicNumberRing<C> ring;
    public final GenPolynomial<C> val;
    protected int isunit = -1;

    public AlgebraicNumber(AlgebraicNumberRing<C> algebraicNumberRing, GenPolynomial<C> genPolynomial) {
        this.ring = algebraicNumberRing;
        this.val = genPolynomial.remainder(this.ring.modul);
        if (this.val.isZERO()) {
            this.isunit = 0;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
        }
    }

    public AlgebraicNumber(AlgebraicNumberRing<C> algebraicNumberRing) {
        this(algebraicNumberRing, (GenPolynomial<C>)algebraicNumberRing.ring.getZERO());
    }

    public GenPolynomial<C> getVal() {
        return this.val;
    }

    @Override
    public AlgebraicNumberRing<C> factory() {
        return this.ring;
    }

    @Override
    public AlgebraicNumber<C> copy() {
        return new AlgebraicNumber<C>(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(this.ring.ring.getZERO());
    }

    @Override
    public boolean isONE() {
        return this.val.equals(this.ring.ring.getONE());
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return false;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return true;
        }
        boolean bl = this.val.gcd(this.ring.modul).isUnit();
        this.isunit = bl ? 1 : 0;
        return bl;
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.vars);
        }
        return "AlgebraicNumber[ " + this.val.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((AlgebraicNumberRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(AlgebraicNumber<C> algebraicNumber) {
        int n = 0;
        if (this.ring.modul != algebraicNumber.ring.modul) {
            n = this.ring.modul.compareTo(algebraicNumber.ring.modul);
        }
        if (n != 0) {
            return n;
        }
        return this.val.compareTo(algebraicNumber.val);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AlgebraicNumber)) {
            return false;
        }
        AlgebraicNumber algebraicNumber = (AlgebraicNumber)object;
        if (!this.ring.equals(algebraicNumber.ring)) {
            return false;
        }
        return 0 == this.compareTo(algebraicNumber);
    }

    @Override
    public int hashCode() {
        return 37 * this.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public AlgebraicNumber<C> abs() {
        return new AlgebraicNumber<C>(this.ring, this.val.abs());
    }

    @Override
    public AlgebraicNumber<C> sum(AlgebraicNumber<C> algebraicNumber) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.sum(algebraicNumber.val));
    }

    @Override
    public AlgebraicNumber<C> sum(GenPolynomial<C> genPolynomial) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.sum(genPolynomial));
    }

    @Override
    public AlgebraicNumber<C> sum(C c) {
        return new AlgebraicNumber<C>(this.ring, this.val.sum(c));
    }

    @Override
    public AlgebraicNumber<C> negate() {
        return new AlgebraicNumber<C>(this.ring, this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public AlgebraicNumber<C> subtract(AlgebraicNumber<C> algebraicNumber) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.subtract(algebraicNumber.val));
    }

    @Override
    public AlgebraicNumber<C> divide(AlgebraicNumber<C> algebraicNumber) {
        return this.multiply((C)algebraicNumber.inverse());
    }

    @Override
    public AlgebraicNumber<C> inverse() {
        try {
            return new AlgebraicNumber<C>(this.ring, this.val.modInverse(this.ring.modul));
        }
        catch (AlgebraicNotInvertibleException algebraicNotInvertibleException) {
            throw algebraicNotInvertibleException;
        }
        catch (NotInvertibleException notInvertibleException) {
            throw new AlgebraicNotInvertibleException(notInvertibleException + ", val = " + this.val + ", modul = " + this.ring.modul + ", gcd = " + this.val.gcd(this.ring.modul), notInvertibleException);
        }
    }

    @Override
    public AlgebraicNumber<C> remainder(AlgebraicNumber<C> algebraicNumber) {
        if (algebraicNumber == null || algebraicNumber.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (algebraicNumber.isONE()) {
            return this.ring.getZERO();
        }
        if (algebraicNumber.isUnit()) {
            return this.ring.getZERO();
        }
        GenPolynomial<C> genPolynomial = this.val.remainder(algebraicNumber.val);
        return new AlgebraicNumber<C>(this.ring, genPolynomial);
    }

    public AlgebraicNumber<C>[] quotientRemainder(AlgebraicNumber<C> algebraicNumber) {
        return new AlgebraicNumber[]{this.divide(algebraicNumber), this.remainder(algebraicNumber)};
    }

    @Override
    public AlgebraicNumber<C> multiply(AlgebraicNumber<C> algebraicNumber) {
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.val.multiply(algebraicNumber.val);
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, genPolynomial);
    }

    @Override
    public AlgebraicNumber<C> multiply(C c) {
        GenPolynomial<C> genPolynomial = this.val.multiply(c);
        return new AlgebraicNumber<C>(this.ring, genPolynomial);
    }

    @Override
    public AlgebraicNumber<C> multiply(GenPolynomial<C> genPolynomial) {
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.val.multiply(genPolynomial);
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, genPolynomial2);
    }

    public AlgebraicNumber<C> monic() {
        return new AlgebraicNumber<C>(this.ring, this.val.monic());
    }

    @Override
    public AlgebraicNumber<C> gcd(AlgebraicNumber<C> algebraicNumber) {
        if (algebraicNumber.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return algebraicNumber;
        }
        if (this.isUnit() || algebraicNumber.isUnit()) {
            return this.ring.getONE();
        }
        return new AlgebraicNumber<C>(this.ring, this.val.gcd(algebraicNumber.val));
    }

    public AlgebraicNumber<C>[] egcd(AlgebraicNumber<C> algebraicNumber) {
        AlgebraicNumber[] algebraicNumberArray = new AlgebraicNumber[]{null, null, null};
        if (algebraicNumber == null || algebraicNumber.isZERO()) {
            algebraicNumberArray[0] = this;
            return algebraicNumberArray;
        }
        if (this.isZERO()) {
            algebraicNumberArray[0] = algebraicNumber;
            return algebraicNumberArray;
        }
        if (this.isUnit() || algebraicNumber.isUnit()) {
            algebraicNumberArray[0] = this.ring.getONE();
            if (this.isUnit() && algebraicNumber.isUnit()) {
                MonoidElem monoidElem = ((AlgebraicNumber)this.ring.fromInteger(2L)).inverse();
                algebraicNumberArray[1] = ((AlgebraicNumber)this.inverse()).multiply((C)monoidElem);
                algebraicNumberArray[2] = ((AlgebraicNumber)algebraicNumber.inverse()).multiply((C)monoidElem);
                return algebraicNumberArray;
            }
            if (this.isUnit()) {
                algebraicNumberArray[1] = this.inverse();
                algebraicNumberArray[2] = this.ring.getZERO();
                return algebraicNumberArray;
            }
            algebraicNumberArray[1] = this.ring.getZERO();
            algebraicNumberArray[2] = algebraicNumber.inverse();
            return algebraicNumberArray;
        }
        GenPolynomial<C> genPolynomial = this.val;
        GenPolynomial<C> genPolynomial2 = algebraicNumber.val;
        MonoidElem<Object> monoidElem = this.ring.ring.getONE();
        GenPolynomial<GenPolynomial<AbelianGroupElem>> genPolynomial3 = this.ring.ring.getZERO();
        AbelianGroupElem<Object> abelianGroupElem = this.ring.ring.getZERO();
        GenPolynomial<GenPolynomial<MonoidElem>> genPolynomial4 = this.ring.ring.getONE();
        while (!genPolynomial2.isZERO()) {
            GenPolynomial<C>[] genPolynomialArray = genPolynomial.quotientRemainder(genPolynomial2);
            genPolynomial = genPolynomialArray[0];
            GenPolynomial<GenPolynomial<AbelianGroupElem>> genPolynomial5 = ((GenPolynomial)monoidElem).subtract(genPolynomial.multiply((C)genPolynomial3));
            GenPolynomial<GenPolynomial<MonoidElem>> genPolynomial6 = ((GenPolynomial)abelianGroupElem).subtract(genPolynomial.multiply((C)genPolynomial4));
            monoidElem = genPolynomial3;
            abelianGroupElem = genPolynomial4;
            genPolynomial3 = genPolynomial5;
            genPolynomial4 = genPolynomial6;
            genPolynomial = genPolynomial2;
            genPolynomial2 = genPolynomialArray[1];
        }
        algebraicNumberArray[0] = new AlgebraicNumber<C>(this.ring, genPolynomial);
        algebraicNumberArray[1] = new AlgebraicNumber<C>(this.ring, monoidElem);
        algebraicNumberArray[2] = new AlgebraicNumber<C>(this.ring, abelianGroupElem);
        return algebraicNumberArray;
    }
}

