/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.arith.BigRational;
import edu.jas.gb.GBOptimized;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gbufd.GBFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class ExamplesGeoTheorems {
    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        ExamplesGeoTheorems.example10();
        ExamplesGeoTheorems.example11();
        ExamplesGeoTheorems.example12();
        ExamplesGeoTheorems.example13();
        ExamplesGeoTheorems.example14();
        ExamplesGeoTheorems.example15();
        ExamplesGeoTheorems.example16();
        ExamplesGeoTheorems.example17();
        ComputerThreads.terminate();
    }

    public static List<GenPolynomial<BigRational>> getExample() {
        String[] stringArray = new String[]{"a1", "a2", "b1", "b2", "c1", "c2", "d1", "d2", "e1", "e2", "f1", "f2", "g1", "g2", "h1", "h2", "i1", "i2", "j1", "j2", "z1", "z2", "z3"};
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        Element element = genPolynomialRing.parse("(a1*(b2 - c2) + a2*( - b1 + c1) + b1*c2 - b2*c1)");
        Element element2 = genPolynomialRing.parse("(d1*(e2 - f2) + d2*( - e1 + f1) + e1*f2 - e2*f1)");
        Element element3 = genPolynomialRing.parse("(a1*( - e2 + h2) + a2*(e1 - h1) - e1*h2 + e2*h1)");
        Element element4 = genPolynomialRing.parse("(b1*(d2 - h2) + b2*( - d1 + h1) + d1*h2 - d2*h1)");
        Element element5 = genPolynomialRing.parse("(c1*(d2 - i2) + c2*( - d1 + i1) + d1*i2 - d2*i1)");
        Element element6 = genPolynomialRing.parse("(a1*( - f2 + i2) + a2*(f1 - i1) - f1*i2 + f2*i1)");
        Element element7 = genPolynomialRing.parse("(c1*(e2 - j2) + c2*( - e1 + j1) + e1*j2 - e2*j1)");
        Element element8 = genPolynomialRing.parse("(b1*( - f2 + j2) + b2*(f1 - j1) - f1*j2 + f2*j1)");
        Element element9 = genPolynomialRing.parse("(a1*(b2*z2 - d2*z2) + a2*( - b1*z2 + d1*z2) + b1*d2*z2 - b2*d1*z2 - 1)");
        Element element10 = genPolynomialRing.parse("(a1*(b2*z3 - e2*z3) + a2*( - b1*z3 + e1*z3) + b1*e2*z3 - b2*e1*z3 - 1)");
        Element element11 = genPolynomialRing.parse("(h1*(i2*z1 - j2*z1) + h2*( - i1*z1 + j1*z1) + i1*j2*z1 - i2*j1*z1 - 1)");
        ArrayList<GenPolynomial<BigRational>> arrayList = new ArrayList<GenPolynomial<BigRational>>(11);
        arrayList.add((GenPolynomial<BigRational>)element);
        arrayList.add((GenPolynomial<BigRational>)element2);
        arrayList.add((GenPolynomial<BigRational>)element3);
        arrayList.add((GenPolynomial<BigRational>)element4);
        arrayList.add((GenPolynomial<BigRational>)element5);
        arrayList.add((GenPolynomial<BigRational>)element6);
        arrayList.add((GenPolynomial<BigRational>)element7);
        arrayList.add((GenPolynomial<BigRational>)element8);
        arrayList.add((GenPolynomial<BigRational>)element9);
        arrayList.add((GenPolynomial<BigRational>)element10);
        arrayList.add((GenPolynomial<BigRational>)element11);
        return arrayList;
    }

    public static void example10() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(gb) = " + l);
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
    }

    public static void example11() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getProxy(bigRational);
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(proxy-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(proxy-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        groebnerBaseAbstract.terminate();
    }

    public static void example12() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        GBOptimized<BigRational> gBOptimized = new GBOptimized<BigRational>(groebnerBaseAbstract, true);
        long l = System.currentTimeMillis();
        List list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        ((GroebnerBaseAbstract)gBOptimized).terminate();
    }

    public static void example13() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getProxy(bigRational);
        GBOptimized<BigRational> gBOptimized = new GBOptimized<BigRational>(groebnerBaseAbstract, true);
        long l = System.currentTimeMillis();
        List list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-proxy-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-proxy-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        ((GroebnerBaseAbstract)gBOptimized).terminate();
    }

    public static void example14() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational, GBFactory.Algo.ffgb);
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(fraction-free-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(fraction-free-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        groebnerBaseAbstract.terminate();
    }

    public static void example15() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational, GBFactory.Algo.ffgb);
        GBOptimized<BigRational> gBOptimized = new GBOptimized<BigRational>(groebnerBaseAbstract, true);
        long l = System.currentTimeMillis();
        List list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-fraction-free-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-fraction-free-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        ((GroebnerBaseAbstract)gBOptimized).terminate();
    }

    public static void example16() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational, GBFactory.Algo.ffgb);
        GBOptimized<BigRational> gBOptimized = new GBOptimized<BigRational>(groebnerBaseAbstract, true);
        GroebnerBaseParallel groebnerBaseParallel = new GroebnerBaseParallel();
        GBOptimized gBOptimized2 = new GBOptimized(groebnerBaseParallel, true);
        GBProxy<BigRational> gBProxy = new GBProxy<BigRational>(gBOptimized, gBOptimized2);
        long l = System.currentTimeMillis();
        List list2 = gBProxy.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(proxy-optimized-fraction-free-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = gBProxy.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(proxy-optimized-fraction-free-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        ((GroebnerBaseAbstract)gBProxy).terminate();
    }

    public static void example17() {
        List list = ExamplesGeoTheorems.getExample();
        BigRational bigRational = new BigRational();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational, GBFactory.Algo.ffgb);
        GroebnerBaseParallel groebnerBaseParallel = new GroebnerBaseParallel();
        GBProxy<BigRational> gBProxy = new GBProxy<BigRational>(groebnerBaseAbstract, groebnerBaseParallel);
        GBOptimized<BigRational> gBOptimized = new GBOptimized<BigRational>(gBProxy, true);
        long l = System.currentTimeMillis();
        List list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-proxy-fraction-free-gb) = " + l);
        l = System.currentTimeMillis();
        list2 = gBOptimized.GB(list);
        l = System.currentTimeMillis() - l;
        System.out.println("time(optimized-proxy-fraction-free-gb) = " + l);
        PolynomialList polynomialList = new PolynomialList(genPolynomialRing, list2);
        Ideal ideal = new Ideal(polynomialList, true);
        System.out.println("cp = " + list);
        System.out.println("id = " + ideal);
        Dimension dimension = ideal.dimension();
        System.out.println("dim = " + dimension);
        ((GroebnerBaseAbstract)gBOptimized).terminate();
    }
}

