/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.OneSubSetIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class KsubSetIterator<E>
implements Iterator<List<E>> {
    public final List<E> set;
    public final int k;
    final List<E> rest;
    private E current;
    private Iterator<List<E>> recIter;
    private final Iterator<E> iter;

    public KsubSetIterator(List<E> list, int n) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("null or empty set not allowed");
        }
        if (n < 2 || n > list.size()) {
            throw new IllegalArgumentException("k out of range");
        }
        this.set = list;
        this.k = n;
        this.iter = this.set.iterator();
        this.current = this.iter.next();
        this.rest = new LinkedList<E>(this.set);
        this.rest.remove(0);
        this.recIter = n == 2 ? new OneSubSetIterator<E>(this.rest) : new KsubSetIterator<E>(this.rest, n - 1);
    }

    @Override
    public boolean hasNext() {
        return this.recIter.hasNext() || this.iter.hasNext() && this.rest.size() >= this.k;
    }

    @Override
    public List<E> next() {
        if (this.recIter.hasNext()) {
            LinkedList<E> linkedList = new LinkedList<E>(this.recIter.next());
            linkedList.add(0, this.current);
            return linkedList;
        }
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
            this.rest.remove(0);
            if (this.rest.size() < this.k - 1) {
                throw new NoSuchElementException("invalid call of next()");
            }
            this.recIter = this.k == 2 ? new OneSubSetIterator<E>(this.rest) : new KsubSetIterator<E>(this.rest, this.k - 1);
            return this.next();
        }
        throw new NoSuchElementException("invalid call of next()");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove subsets");
    }
}

