/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.RecSolvableWordPolynomial;
import edu.jas.poly.RecSolvableWordPolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.poly.Word;
import edu.jas.structure.Element;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RecSolvableWordPolynomialTest
extends TestCase {
    RecSolvableWordPolynomial<BigRational> a;
    RecSolvableWordPolynomial<BigRational> b;
    RecSolvableWordPolynomial<BigRational> c;
    RecSolvableWordPolynomial<BigRational> d;
    RecSolvableWordPolynomial<BigRational> e;
    RecSolvableWordPolynomial<BigRational> f;
    RecSolvableWordPolynomial<BigRational> x1;
    RecSolvableWordPolynomial<BigRational> x2;
    int rl = 4;
    int kl = 5;
    int ll = 4;
    int el = 3;
    float q = 0.3f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    RelationTable<GenWordPolynomial<BigRational>> table;
    RecSolvableWordPolynomialRing<BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<GenWordPolynomial<BigRational>> sring;
    GenWordPolynomialRing<BigRational> cring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RecSolvableWordPolynomialTest.suite());
    }

    public RecSolvableWordPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RecSolvableWordPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenWordPolynomialRing<BigRational>(this.cfac, this.cvars);
        this.ring = new RecSolvableWordPolynomialRing(this.cring, this.tord, this.vars);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        RecSolvableWordPolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        RecSolvableWordPolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new RecSolvableWordPolynomial<BigRational>(this.ring);
        RecSolvableWordPolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        RecSolvableWordPolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        RecSolvableWordPolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        RecSolvableWordPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RecSolvableWordPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RecSolvableWordPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        RecSolvableWordPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RecSolvableWordPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RecSolvableWordPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            RecSolvableWordPolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            RecSolvableWordPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RecSolvableWordPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RecSolvableWordPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (RecSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.a));
        RecSolvableWordPolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (RecSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (RecSolvableWordPolynomial)this.b.subtract((BigRational)((Object)this.a));
        RecSolvableWordPolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (RecSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (RecSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b));
        RecSolvableWordPolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (RecSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (RecSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        RecSolvableWordPolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        Element element = this.cring.random(this.kl);
        this.b = ((RecSolvableWordPolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (RecSolvableWordPolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (RecSolvableWordPolynomial)this.a.sum((BigRational)element, expVector);
        RecSolvableWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (RecSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (RecSolvableWordPolynomial)this.a.subtract((BigRational)element, expVector);
        RecSolvableWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((RecSolvableWordPolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (RecSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (RecSolvableWordPolynomial)this.a.sum((BigRational)element, expVector);
        RecSolvableWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (RecSolvableWordPolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (RecSolvableWordPolynomial)this.a.subtract((BigRational)element, expVector);
        RecSolvableWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvableWordPolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        RecSolvableWordPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        BigRational bigRational = ((BigRational)((GenWordPolynomial)this.a.leadingBaseCoefficient()).leadingBaseCoefficient()).inverse();
        GenWordPolynomial<BigRational> genWordPolynomial = new GenWordPolynomial<BigRational>(this.cring, bigRational);
        this.d = (RecSolvableWordPolynomial)this.a.multiply(genWordPolynomial);
        RecSolvableWordPolynomialTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((BigRational)((GenWordPolynomial)this.d.leadingBaseCoefficient()).leadingBaseCoefficient()).isONE());
        this.d = (RecSolvableWordPolynomial)this.a.monic();
        RecSolvableWordPolynomialTest.assertTrue((String)"a.monic(): ", (((GenWordPolynomial)this.d.leadingBaseCoefficient()).isONE() || ((GenWordPolynomial)this.d.leadingBaseCoefficient()).equals(this.a.leadingBaseCoefficient()) ? 1 : 0) != 0);
    }

    public void testCommutative() {
        RecSolvableWordPolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.cring = new GenWordPolynomialRing<BigRational>(this.cfac, new String[]{"a"});
        this.ring = new RecSolvableWordPolynomialRing(this.cring, this.ring);
        RecSolvableWordPolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RecSolvableWordPolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvableWordPolynomialTest.assertEquals((String)"ba == ab: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((RecSolvableWordPolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (RecSolvableWordPolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        RecSolvableWordPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testWordCoeffs() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.ring.parse("b").leadingBaseCoefficient();
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("b x + a");
        this.ring.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genWordPolynomial.leadingWord().leadingExpVector(), genSolvablePolynomial2);
        RecSolvableWordPolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RecSolvableWordPolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial;
            this.a = new RecSolvableWordPolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial2 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial2;
                this.b = new RecSolvableWordPolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                RecSolvableWordPolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
                Word word = ((GenWordPolynomial)this.a.leadingBaseCoefficient()).leadingWord().multiply(((GenWordPolynomial)this.b.leadingBaseCoefficient()).leadingWord());
                RecSolvableWordPolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)((GenWordPolynomial)this.c.leadingBaseCoefficient()).leadingWord().equals(word));
            }
        }
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvableWordPolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        RecSolvableWordPolynomialRing recSolvableWordPolynomialRing = new RecSolvableWordPolynomialRing(this.ring.coFac, this.ring);
        recSolvableWordPolynomialRing.table.addSolvRelations(this.ring.table.relationList());
        recSolvableWordPolynomialRing.coeffTable.addSolvRelations(this.ring.coeffTable.relationList());
        RecSolvableWordPolynomialTest.assertEquals((String)"ring.table == ring2.table: ", (Object)this.ring.table, (Object)recSolvableWordPolynomialRing.table);
        RecSolvableWordPolynomialTest.assertEquals((String)"ring.coeffTable == ring2.coeffTable: ", this.ring.coeffTable, recSolvableWordPolynomialRing.coeffTable);
    }
}

