/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigQuaternion;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.WeylRelations;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class QuatGenSolvablePolynomialTest
extends TestCase {
    BigQuaternion cfac;
    GenSolvablePolynomialRing<BigQuaternion> fac;
    GenSolvablePolynomial<BigQuaternion> a;
    GenSolvablePolynomial<BigQuaternion> b;
    GenSolvablePolynomial<BigQuaternion> c;
    GenSolvablePolynomial<BigQuaternion> d;
    GenSolvablePolynomial<BigQuaternion> e;
    int rl = 6;
    int kl = 3;
    int ll = 7;
    int el = 5;
    float q = 0.33f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)QuatGenSolvablePolynomialTest.suite());
    }

    public QuatGenSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuatGenSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigQuaternion(1L);
        this.fac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfac, this.rl);
        WeylRelations<BigQuaternion> weylRelations = new WeylRelations<BigQuaternion>();
        weylRelations.generate(this.fac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.cfac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        QuatGenSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuatGenSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        QuatGenSolvablePolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuatGenSolvablePolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuatGenSolvablePolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testFactory() {
        QuatGenSolvablePolynomialTest.assertFalse((String)"!is comutative", (boolean)this.fac.isCommutative());
        QuatGenSolvablePolynomialTest.assertFalse((String)"!is field", (boolean)this.fac.isField());
        QuatGenSolvablePolynomialTest.assertTrue((String)"is associative", (boolean)this.fac.isAssociative());
        List list = this.fac.generators();
        QuatGenSolvablePolynomialTest.assertTrue((String)"#gens = 4+6 ", (list.size() == 10 ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.fac.random(this.kl, this.ll + i, this.el + (5 - i), this.q);
            QuatGenSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuatGenSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuatGenSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = (GenSolvablePolynomial)this.a.sum((BigQuaternion)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.c.subtract((BigQuaternion)((Object)this.b));
        QuatGenSolvablePolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigQuaternion bigQuaternion = BigQuaternion.QRAND(this.kl);
        this.b = new GenSolvablePolynomial<BigQuaternion>(this.fac, bigQuaternion, expVector);
        this.c = (GenSolvablePolynomial)this.a.sum((BigQuaternion)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.sum(bigQuaternion, expVector);
        QuatGenSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (GenSolvablePolynomial)this.a.subtract((BigQuaternion)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.subtract(bigQuaternion, expVector);
        QuatGenSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenSolvablePolynomial<BigQuaternion>(this.fac);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a == 0", (boolean)this.a.isZERO());
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        QuatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        QuatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigQuaternion)((Object)this.a));
        this.d = this.a.multiply((BigQuaternion)((Object)this.b));
        QuatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((BigQuaternion)((Object)this.c));
        QuatGenSolvablePolynomialTest.assertTrue((String)("!isZERO( a*b-b*a ) " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a*b = b*a", (!this.c.equals(this.d) ? 1 : 0) != 0);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigQuaternion)((Object)this.b.multiply((BigQuaternion)((Object)this.c))));
        this.e = this.a.multiply((BigQuaternion)((Object)this.b)).multiply(this.c);
        QuatGenSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigQuaternion bigQuaternion = ((BigQuaternion)this.a.leadingBaseCoefficient()).inverse();
        this.c = this.a.monic();
        this.d = this.a.multiplyLeft(bigQuaternion);
        QuatGenSolvablePolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigQuaternion bigQuaternion2 = ((BigQuaternion)this.b.leadingBaseCoefficient()).inverse();
        this.c = this.b.monic();
        this.d = this.b.multiplyLeft(bigQuaternion2);
        QuatGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenSolvablePolynomial<BigQuaternion>(this.fac, bigQuaternion2);
        this.d = this.e.multiply((BigQuaternion)((Object)this.b));
        QuatGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
    }

    public void testDoubleMultiplication() {
        this.a = this.fac.random(this.kl, 3, this.el, this.q);
        this.b = this.fac.random(this.kl, 2, this.el, this.q);
        this.c = this.fac.random(this.kl, 3, this.el, this.q);
        this.d = this.a.multiply((BigQuaternion)((Object)this.b)).multiply(this.c);
        this.e = this.b.multiply((BigQuaternion)((Object)this.a), (BigQuaternion)((Object)this.c));
        QuatGenSolvablePolynomialTest.assertEquals((String)"a b c = b.multiply(a,c)", this.d, this.e);
        BigQuaternion bigQuaternion = this.cfac.random(this.kl);
        BigQuaternion bigQuaternion2 = this.cfac.random(this.kl);
        BigQuaternion bigQuaternion3 = bigQuaternion.multiply(bigQuaternion2);
        BigQuaternion bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion);
        while (bigQuaternion3.equals(bigQuaternion4)) {
            bigQuaternion = this.cfac.random(this.kl);
            bigQuaternion2 = this.cfac.random(this.kl);
            bigQuaternion3 = bigQuaternion.multiply(bigQuaternion2);
            bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion);
        }
        this.a = this.fac.univariate(0);
        this.d = this.a.multiply(bigQuaternion, bigQuaternion2);
        this.e = this.a.multiply(bigQuaternion2, bigQuaternion);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a.multiply(qa,qb) != a.multiply(qb,qq)", (this.d.equals(this.e) || this.d.leadingExpVector().equals(this.e.leadingExpVector()) ? 1 : 0) != 0);
        ExpVector expVector = this.fac.univariate(1).leadingExpVector();
        ExpVector expVector2 = this.fac.univariate(2).leadingExpVector();
        this.d = this.a.multiply((BigQuaternion)((Object)expVector), expVector2);
        this.e = this.a.multiply((BigQuaternion)((Object)expVector2), expVector);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a.multiply(ea,eb) == a.multiply(eb,eq)", (boolean)this.d.equals(this.e));
        this.d = this.a.multiply(bigQuaternion, expVector, bigQuaternion2, expVector2);
        this.e = this.a.multiply(bigQuaternion2, expVector2, bigQuaternion, expVector);
        QuatGenSolvablePolynomialTest.assertTrue((String)"a.multiply(qa,ea,qb,eb) != a.multiply(qb,eb,qa,ea)", (this.d.equals(this.e) || this.d.leadingExpVector().equals(this.e.leadingExpVector()) ? 1 : 0) != 0);
    }
}

