/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OrderedModuleList<C extends RingElem<C>>
extends ModuleList<C> {
    public OrderedModuleList(GenPolynomialRing<C> genPolynomialRing, List<List<GenPolynomial<C>>> list) {
        super(genPolynomialRing, OrderedModuleList.sort(genPolynomialRing, ModuleList.padCols(genPolynomialRing, list)));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        OrderedModuleList orderedModuleList = null;
        try {
            orderedModuleList = (OrderedModuleList)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return orderedModuleList != null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> sort(GenPolynomialRing<C> genPolynomialRing, List<List<GenPolynomial<C>>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() <= 1) {
            return list;
        }
        final TermOrder.EVComparator eVComparator = genPolynomialRing.tord.getAscendComparator();
        Comparator comparator = new Comparator<List<GenPolynomial<C>>>(){

            @Override
            public int compare(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
                int n = 0;
                for (int i = 0; i < list.size(); ++i) {
                    ExpVector expVector;
                    GenPolynomial genPolynomial = list.get(i);
                    GenPolynomial genPolynomial2 = list2.get(i);
                    ExpVector expVector2 = genPolynomial.leadingExpVector();
                    if (expVector2 == (expVector = genPolynomial2.leadingExpVector())) continue;
                    if (expVector2 == null && expVector != null) {
                        return -1;
                    }
                    if (expVector2 != null && expVector == null) {
                        return 1;
                    }
                    if (expVector2 == null || expVector == null) continue;
                    if (expVector2.length() != expVector.length()) {
                        if (expVector2.length() > expVector.length()) {
                            return 1;
                        }
                        return -1;
                    }
                    n = eVComparator.compare(expVector2, expVector);
                    if (n == 0) continue;
                    return n;
                }
                return n;
            }
        };
        List[] listArray = null;
        try {
            listArray = new List[list.size()];
            int n = 0;
            for (List<GenPolynomial<C>> list2 : list) {
                listArray[n++] = list2;
            }
            Arrays.sort(listArray, comparator);
            return new ArrayList<List<GenPolynomial<C>>>(Arrays.asList(listArray));
        }
        catch (ClassCastException classCastException) {
            System.out.println("Warning: polynomials not sorted");
            return list;
        }
    }
}

