/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.WordReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Overlap;
import edu.jas.poly.OverlapList;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class WordReductionTest
extends TestCase {
    GenWordPolynomialRing<BigRational> fac;
    WordFactory wfac;
    BigRational cfac;
    GenWordPolynomial<BigRational> a;
    GenWordPolynomial<BigRational> b;
    GenWordPolynomial<BigRational> c;
    GenWordPolynomial<BigRational> d;
    GenWordPolynomial<BigRational> e;
    List<GenWordPolynomial<BigRational>> L;
    WordReductionSeq<BigRational> red;
    int kl = 3;
    int ll = 7;
    int el = 5;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)WordReductionTest.suite());
    }

    public WordReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigRational(0L);
        this.wfac = new WordFactory("abcdef");
        this.fac = new GenWordPolynomialRing<BigRational>(this.cfac, this.wfac);
        this.red = new WordReductionSeq();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.red = null;
    }

    public void testRatReduction0() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.red.normalform(this.L, this.c);
        WordReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.red.normalform(this.L, this.c);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.a);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.d);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.red.normalform(this.L, this.c);
        WordReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReduction() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el);
        } while (this.b.isZERO());
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.red.normalform(this.L, this.a);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.b);
        this.e = this.red.normalform(this.L, this.a);
        WordReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        WordReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.red.isTopReducible(this.L, this.a));
        WordReductionTest.assertTrue((String)"isRed( a )", (boolean)this.red.isReducible(this.L, this.a));
        this.L.add(this.b);
        WordReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.red.isTopReducible(this.L, this.b));
        WordReductionTest.assertTrue((String)"isRed( b )", (boolean)this.red.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.e = this.red.normalform(this.L, this.c);
        WordReductionTest.assertTrue((String)"isNF( e )", (boolean)this.red.isNormalform(this.L, this.e));
        Word word = new Word(this.wfac, "f");
        Word word2 = new Word(this.wfac, "abc");
        this.c = this.a.multiply(this.cfac.getONE(), word, word2);
        this.e = this.red.normalform(this.L, this.c);
        WordReductionTest.assertTrue((String)"isNF( e )", (boolean)this.red.isNormalform(this.L, this.e));
        WordReductionTest.assertTrue((String)"e == 0", (boolean)this.e.isZERO());
    }

    public void testRatReductionRecording() {
        int n;
        ArrayList arrayList = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el);
        } while (this.b.isZERO());
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.fac.random(this.kl, this.ll, this.el);
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        ArrayList arrayList2 = new ArrayList(this.L.size());
        arrayList = new ArrayList(this.L.size());
        this.e = this.fac.getZERO();
        for (n = 0; n < this.L.size(); ++n) {
            arrayList2.add(this.e);
            arrayList.add(this.e);
        }
        this.e = this.red.normalform(arrayList2, arrayList, this.L, this.a);
        WordReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        WordReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList2, arrayList, this.L, this.a, this.e));
        this.L.add(this.b);
        arrayList2 = new ArrayList(this.L.size());
        arrayList = new ArrayList(this.L.size());
        this.e = this.fac.getZERO();
        for (n = 0; n < this.L.size(); ++n) {
            arrayList2.add(this.e);
            arrayList.add(this.e);
        }
        this.e = this.red.normalform(arrayList2, arrayList, this.L, this.b);
        WordReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList2, arrayList, this.L, this.b, this.e));
        this.L.add(this.c);
        arrayList2 = new ArrayList(this.L.size());
        arrayList = new ArrayList(this.L.size());
        this.e = this.fac.getZERO();
        for (n = 0; n < this.L.size(); ++n) {
            arrayList2.add(this.e);
            arrayList.add(this.e);
        }
        this.e = this.red.normalform(arrayList2, arrayList, this.L, this.c);
        WordReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList2, arrayList, this.L, this.c, this.e));
        this.L.add(this.d);
        arrayList2 = new ArrayList(this.L.size());
        arrayList = new ArrayList(this.L.size());
        this.e = this.fac.getZERO();
        for (n = 0; n < this.L.size(); ++n) {
            arrayList2.add(this.e);
            arrayList.add(this.e);
        }
        Word word = new Word(this.wfac, "f");
        Word word2 = new Word(this.wfac, "abc");
        this.d = this.a.multiply(this.cfac.random(3), word, word2);
        this.e = this.red.normalform(arrayList2, arrayList, this.L, this.d);
        WordReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList2, arrayList, this.L, this.d, this.e));
    }

    public void testRatSpolynomial() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el);
        } while (this.b.isZERO());
        Word word = new Word(this.wfac, "a");
        this.a = this.a.multiply(this.wfac.getONE(), word);
        this.b = this.b.multiply(word, this.wfac.getONE());
        Word word2 = this.a.leadingWord();
        Word word3 = this.b.leadingWord();
        List<GenWordPolynomial<BigRational>> list = this.red.SPolynomials(this.a, this.b);
        OverlapList overlapList = word2.overlap(word3);
        for (GenWordPolynomial<BigRational> genWordPolynomial : list) {
            Word word4 = genWordPolynomial.leadingWord();
            boolean bl = false;
            Word word5 = this.fac.alphabet.getONE();
            for (Overlap overlap : overlapList.ols) {
                word5 = overlap.l1.multiply(word2).multiply(overlap.r1);
                if (this.fac.alphabet.getAscendComparator().compare(word5, word4) <= 0) continue;
                bl = true;
                break;
            }
            WordReductionTest.assertTrue((String)("ce > ee: " + word5 + " > " + word4), (boolean)bl);
        }
    }
}

