/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorQuotientTest
extends TestCase {
    int rl = 1;
    int kl = 3;
    int ll = 3;
    int el = 3;
    float q = 0.4f;
    QuotientRing<BigRational> efac;
    GenPolynomialRing<BigRational> mfac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorQuotientTest.suite());
    }

    public FactorQuotientTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorQuotientTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(1L);
        TermOrder termOrder = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigRational>(bigRational, this.rl, termOrder);
        this.efac = new QuotientRing<BigRational>(this.mfac);
    }

    protected void tearDown() {
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void xtestDummy() {
    }

    public void testQuotientFactorization() {
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(this.efac, 1, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        FactorAbstract<Quotient<BigRational>> factorAbstract = FactorFactory.getImplementation(this.efac);
        SortedMap sortedMap = factorAbstract.factors(genPolynomial);
        FactorQuotientTest.assertTrue((String)"#facs >= 1", (sortedMap.size() >= 1 ? 1 : 0) != 0);
        boolean bl = factorAbstract.isFactorization(genPolynomial, sortedMap);
        FactorQuotientTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }
}

