/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Residue;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class ResidueRing<C extends RingElem<C>>
implements RingFactory<Residue<C>> {
    private static final Logger logger = Logger.getLogger(ResidueRing.class);
    protected final C modul;
    protected final RingFactory<C> ring;
    protected int isField = -1;

    public ResidueRing(RingFactory<C> ringFactory, C object) {
        this.ring = ringFactory;
        if (object.isZERO()) {
            throw new IllegalArgumentException("modul may not be null");
        }
        if (object.isONE()) {
            logger.warn((Object)"modul is one");
        }
        if (object.signum() < 0) {
            object = (RingElem)object.negate();
        }
        this.modul = object;
    }

    @Override
    public boolean isFinite() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Residue<C> copy(Residue<C> residue) {
        return new Residue(residue.ring, residue.val);
    }

    @Override
    public Residue<C> getZERO() {
        return new Residue<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Residue<C> getONE() {
        Residue<RingElem> residue = new Residue<RingElem>(this, (RingElem)this.ring.getONE());
        if (residue.isZERO()) {
            logger.warn((Object)"one is zero, so all residues are 0");
        }
        return residue;
    }

    @Override
    public List<Residue<C>> generators() {
        List list = this.ring.generators();
        ArrayList<Residue<C>> arrayList = new ArrayList<Residue<C>>(list.size());
        for (RingElem ringElem : list) {
            arrayList.add(new Residue<RingElem>(this, ringElem));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Residue<C> fromInteger(BigInteger bigInteger) {
        return new Residue<RingElem>(this, (RingElem)this.ring.fromInteger(bigInteger));
    }

    @Override
    public Residue<C> fromInteger(long l) {
        return new Residue<RingElem>(this, (RingElem)this.ring.fromInteger(l));
    }

    public String toString() {
        return "Residue[ " + this.modul.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "ResidueRing(" + this.modul.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ResidueRing)) {
            return false;
        }
        ResidueRing residueRing = (ResidueRing)object;
        if (!this.ring.equals(residueRing.ring)) {
            return false;
        }
        return this.modul.equals(residueRing.modul);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.modul.hashCode();
        return n;
    }

    @Override
    public Residue<C> random(int n) {
        RingElem ringElem = (RingElem)this.ring.random(n);
        return new Residue<RingElem>(this, ringElem);
    }

    @Override
    public Residue<C> random(int n, Random random) {
        RingElem ringElem = (RingElem)this.ring.random(n, random);
        return new Residue<RingElem>(this, ringElem);
    }

    @Override
    public Residue<C> parse(String string) {
        RingElem ringElem = (RingElem)this.ring.parse(string);
        return new Residue<RingElem>(this, ringElem);
    }

    @Override
    public Residue<C> parse(Reader reader) {
        RingElem ringElem = (RingElem)this.ring.parse(reader);
        return new Residue<RingElem>(this, ringElem);
    }
}

