/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.Pair;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedPairlist<C extends RingElem<C>> {
    protected final ArrayList<MultiVarPowerSeries<C>> P;
    protected final TreeMap<ExpVector, LinkedList<Pair<C>>> pairlist;
    protected final ArrayList<BitSet> red;
    protected final MultiVarPowerSeriesRing<C> ring;
    protected final ReductionSeq<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = true;
    protected boolean useCriterion3 = true;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;
    private static final Logger logger = Logger.getLogger(OrderedPairlist.class);

    public OrderedPairlist(MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing) {
        this(0, multiVarPowerSeriesRing);
    }

    public OrderedPairlist(int n, MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing) {
        this.moduleVars = n;
        this.ring = multiVarPowerSeriesRing;
        this.P = new ArrayList();
        this.pairlist = new TreeMap(this.ring.polyRing().tord.getAscendComparator());
        this.red = new ArrayList();
        this.putCount = 0;
        this.remCount = 0;
        this.reduction = new ReductionSeq();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("OrderedPairlist(");
        stringBuffer.append("#put=" + this.putCount);
        stringBuffer.append(", #rem=" + this.remCount);
        if (this.pairlist.size() != 0) {
            stringBuffer.append(", size=" + this.pairlist.size());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public synchronized int put(MultiVarPowerSeries<C> multiVarPowerSeries) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector expVector = multiVarPowerSeries.orderExpVector();
        int n = this.P.size();
        for (int i = 0; i < n; ++i) {
            MultiVarPowerSeries<C> multiVarPowerSeries2 = this.P.get(i);
            ExpVector expVector2 = multiVarPowerSeries2.orderExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, expVector, expVector2)) continue;
            ExpVector expVector3 = expVector.lcm(expVector2);
            Pair<C> pair = new Pair<C>(multiVarPowerSeries2, multiVarPowerSeries, i, n);
            LinkedList<Pair<Object>> linkedList = this.pairlist.get(expVector3);
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            linkedList.addFirst(pair);
            this.pairlist.put(expVector3, linkedList);
        }
        this.P.add(multiVarPowerSeries);
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        this.red.add(bitSet);
        return this.P.size() - 1;
    }

    public int put(List<MultiVarPowerSeries<C>> list) {
        int n = 0;
        for (MultiVarPowerSeries<C> multiVarPowerSeries : list) {
            n = this.put(multiVarPowerSeries);
        }
        return n;
    }

    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<Pair<C>>>> iterator = this.pairlist.entrySet().iterator();
        Pair<C> pair = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            Map.Entry<ExpVector, LinkedList<Pair<C>>> entry = iterator.next();
            ExpVector expVector = entry.getKey();
            LinkedList<Pair<C>> linkedList = entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + expVector));
            }
            pair = null;
            while (!bl && linkedList.size() > 0) {
                pair = linkedList.removeFirst();
                int n = pair.i;
                int n2 = pair.j;
                bl = true;
                if (this.useCriterion4) {
                    bl = this.reduction.criterion4(pair.pi, pair.pj, expVector);
                }
                if (bl && this.useCriterion3) {
                    bl = this.criterion3(n, n2, expVector);
                }
                this.red.get(n2).clear(n);
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
        if (!bl) {
            pair = null;
        } else {
            ++this.remCount;
        }
        return pair;
    }

    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public List<MultiVarPowerSeries<C>> getList() {
        return this.P;
    }

    public synchronized int putCount() {
        return this.putCount;
    }

    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(MultiVarPowerSeries<C> multiVarPowerSeries) {
        ++this.putCount;
        if (multiVarPowerSeries == null) {
            return this.P.size() - 1;
        }
        if (!multiVarPowerSeries.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    public synchronized int putOne() {
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((MultiVarPowerSeries<C>)this.ring.getONE());
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int n, int n2, ExpVector expVector) {
        boolean bl = this.red.get(n2).get(n);
        if (!bl) {
            logger.warn((Object)("c3.s false for " + n2 + " " + n));
            return bl;
        }
        for (int i = 0; i < this.P.size(); ++i) {
            MultiVarPowerSeries<C> multiVarPowerSeries = this.P.get(i);
            ExpVector expVector2 = multiVarPowerSeries.orderExpVector();
            boolean bl2 = expVector.multipleOf(expVector2);
            if (!bl2) continue;
            if (i < n) {
                bl = this.red.get(n).get(i) || this.red.get(n2).get(i);
            } else if (n < i && i < n2) {
                bl = this.red.get(i).get(n) || this.red.get(n2).get(i);
            } else if (n2 < i) {
                boolean bl3 = bl = this.red.get(i).get(n) || this.red.get(i).get(n2);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

