/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix;

public abstract class AbstractMatrix2D
extends AbstractMatrix {
    protected int columns;
    protected int rows;
    protected int rowStride;
    protected int columnStride;
    protected int rowZero;
    protected int columnZero;

    protected AbstractMatrix2D() {
    }

    protected int _columnOffset(int n) {
        return n;
    }

    protected int _columnRank(int n) {
        return this.columnZero + n * this.columnStride;
    }

    protected int _rowOffset(int n) {
        return n;
    }

    protected int _rowRank(int n) {
        return this.rowZero + n * this.rowStride;
    }

    protected void checkBox(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n4 < 0 || n2 + n4 > this.columns || n < 0 || n3 < 0 || n + n3 > this.rows) {
            throw new IndexOutOfBoundsException(this.toStringShort() + ", column:" + n2 + ", row:" + n + " ,width:" + n4 + ", height:" + n3);
        }
    }

    protected void checkColumn(int n) {
        if (n < 0 || n >= this.columns) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at column=" + n);
        }
    }

    protected void checkColumnIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.columns) continue;
            this.checkColumn(n2);
        }
    }

    protected void checkRow(int n) {
        if (n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at row=" + n);
        }
    }

    protected void checkRowIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.rows) continue;
            this.checkRow(n2);
        }
    }

    public void checkShape(AbstractMatrix2D abstractMatrix2D) {
        if (this.columns != abstractMatrix2D.columns || this.rows != abstractMatrix2D.rows) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + " and " + abstractMatrix2D.toStringShort());
        }
    }

    public void checkShape(AbstractMatrix2D abstractMatrix2D, AbstractMatrix2D abstractMatrix2D2) {
        if (this.columns != abstractMatrix2D.columns || this.rows != abstractMatrix2D.rows || this.columns != abstractMatrix2D2.columns || this.rows != abstractMatrix2D2.rows) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + ", " + abstractMatrix2D.toStringShort() + ", " + abstractMatrix2D2.toStringShort());
        }
    }

    public int columns() {
        return this.columns;
    }

    protected int index(int n, int n2) {
        return this._rowOffset(this._rowRank(n)) + this._columnOffset(this._columnRank(n2));
    }

    public int rows() {
        return this.rows;
    }

    protected void setUp(int n, int n2) {
        this.setUp(n, n2, 0, 0, n2, 1);
    }

    protected void setUp(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.rows = n;
        this.columns = n2;
        this.rowZero = n3;
        this.columnZero = n4;
        this.rowStride = n5;
        this.columnStride = n6;
        this.isNoView = true;
        if ((double)n2 * (double)n > 2.147483647E9) {
            throw new IllegalArgumentException("matrix too large");
        }
    }

    public int size() {
        return this.rows * this.columns;
    }

    public String toStringShort() {
        return AbstractFormatter.shape(this);
    }

    protected AbstractMatrix2D vColumnFlip() {
        if (this.columns > 0) {
            this.columnZero += (this.columns - 1) * this.columnStride;
            this.columnStride = -this.columnStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix2D vDice() {
        int n = this.rows;
        this.rows = this.columns;
        this.columns = n;
        n = this.rowStride;
        this.rowStride = this.columnStride;
        this.columnStride = n;
        n = this.rowZero;
        this.rowZero = this.columnZero;
        this.columnZero = n;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix2D vPart(int n, int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        this.rowZero += this.rowStride * n;
        this.columnZero += this.columnStride * n2;
        this.rows = n3;
        this.columns = n4;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix2D vRowFlip() {
        if (this.rows > 0) {
            this.rowZero += (this.rows - 1) * this.rowStride;
            this.rowStride = -this.rowStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix2D vStrides(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal strides: " + n + ", " + n2);
        }
        this.rowStride *= n;
        this.columnStride *= n2;
        if (this.rows != 0) {
            this.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            this.columns = (this.columns - 1) / n2 + 1;
        }
        this.isNoView = false;
        return this;
    }
}

