/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import java.io.IOException;
import java.io.InputStream;

class ThreadLocalInputStream
extends InputStream {
    private InheritableThreadLocal streams = new InheritableThreadLocal();
    private InputStream defaultInputStream = null;

    ThreadLocalInputStream(InputStream defaultInputStream) {
        this.defaultInputStream = defaultInputStream;
        this.init(null);
    }

    void init(InputStream streamForCurrentThread) {
        this.streams.set(streamForCurrentThread);
    }

    InputStream getInputStream() {
        InputStream result = (InputStream)this.streams.get();
        return result == null ? this.defaultInputStream : result;
    }

    public int available() throws IOException {
        return this.getInputStream().available();
    }

    public void close() throws IOException {
        this.getInputStream().close();
    }

    public void mark(int readlimit) {
        this.getInputStream().mark(readlimit);
    }

    public boolean markSupported() {
        return this.getInputStream().markSupported();
    }

    public int read() throws IOException {
        return this.getInputStream().read();
    }

    public int read(byte[] b) throws IOException {
        return this.getInputStream().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getInputStream().read(b, off, len);
    }

    public void reset() throws IOException {
        this.getInputStream().reset();
    }

    public long skip(long n) throws IOException {
        return this.getInputStream().skip(n);
    }
}

